/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcollections.PSet;

public class TabularVisualizer {
    static int NUMBER_OF_INCIDENCES_PER_PAGE = 10;

    public void calculateVertexListAndEdgeList(StateRepository.State state, PSet<GraphElement<?, ?>> elements) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (GraphElement graphElement : elements) {
            if (graphElement instanceof Vertex) {
                Vertex v = (Vertex)graphElement;
                if (!state.selectedVertexClasses.get(v.getAttributedElementClass()).booleanValue()) continue;
                vertices.add(v);
                continue;
            }
            Edge e = (Edge)graphElement;
            if (!state.selectedEdgeClasses.get(e.getAttributedElementClass()).booleanValue()) continue;
            edges.add(e);
        }
        state.verticesOfTableView = vertices.isEmpty() ? null : vertices.toArray(new Vertex[0]);
        state.edgesOfTableView = edges.isEmpty() ? null : edges.toArray(new Edge[0]);
    }

    public void calculateVertexListAndEdgeList(StateRepository.State state) {
        StringBuilder query = new StringBuilder();
        query.append("V").append((CharSequence)state.getVertexTypeSet());
        PSet vertices = (PSet)StateRepository.evaluateGReQL(query.toString(), state.getGraph(), null);
        state.verticesOfTableView = new Vertex[vertices.size()];
        int i = 0;
        for (Vertex v : vertices) {
            state.verticesOfTableView[i++] = v;
        }
        query = new StringBuilder("E");
        query.append((CharSequence)state.getEdgeTypeSet());
        PSet edges = (PSet)StateRepository.evaluateGReQL(query.toString(), state.getGraph(), null);
        state.edgesOfTableView = new Edge[edges.size()];
        i = 0;
        for (Edge e : edges) {
            state.edgesOfTableView[i++] = e;
        }
    }

    public void visualizeElements(StringBuilder code, StateRepository.State state, int numberPerPage, boolean showAttributes, String elementId, boolean jumpToElement, boolean createLinks) {
        boolean isVertex = elementId.startsWith("v");
        code.append("current").append(elementId.charAt(0) == 'v' ? "Vertex" : "Edge").append(" = \"").append(elementId).append("\";\n");
        code.append("var parent = document.getElementById(\"divText").append(elementId.charAt(0) == 'v' ? "Vertex" : "Edge").append("\");\nparent.innerHTML = \"\";\n");
        if ((isVertex ? state.getGraph().getVCount() : state.getGraph().getECount()) == 0) {
            code.append("var divText = document.getElementById(\"divText").append(isVertex ? "Vertex" : "Edge").append("\");\n");
            code.append("var h1=document.createElement(\"h1\");\n");
            code.append("h1.innerHTML = \"This graph doesn't have any ").append(isVertex ? "vertices" : "edges").append(".\";\n");
            code.append("divText.appendChild(h1);\n");
            return;
        }
        code.append("document.getElementById(\"h3HowManyElements\").style.display = \"none\";\n");
        code.append("document.getElementById(\"h3HowManyVertices\").style.display = areVerticesShown() ? \"block\" : \"none\";\n");
        code.append("document.getElementById(\"h3HowManyEdges\").style.display = areVerticesShown() ? \"none\" : \"block\";\n");
        code.append("document.getElementById(\"h3").append(isVertex ? "HowManyVertices" : "HowManyEdges").append("\").innerHTML = \"").append(isVertex ? (state.verticesOfTableView == null ? 0 : state.verticesOfTableView.length) + " of " + state.getGraph().getVCount() + " vertices" : (state.edgesOfTableView == null ? 0 : state.edgesOfTableView.length) + " of " + state.getGraph().getECount() + " edges").append(" visible.\";\n");
        if (elementId.length() == 0 || elementId.length() == 1 || isVertex && (state.verticesOfTableView == null || state.verticesOfTableView.length == 0) || !isVertex && (state.edgesOfTableView == null || state.edgesOfTableView.length == 0)) {
            return;
        }
        int idOfElement = Integer.parseInt(elementId.substring(1));
        int positionOfElementInArray = -1;
        if ((isVertex ? state.selectedVertexClasses : state.selectedEdgeClasses).get((isVertex ? state.getGraph().getVertex(idOfElement) : state.getGraph().getEdge(idOfElement)).getAttributedElementClass()).booleanValue()) {
            for (int i = 0; i < (isVertex ? state.verticesOfTableView : state.edgesOfTableView).length; ++i) {
                if ((isVertex ? state.verticesOfTableView : state.edgesOfTableView)[i].getId() != idOfElement) continue;
                positionOfElementInArray = i;
                break;
            }
        }
        boolean elementWasNotFound = positionOfElementInArray < 0;
        positionOfElementInArray = positionOfElementInArray < 0 ? (positionOfElementInArray + 1) * -1 : positionOfElementInArray;
        int numberOfPages = 1;
        int numberOfPageWithElementOfId = 1;
        if (numberPerPage > 0 && (isVertex ? state.verticesOfTableView : state.edgesOfTableView).length > numberPerPage) {
            int totalNumberOfElements = (isVertex ? state.verticesOfTableView : state.edgesOfTableView).length;
            numberOfPages = totalNumberOfElements / numberPerPage;
            if (totalNumberOfElements % numberPerPage != 0) {
                ++numberOfPages;
            }
            numberOfPageWithElementOfId = positionOfElementInArray / numberPerPage + 1;
            this.createNavigationThroughPages(code, isVertex ? "Vertex" : "Edge", numberOfPages, numberOfPageWithElementOfId, true);
        } else {
            code.append("parent.appendChild(document.createElement(\"br\"));\n");
            code.append("var divText").append(isVertex ? "Vertex" : "Edge").append(" = parent;\n");
        }
        this.createTableDiv(code, isVertex ? "Vertex" : "Edge");
        this.createTable(code, numberOfPageWithElementOfId, numberPerPage, isVertex ? "Vertex" : "Edge", showAttributes, isVertex ? state.verticesOfTableView : state.edgesOfTableView, state.selectedVertexClasses, state.selectedEdgeClasses, createLinks);
        Object elem = state.navigationHistory.get(state.insertPosition - 1);
        String coloredElementId = "";
        if (elem instanceof Vertex) {
            coloredElementId = "v" + ((Vertex)elem).getId();
        } else if (elem instanceof Edge) {
            coloredElementId = "e" + ((Edge)elem).getId();
        }
        code.append("changeBackgroundColor(\"").append(coloredElementId).append("\");\n");
        if (jumpToElement) {
            code.append("document.location.href = \"#").append(elementId).append("\";\n");
        }
        if (elementWasNotFound) {
            code.append("if((").append(isVertex).append(" && areVerticesShown()) || (").append(!isVertex).append(" && !areVerticesShown())){\n");
            code.append("alert(\"The ").append(isVertex ? "vertex " : "edge ").append(elementId).append(" could not be found");
            if (!(isVertex ? state.selectedVertexClasses : state.selectedEdgeClasses).get((isVertex ? state.getGraph().getVertex(idOfElement) : state.getGraph().getEdge(idOfElement)).getAttributedElementClass()).booleanValue()) {
                code.append(" because the type ").append(((GraphElementClass)(isVertex ? state.getGraph().getVertex(idOfElement) : state.getGraph().getEdge(idOfElement)).getAttributedElementClass()).getQualifiedName()).append(" is deselected");
            }
            code.append(". \\nThat's why the first page of the current table is shown.\");\n");
            code.append("}\n");
        }
    }

    private void createTable(StringBuilder code, int numberOfPageWithElementOfId, int numberPerPage, String typeInfix, boolean showAttributes, GraphElement<?, ?>[] graphElements, HashMap<VertexClass, Boolean> selectedVertexClasses, HashMap<EdgeClass, Boolean> selectedEdgeClasses, boolean createLinks) {
        code.append("var mainTable").append(typeInfix).append(" = document.createElement(\"table\");\n");
        code.append("var table").append(typeInfix).append(" = document.createElement(\"thead\");\n");
        code.append("mainTable").append(typeInfix).append(".appendChild(table").append(typeInfix).append(");\n");
        code.append("var currentTr = document.createElement(\"tr\");\n");
        code.append("table").append(typeInfix).append(".appendChild(currentTr);\n");
        this.createCell(code, true, typeInfix, false);
        if (showAttributes) {
            this.createCell(code, true, "Attributes", false);
        }
        this.createCell(code, true, "Incident " + (typeInfix.startsWith("E") ? "vertices" : "edges"), false);
        code.append("var table").append(typeInfix).append(" = document.createElement(\"tbody\");\n");
        code.append("mainTable").append(typeInfix).append(".appendChild(table").append(typeInfix).append(");\n");
        for (int currentElementIndex = (numberOfPageWithElementOfId - 1) * (numberPerPage < 0 ? 0 : numberPerPage); currentElementIndex < graphElements.length && currentElementIndex < (numberPerPage < 0 ? graphElements.length : numberOfPageWithElementOfId * numberPerPage); ++currentElementIndex) {
            GraphElement<?, ?> currentElement = graphElements[currentElementIndex];
            code.append("var currentTr = document.createElement(\"tr\");\n");
            code.append("currentTr.id = \"tr").append(currentElement instanceof Vertex ? "v" : "e").append(currentElement.getId()).append("\";\n");
            code.append("table").append(typeInfix).append(".appendChild(currentTr);\n");
            this.createCell(code, false, this.createElement(currentElement), false);
            code.append("currentTd.onclick = function(){\nclickOnElement(\"").append(currentElement instanceof Vertex ? "v" : "e").append(currentElement.getId()).append("\");\n}\n");
            if (createLinks) {
                code.append("var anker = document.createElement(\"a\");\n");
                code.append("anker.id = \"").append(currentElement instanceof Vertex ? "v" : "e").append(currentElement.getId()).append("\";\n");
                code.append("currentTd.appendChild(anker);\n");
            }
            if (!showAttributes) {
                this.createAttributes(code, currentElement, true);
            }
            if (showAttributes) {
                this.createCell(code, false, "", true);
                this.createAttributes(code, currentElement, false);
                code.append("currentTd.style.textAlign = \"left\";\n");
            }
            this.createCell(code, false, "", true);
            if (currentElement instanceof Vertex) {
                code.append("currentTd.id = \"td").append("v").append(currentElement.getId()).append("\";\n");
                this.createIncidentEdges(code, (Vertex)currentElement, selectedEdgeClasses, selectedVertexClasses, 1, null);
            } else {
                this.createIncidentVertices(code, (Edge)currentElement, selectedVertexClasses);
            }
            code.append("currentTd.style.textAlign = \"left\";\n");
        }
        code.append("div").append(typeInfix).append("Table.appendChild(mainTable").append(typeInfix).append(");\n");
    }

    private String createElement(GraphElement<?, ?> currentElement) {
        return ((GraphElementClass)currentElement.getAttributedElementClass()).getUniqueName() + "<sub>" + Math.abs(currentElement.getId()) + "</sub>";
    }

    private void createAttributes(StringBuilder code, AttributedElement<?, ?> currentElement, boolean inToolTip) {
        this.createAttributes(code, currentElement, inToolTip, null);
    }

    private void createAttributes(StringBuilder code, AttributedElement<?, ?> currentElement, boolean inToolTip, String var) {
        code.append(inToolTip ? (var == null ? "currentTd" : var) + ".title = \"" : "");
        boolean first = true;
        for (Attribute attr : currentElement.getAttributedElementClass().getAttributeList()) {
            if (!first) {
                code.append(inToolTip ? "\t" : (var == null ? "currentTd" : var) + ".appendChild(document.createElement(\"br\"));\n");
            }
            code.append(inToolTip ? "" : (var == null ? "currentTd" : var) + ".appendChild(document.createTextNode(\"");
            code.append(attr.getName()).append(" = ");
            try {
                String content = currentElement.writeAttributeValueToString(attr.getName());
                content = Pattern.compile(Matcher.quoteReplacement("\\")).matcher(content).replaceAll(Matcher.quoteReplacement("\\\\"));
                content = Pattern.compile(Matcher.quoteReplacement("\"")).matcher(content).replaceAll(Matcher.quoteReplacement("\\\""));
                code.append(content.equals("n") ? "null" : (content.equals("t") ? "true" : (content.equals("f") ? "false" : content)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (GraphIOException e) {
                e.printStackTrace();
            }
            code.append(inToolTip ? ";" : ";\"));\n");
            first = false;
        }
        code.append(inToolTip ? "\";\n" : "");
    }

    public void createIncidentEdges(StringBuilder code, Vertex currentVertex, HashMap<EdgeClass, Boolean> selectedEdgeClasses, HashMap<VertexClass, Boolean> selectedVertexClasses, int displayedPage, String vertexTdId) {
        if (vertexTdId != null) {
            code.append("var currentTd = document.getElementById(\"").append(vertexTdId).append("\");\ncurrentTd.innerHTML = \"\";\n");
        }
        int numberOfEdges = 1;
        boolean hasNoLeadingBr = false;
        for (Edge e : currentVertex.incidences()) {
            if (!selectedEdgeClasses.get(e.getAttributedElementClass()).booleanValue()) continue;
            if (numberOfEdges > (displayedPage - 1) * NUMBER_OF_INCIDENCES_PER_PAGE && numberOfEdges <= displayedPage * NUMBER_OF_INCIDENCES_PER_PAGE) {
                if (numberOfEdges > 1) {
                    code.append("currentTd.appendChild(document.createElement(\"br\"));\n");
                } else {
                    hasNoLeadingBr = true;
                }
                code.append("var text = document.createElement(\"b\");\n");
                code.append("text.appendChild(document.createTextNode(").append(this.isOutgoingEdge(currentVertex, e) ? "String.fromCharCode(8594)" : "String.fromCharCode(8592)").append("));\n");
                code.append("text.style.fontSize = \"large\";\n");
                code.append("currentTd.appendChild(text);\n");
                code.append("text = document.createTextNode(\"{\");\n");
                code.append("currentTd.appendChild(text);\n");
                code.append("var aE = document.createElement(\"a\");\n");
                code.append("aE.href = \"javascript:showElement('e").append(Math.abs(e.getId())).append("');\";\n");
                code.append("aE.innerHTML = \"").append(this.createElement(e)).append("\";\n");
                this.createAttributes(code, e.getNormalEdge(), true, "aE");
                code.append("currentTd.appendChild(aE);\n");
                code.append("currentTd.appendChild(document.createTextNode(\"}\"+String.fromCharCode(160)));\n");
                VertexClass qualName = e.getThat().getAttributedElementClass();
                if (selectedVertexClasses.get(qualName).booleanValue()) {
                    code.append("var aThat = document.createElement(\"a\");\n");
                    code.append("aThat.href = \"javascript:showElement('v").append(e.getThat().getId()).append("');\";\n");
                } else {
                    code.append("var aThat = document.createElement(\"span\");\n");
                }
                code.append("aThat.innerHTML= \"").append(this.createElement(e.getThat())).append("\";\n");
                code.append("currentTd.appendChild(aThat);\n");
                this.createAttributes(code, e.getThat(), true, "aThat");
            }
            ++numberOfEdges;
        }
        if (numberOfEdges - 1 > NUMBER_OF_INCIDENCES_PER_PAGE) {
            if (hasNoLeadingBr) {
                code.append("currentTd.insertBefore(document.createElement(\"br\"),currentTd.firstChild);\n");
            }
            int numberOfPages = --numberOfEdges / NUMBER_OF_INCIDENCES_PER_PAGE + (numberOfEdges % NUMBER_OF_INCIDENCES_PER_PAGE == 0 ? 0 : 1);
            this.createNavigationThroughPages(code, "v" + currentVertex.getId(), numberOfPages, displayedPage, false);
        }
    }

    private boolean isOutgoingEdge(Vertex currentVertex, Edge e) {
        return e.isNormal() && e.getAlpha() == currentVertex;
    }

    private void createIncidentVertices(StringBuilder code, Edge currentEdge, HashMap<VertexClass, Boolean> selectedVertexClasses) {
        VertexClass qualName = currentEdge.getAlpha().getAttributedElementClass();
        if (selectedVertexClasses.get(qualName).booleanValue()) {
            code.append("var aAlpha = document.createElement(\"a\");\n");
            code.append("aAlpha.href = \"javascript:showElement('v").append(currentEdge.getAlpha().getId()).append("');\";\n");
        } else {
            code.append("var aAlpha = document.createElement(\"span\");\n");
        }
        code.append("aAlpha.innerHTML= \"").append(this.createElement(currentEdge.getAlpha())).append("\";\n");
        code.append("currentTd.appendChild(aAlpha);\n");
        this.createAttributes(code, currentEdge.getAlpha(), true, "aAlpha");
        code.append("var textNode = document.createTextNode(String.fromCharCode(160));\n");
        code.append("currentTd.appendChild(textNode);\n");
        code.append("var textNode = document.createElement(\"b\");\n");
        code.append("textNode.appendChild(document.createTextNode(String.fromCharCode(8594)));\n");
        code.append("textNode.style.fontSize = \"large\";\n");
        code.append("currentTd.appendChild(textNode);\n");
        code.append("var textNode = document.createTextNode(String.fromCharCode(160));\n");
        code.append("currentTd.appendChild(textNode);\n");
        qualName = currentEdge.getOmega().getAttributedElementClass();
        if (selectedVertexClasses.get(qualName).booleanValue()) {
            code.append("var aOmega = document.createElement(\"a\");\n");
            code.append("aOmega.href = \"javascript:showElement('v").append(currentEdge.getOmega().getId()).append("');\";\n");
        } else {
            code.append("var aOmega = document.createElement(\"span\");\n");
        }
        code.append("aOmega.innerHTML= \"").append(this.createElement(currentEdge.getOmega())).append("\";\n");
        code.append("currentTd.appendChild(aOmega);\n");
        this.createAttributes(code, currentEdge.getOmega(), true, "aOmega");
    }

    private void createCell(StringBuilder code, boolean isHead, String content, boolean isJavaScript) {
        String infix = isHead ? "h" : "d";
        code.append("var currentT").append(infix).append(" = document.createElement(\"t").append(infix).append("\");\n");
        code.append("currentTr.appendChild(currentT").append(infix).append(");\n");
        if (!isJavaScript) {
            code.append("currentT").append(infix).append(".innerHTML=\"").append(content).append("\";\n");
        } else {
            code.append(content);
        }
    }

    private void createNavigationThroughPages(StringBuilder code, String typeInfix, int numberOfPages, int displayedPage, boolean isMainNavigation) {
        if (isMainNavigation) {
            code.append("var divText").append(typeInfix).append(" = document.getElementById(\"divText").append(typeInfix).append("\");\n");
        }
        code.append("var div").append(typeInfix).append("Headline = document.createElement(\"div\");\n");
        code.append("div").append(typeInfix).append("Headline.id = \"div").append(typeInfix).append("Headline\";\n");
        code.append("if(div").append(typeInfix).append("Headline.hasAttribute){\n");
        code.append("div").append(typeInfix).append("Headline.setAttribute(\"class\",\"divHeadline\");\n");
        code.append("}else{\n");
        code.append("div").append(typeInfix).append("Headline.setAttribute(\"className\",\"divHeadline\");\n");
        code.append("}\n");
        if (isMainNavigation) {
            code.append("divText").append(typeInfix).append(".appendChild(div").append(typeInfix).append("Headline);\n");
        } else {
            code.append("currentTd.insertBefore(div").append(typeInfix).append("Headline,currentTd.firstChild);\n");
        }
        if (isMainNavigation) {
            code.append("var brheadline = document.createElement(\"br\");\n");
            code.append("div").append(typeInfix).append("Headline.appendChild(brheadline);\n");
        }
        code.append("var aToBeginning = document.createElement(\"a\");\n");
        code.append("aToBeginning.href = \"javascript:").append(isMainNavigation ? "goToPage" : "goToIncidentPage").append("(1").append(isMainNavigation ? "" : ",'\"+currentTd.id+\"'").append(");\";\n");
        code.append("aToBeginning.innerHTML = \"&lt;&lt;\";\n");
        code.append("div").append(typeInfix).append("Headline.appendChild(aToBeginning);\n");
        code.append("var aToPrevious = document.createElement(\"a\");\n");
        code.append("aToPrevious.href = \"javascript:").append(isMainNavigation ? "goToPage" : "goToIncidentPage").append("(document.getElementById('inputPageNumber").append(typeInfix).append("').value==1?1:document.getElementById('inputPageNumber").append(typeInfix).append("').value-1").append(isMainNavigation ? "" : ",'\"+currentTd.id+\"'").append(");\";\n");
        code.append("aToPrevious.innerHTML = String.fromCharCode(160)+String.fromCharCode(60)+String.fromCharCode(160);\n");
        code.append("div").append(typeInfix).append("Headline.appendChild(aToPrevious);\n");
        code.append("var textPage = document.createTextNode(String.fromCharCode(160)+\"Page\"+String.fromCharCode(160));\n");
        code.append("div").append(typeInfix).append("Headline.appendChild(textPage);\n");
        code.append("var inputPageNumber").append(typeInfix).append(" = document.createElement(\"input\");\n");
        code.append("inputPageNumber").append(typeInfix).append(".id = \"inputPageNumber").append(typeInfix).append("\";\n");
        code.append("inputPageNumber").append(typeInfix).append(".type = \"text\";\n");
        code.append("inputPageNumber").append(typeInfix).append(".size = 6;\n");
        code.append("inputPageNumber").append(typeInfix).append(".value = ").append(displayedPage).append(";\n");
        code.append("inputPageNumber").append(typeInfix).append(".style.textAlign = \"right\";\n");
        code.append("inputPageNumber").append(typeInfix).append(".onchange = function(){\nif(this.value<1){\nthis.value = 1;\n}else if(this.value>").append(numberOfPages).append("){\nthis.value = ").append(numberOfPages).append(";\n}\n").append(isMainNavigation ? "goToPage" : "goToIncidentPage").append("(this.value*1,").append(isMainNavigation ? "true" : "this.parentNode.parentNode.id").append(");\n};\n");
        code.append("div").append(typeInfix).append("Headline.appendChild(inputPageNumber").append(typeInfix).append(");\n");
        code.append("var textMax = document.createTextNode(String.fromCharCode(160)+\"/").append(numberOfPages).append("\"+String.fromCharCode(160));\n");
        code.append("div").append(typeInfix).append("Headline.appendChild(textMax);\n");
        code.append("var aToNext = document.createElement(\"a\");\n");
        code.append("aToNext.href = \"javascript:").append(isMainNavigation ? "goToPage" : "goToIncidentPage").append("(document.getElementById('inputPageNumber").append(typeInfix).append("').value==").append(numberOfPages).append("?").append(numberOfPages).append(":document.getElementById('inputPageNumber").append(typeInfix).append("').value*1+1").append(isMainNavigation ? "" : ",'\"+currentTd.id+\"'").append(");\";\n");
        code.append("aToNext.innerHTML = String.fromCharCode(160)+String.fromCharCode(62)+String.fromCharCode(160);\n");
        code.append("div").append(typeInfix).append("Headline.appendChild(aToNext);\n");
        code.append("var aToEnd = document.createElement(\"a\");\n");
        code.append("aToEnd.href = \"javascript:").append(isMainNavigation ? "goToPage" : "goToIncidentPage").append("(").append(numberOfPages).append(isMainNavigation ? "" : ",'\"+currentTd.id+\"'").append(");\";\n");
        code.append("aToEnd.innerHTML = \"&gt;&gt;\";\n");
        code.append("div").append(typeInfix).append("Headline.appendChild(aToEnd);\n");
        if (isMainNavigation) {
            code.append("var brafterheadline = document.createElement(\"br\");\n");
            code.append("brafterheadline.id = \"brToDelete").append(typeInfix).append("\";\n");
            code.append("divText").append(typeInfix).append(".appendChild(brafterheadline);\n");
        }
    }

    private void createTableDiv(StringBuilder code, String typeInfix) {
        code.append("var div").append(typeInfix).append("Table = document.createElement(\"div\");\n");
        code.append("div").append(typeInfix).append("Table.id = \"div").append(typeInfix).append("Table\";\n");
        code.append("divText").append(typeInfix).append(".appendChild(div").append(typeInfix).append("Table);\n");
    }
}

