/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgschema2java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SchemaJarGenerator {
    private String path;
    private String packageName;
    private String jarFileName;
    private int storeMethod;

    public SchemaJarGenerator(String pathToFiles, String packageName, String jarFileName) {
        this(pathToFiles, packageName, jarFileName, false);
    }

    public SchemaJarGenerator(String pathToFiles, String packageName, String jarFileName, boolean compress) {
        this.path = pathToFiles;
        this.packageName = packageName;
        this.jarFileName = jarFileName;
        this.storeMethod = compress ? 0 : 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJar() throws Exception {
        try (ZipOutputStream zipStream = null;){
            System.out.println("Jar file name is: " + this.jarFileName);
            zipStream = new ZipOutputStream(new FileOutputStream(this.path + "/" + this.jarFileName));
            zipStream.setMethod(this.storeMethod);
            String ifacePackageDir = this.packageName.replaceAll("\\.", "/");
            File interfaceDir = new File(this.path + "/" + ifacePackageDir);
            this.putDirInJar(zipStream, interfaceDir.getAbsolutePath(), ifacePackageDir + "/");
            this.putDirInJar(zipStream, interfaceDir.getAbsolutePath() + "/impl", ifacePackageDir + "/impl/");
            zipStream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDirInJar(ZipOutputStream zipStream, String dirPath, String pathInJar) throws IOException {
        File[] interfaces;
        ZipEntry interfaceDirEntry = new ZipEntry(pathInJar);
        zipStream.putNextEntry(interfaceDirEntry);
        for (File currentInterface : interfaces = new File(dirPath).listFiles()) {
            if (currentInterface.getName().startsWith(".") || currentInterface.isDirectory()) continue;
            ZipEntry entry = new ZipEntry(pathInJar + "/" + currentInterface.getName());
            zipStream.putNextEntry(entry);
            try (FileInputStream in = null;){
                in = new FileInputStream(currentInterface);
                int len = 0;
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) > 0) {
                    zipStream.write(buf, 0, len);
                }
            }
        }
        zipStream.closeEntry();
    }
}

