/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.VertexTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;

class EdgeTreeNode
extends GraphElementTreeNode {
    private Edge e;

    public EdgeTreeNode(Edge e, VertexTreeNode parent) {
        super(parent);
        this.e = e;
    }

    public boolean isBackEdge() {
        Edge pp;
        return this.getParent() != null && this.getParent().getParent() != null && (pp = (Edge)((GraphElementTreeNode)this.getParent().getParent()).get()).getNormalEdge() == this.e.getNormalEdge();
    }

    @Override
    public String getClipboardText() {
        return this.e.getThisRole() + ":" + this.e.getAttributedElementClass().getQualifiedName() + ":" + this.e.getThatRole();
    }

    public String toString() {
        int thisIdx = -1;
        int thatIdx = -1;
        if (this.getParent() != null) {
            thisIdx = this.getParent().getIndex(this) + 1;
        }
        VertexTreeNode child = (VertexTreeNode)this.getChildAt(0);
        Enumeration<GraphElementTreeNode> en = child.children();
        int i = 0;
        while (en.hasMoreElements()) {
            EdgeTreeNode etn = (EdgeTreeNode)en.nextElement();
            ++i;
            if (!etn.isBackEdge()) continue;
            thatIdx = i;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%3d", thisIdx));
        sb.append('/');
        sb.append(String.format("%3d", thatIdx));
        sb.append(" | ");
        sb.append(this.e.toString());
        return sb.toString();
    }

    @Override
    public String getToolTipText() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        String thisRole = this.e.getThisRole();
        String thatRole = this.e.getThatRole();
        if (thisRole != null && !thisRole.isEmpty()) {
            sb.append(thisRole);
        } else {
            sb.append("$noRole$");
        }
        sb.append(" ------- ");
        if (thatRole != null && !thatRole.isEmpty()) {
            sb.append(thatRole);
        } else {
            sb.append("$noRole$");
        }
        sb.append("<br/><br/>");
        sb.append(this.getAttributeString());
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    protected void init() {
        this.incs = new ArrayList();
        this.incs.add(new VertexTreeNode(this.e.getThat(), this));
    }

    @Override
    protected GraphElement<?, ?> get() {
        return this.e;
    }
}

