/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

abstract class GraphElementTreeNode
implements TreeNode {
    protected ArrayList<GraphElementTreeNode> incs;
    protected GraphElementTreeNode parent;

    protected abstract void init();

    protected abstract GraphElement<?, ?> get();

    protected GraphElementTreeNode(GraphElementTreeNode parent) {
        this.parent = parent;
    }

    public Enumeration<GraphElementTreeNode> children() {
        this.init();
        return Collections.enumeration(this.incs);
    }

    @Override
    public boolean getAllowsChildren() {
        this.init();
        return false;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.init();
        return this.incs.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.init();
        return this.incs.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        this.init();
        return this.incs.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        this.init();
        return this.incs.isEmpty();
    }

    public abstract String getToolTipText();

    public abstract String getClipboardText();

    private static String escapeHTML(Object o) {
        if (o == null) {
            return "null";
        }
        String s = o.toString();
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        return s;
    }

    public String getAttributeString() {
        if (((GraphElementClass)this.get().getAttributedElementClass()).getAttributeList().isEmpty()) {
            return "$noAttrs$";
        }
        StringBuilder sb = new StringBuilder();
        for (Attribute attr : ((GraphElementClass)this.get().getAttributedElementClass()).getAttributeList()) {
            sb.append(attr.getName());
            sb.append(" = ");
            sb.append(GraphElementTreeNode.escapeHTML(this.get().getAttribute(attr.getName())));
            sb.append("<br>");
        }
        return sb.toString();
    }
}

