/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.utilities.tgtree.EdgeTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementCellRenderer;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.TGraphTreeModel;
import de.uni_koblenz.jgralab.utilities.tgtree.VertexTreeNode;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;

public class TGTree
extends JFrame {
    private static final long serialVersionUID = 7575497288342049993L;
    private Graph graph;
    private JTree tree;
    JScrollPane scrollPane;

    public TGTree(Graph g) {
        super("TGTree <" + g.getId() + ">");
        this.graph = g;
        JMenuBar menuBar = new JMenuBar();
        JLabel idLabel = new JLabel("Select by id: ");
        menuBar.add(idLabel);
        final JTextField idField = new JTextField();
        menuBar.add(idField);
        idField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String txt = idField.getText();
                char type = txt.charAt(0);
                int id = Integer.parseInt(txt.substring(1));
                if (type == 'v') {
                    TGTree.this.setTreeViewRoot(TGTree.this.graph.getVertex(id));
                } else if (type == 'e') {
                    TGTree.this.setTreeViewRoot(TGTree.this.graph.getEdge(id));
                }
            }
        });
        this.setJMenuBar(menuBar);
        Container cp = this.getContentPane();
        this.tree = new JTree(new TGraphTreeModel(new VertexTreeNode(this.graph.getFirstVertex(), null)));
        this.tree.setCellRenderer(new GraphElementCellRenderer());
        this.tree.addMouseListener(new TreeViewMouseAdapter());
        this.tree.addKeyListener(new TreeViewKeyAdapter());
        int j = 1;
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(j);
            j += 2;
        }
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.tree);
        cp.add(this.scrollPane);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setDefaultCloseOperation(2);
        this.setSize(800, 800);
        this.pack();
    }

    public void setTreeViewRoot(GraphElement<?, ?> ge) {
        GraphElementTreeNode tn = null;
        if (ge instanceof Edge) {
            tn = new EdgeTreeNode((Edge)ge, null);
        } else if (ge instanceof Vertex) {
            tn = new VertexTreeNode((Vertex)ge, null);
        } else {
            throw new RuntimeException(ge + " is neither Vertex nor Edge.");
        }
        this.tree.setModel(new TGraphTreeModel(tn));
        int j = 1;
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(j);
            j += 2;
        }
    }

    public void copySelectionToClipboard(GraphElementTreeNode getn) {
        String selection = getn.getClipboardText();
        System.out.println(selection + " ==> Clipboard");
        StringSelection data = new StringSelection(selection);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, null);
    }

    public static void main(String[] args) throws GraphIOException {
        if (args.length != 1) {
            System.err.println("Usage: TGTree <graphfile>");
            System.exit(1);
        }
        Graph g = GraphIO.loadGraphFromFile(args[0], new ConsoleProgressFunction("Loading"));
        TGTree tgtree = new TGTree(g);
        tgtree.setDefaultCloseOperation(3);
        tgtree.setVisible(true);
    }

    private class TreeViewMouseAdapter
    extends MouseAdapter {
        private TreeViewMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopupTrigger(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopupTrigger(e);
            }
        }

        private void handlePopupTrigger(MouseEvent e) {
            final GraphElementTreeNode getn = (GraphElementTreeNode)TGTree.this.tree.getLastSelectedPathComponent();
            if (getn == null) {
                return;
            }
            JPopupMenu contextMenu = new JPopupMenu("Context Menu");
            contextMenu.add(new AbstractAction("Set Root"){
                private static final long serialVersionUID = 6789881997870852275L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TGTree.this.setTreeViewRoot(getn.get());
                }
            });
            contextMenu.add(new AbstractAction("Copy to Clipboard"){
                private static final long serialVersionUID = 2860962360240219247L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TGTree.this.copySelectionToClipboard(getn);
                }
            });
            contextMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class TreeViewKeyAdapter
    extends KeyAdapter {
        private TreeViewKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            GraphElementTreeNode getn = (GraphElementTreeNode)TGTree.this.tree.getLastSelectedPathComponent();
            if (getn == null) {
                return;
            }
            if (e.getKeyCode() == 10 || e.getKeyChar() == '\n') {
                TGTree.this.setTreeViewRoot(getn.get());
            } else if (e.getKeyChar() == 'c') {
                TGTree.this.copySelectionToClipboard(getn);
            }
        }
    }
}

