/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.utilities.tgtree.EdgeTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementTreeNode;
import java.util.ArrayList;

class VertexTreeNode
extends GraphElementTreeNode {
    private Vertex v;

    public VertexTreeNode(Vertex v, EdgeTreeNode parent) {
        super(parent);
        this.v = v;
    }

    @Override
    protected void init() {
        if (this.incs != null) {
            return;
        }
        this.incs = new ArrayList();
        for (Edge e : this.v.incidences()) {
            this.incs.add(new EdgeTreeNode(e, this));
        }
    }

    @Override
    public String getClipboardText() {
        return this.v.getAttributedElementClass().getQualifiedName();
    }

    public String toString() {
        return this.v.toString();
    }

    @Override
    public String getToolTipText() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(this.getAttributeString());
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    protected GraphElement<?, ?> get() {
        return this.v;
    }
}

