/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg;

import de.uni_koblenz.ist.utilities.xml.XmlProcessor;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.TemporaryVertex;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Attribute;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.References;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Text;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLSchema;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;

public class Xml2Tg
extends XmlProcessor {
    private Set<String> idAttributes = new HashSet<String>();
    private Set<String> idRefAttributes = new HashSet<String>();
    private Set<String> idRefsAttributes = new HashSet<String>();
    private boolean ignoreCharacters;
    private XMLGraph xmlGraph;
    private Map<String, Vertex> idMap = new HashMap<String, Vertex>();
    private Stack<Element> elementStack = new Stack();
    private boolean finished;
    private String fileName;

    public XMLGraph getXmlGraph() {
        if (!this.finished) {
            throw new IllegalStateException("getXmlGraph can only be called after the XML document was fully processed");
        }
        return this.xmlGraph;
    }

    public Element getElementById(String id) {
        if (!this.finished) {
            throw new IllegalStateException("getElementById can only be called after the XML document was fully processed");
        }
        return (Element)this.idMap.get(id);
    }

    public void addIdAttributes(String ... attrNames) {
        for (String s : attrNames) {
            if ((s = s.trim()).isEmpty()) continue;
            this.idAttributes.add(s);
        }
    }

    public void addIdRefAttributes(String ... attrNames) {
        for (String s : attrNames) {
            if ((s = s.trim()).isEmpty()) continue;
            this.idRefAttributes.add(s);
        }
    }

    public void addIdRefsAttributes(String ... attrNames) {
        for (String s : attrNames) {
            if ((s = s.trim()).isEmpty()) continue;
            this.idRefsAttributes.add(s);
        }
    }

    public boolean isIgnoreCharacters() {
        return this.ignoreCharacters;
    }

    public void setIgnoreCharacters(boolean ignoreCharacters) {
        this.ignoreCharacters = ignoreCharacters;
    }

    @Override
    protected void startElement(String name) throws XMLStreamException {
        Element el = null;
        Set<String> attributeNames = this.getAttributeNames();
        for (String attrName : attributeNames) {
            if (!this.idAttributes.contains("*/" + attrName) && !this.idAttributes.contains(name + "/" + attrName)) continue;
            String id = this.getAttribute(attrName);
            Vertex v = this.idMap.get(id);
            el = v != null ? (v.isTemporary() ? (Element)((TemporaryVertex)v).bless(Element.VC) : (Element)v) : this.xmlGraph.createElement();
            this.idMap.put(id, el);
        }
        if (el == null) {
            el = this.xmlGraph.createElement();
        }
        assert (el != null);
        el.set_name(name);
        if (this.getNestingDepth() > 1) {
            this.elementStack.peek().add_children(el);
        }
        this.elementStack.push(el);
        for (String attrName : attributeNames) {
            Attribute attr = this.xmlGraph.createAttribute();
            attr.set_name(attrName);
            attr.set_value(this.getAttribute(attrName));
            el.add_attributes(attr);
            if (this.idRefAttributes.contains("*/" + attrName) || this.idRefAttributes.contains(name + "/" + attrName)) {
                Vertex ref = this.idMap.get(attr.get_value());
                if (ref == null) {
                    ref = this.xmlGraph.createTemporaryVertex();
                    this.idMap.put(attr.get_value(), ref);
                }
                if (ref.isTemporary()) {
                    this.xmlGraph.createTemporaryEdge(References.EC, attr, ref);
                    continue;
                }
                this.xmlGraph.createEdge(References.EC, attr, ref);
                continue;
            }
            if (!this.idRefsAttributes.contains("*/" + attrName) && !this.idRefsAttributes.contains(name + "/" + attrName)) continue;
            for (String val : attr.get_value().split("\\s+")) {
                if ((val = val.trim()).isEmpty()) continue;
                Vertex ref = this.idMap.get(val);
                if (ref == null) {
                    ref = this.xmlGraph.createTemporaryVertex();
                    this.idMap.put(val, ref);
                }
                if (ref.isTemporary()) {
                    this.xmlGraph.createTemporaryEdge(References.EC, attr, ref);
                    continue;
                }
                this.xmlGraph.createEdge(References.EC, attr, ref);
            }
        }
    }

    @Override
    protected void characters(String text) {
        if (this.ignoreCharacters) {
            return;
        }
        super.characters(text);
        Element el = this.elementStack.peek();
        assert (el != null);
        Text t = this.xmlGraph.createText();
        t.set_content(text);
        el.add_texts(t);
    }

    @Override
    protected void endElement(String name, StringBuilder content) throws XMLStreamException {
        Element el = this.elementStack.pop();
        assert (el != null);
        assert (el.get_name().equals(name));
    }

    @Override
    public void process(String fileName) throws FileNotFoundException, XMLStreamException {
        this.fileName = fileName;
        super.process(fileName);
    }

    @Override
    protected void startDocument() throws XMLStreamException {
        this.xmlGraph = XMLSchema.instance().createXMLGraph(ImplementationType.STANDARD, this.fileName, 100, 100);
        this.idMap.clear();
        this.elementStack.clear();
        this.finished = false;
    }

    @Override
    protected void endDocument() throws XMLStreamException {
        ArrayList<String> undefinedRefs = new ArrayList<String>();
        if (this.elementStack.size() > 0) {
            throw new RuntimeException("XML document is malformed");
        }
        for (String id : this.idMap.keySet()) {
            if (!this.idMap.get(id).isTemporary()) continue;
            undefinedRefs.add(id);
        }
        if (undefinedRefs.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String delim = "There are undefined references in the XML document: ";
            for (String id : undefinedRefs) {
                sb.append(delim).append(id);
                delim = ", ";
            }
            throw new RuntimeException(sb.toString());
        }
        this.finished = true;
    }
}

