/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PMap;
import org.pcollections.POrderedMap;
import org.pcollections.PSet;
import org.pcollections.PVector;

public final class ArrayPMap<K, V>
implements POrderedMap<K, V>,
Iterable<AbstractMap.SimpleImmutableEntry<K, V>>,
Serializable {
    private static final long serialVersionUID = -7101801297307300984L;
    private ArrayPSet<K> keys;
    private ArrayPVector<V> values;
    private int hashCode = 0;
    private static ArrayPMap<?, ?> empty = new ArrayPMap(ArrayPSet.empty(), ArrayPVector.empty());

    private ArrayPMap(PSet<K> keys, PVector<V> values) {
        this.keys = (ArrayPSet)keys;
        this.values = (ArrayPVector)values;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0 && this.size() > 0) {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                this.hashCode += entry.hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Map)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Map o = (Map)obj;
        if (o.size() != this.keys.size()) {
            return false;
        }
        Iterator<V> vi = this.values.iterator();
        for (K key : this.keys) {
            V val = vi.next();
            if (val.equals(o.get(key))) continue;
            return false;
        }
        return true;
    }

    public static <T, U> ArrayPMap<T, U> empty() {
        return empty;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        int i = this.keys.toPVector().indexOf(key);
        return i >= 0 ? (V)this.values.get(i) : null;
    }

    @Override
    @Deprecated
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        PSet<Map.Entry<K, V>> entries = ArrayPSet.empty();
        Iterator<V> val = this.values.iterator();
        for (K key : this.keys) {
            entries = entries.plus(new AbstractMap.SimpleImmutableEntry<K, V>(key, val.next()));
        }
        return entries;
    }

    @Override
    public ArrayPMap<K, V> minus(Object key) {
        int i = this.keys.toPVector().indexOf(key);
        return i < 0 ? this : new ArrayPMap<K, V>(this.keys.minus(key), this.values.minus(i));
    }

    @Override
    public ArrayPMap<K, V> minusAll(Collection<?> l) {
        if (l.isEmpty()) {
            return this;
        }
        PMap<K, V> result = this;
        for (Object k : l) {
            result = result.minus(k);
        }
        return result;
    }

    @Override
    public ArrayPMap<K, V> plus(K key, V value) {
        int i = this.keys.toPVector().indexOf(key);
        if (i >= 0) {
            return new ArrayPMap<K, V>(this.keys, this.values.with(i, (Object)value));
        }
        return new ArrayPMap<K, V>(this.keys.plusWithoutCheck(key), this.values.plus((Object)value));
    }

    @Override
    public ArrayPMap<K, V> plusAll(Map<? extends K, ? extends V> m) {
        if (m.isEmpty()) {
            return this;
        }
        PMap<K, V> result = this;
        if (m instanceof ArrayPMap) {
            ArrayPMap o = (ArrayPMap)m;
            Iterator<V> vals = o.values.iterator();
            for (K key : o.keys) {
                result = result.plus((Object)key, (Object)vals.next());
            }
        } else {
            for (Map.Entry<K, V> e : m.entrySet()) {
                result = result.plus((Object)e.getKey(), (Object)e.getValue());
            }
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<>";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<V> val = this.values.iterator();
        String delim = "<";
        for (K key : this.keys) {
            sb.append(delim).append(key).append("=").append(val.next());
            delim = ", ";
        }
        return sb.append(">").toString();
    }

    @Override
    public Iterator<AbstractMap.SimpleImmutableEntry<K, V>> iterator() {
        return new ArrayPMapIterator();
    }

    @Override
    public K keyAt(int idx) {
        return this.keys.get(idx);
    }

    @Override
    public V valueAt(int idx) {
        return this.values.get(idx);
    }

    @Override
    public Map.Entry<K, V> entryAt(int idx) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(this.keyAt(idx), this.valueAt(idx));
    }

    private final class ArrayPMapIterator
    implements Iterator<AbstractMap.SimpleImmutableEntry<K, V>> {
        Iterator<K> ki;
        Iterator<V> vi;

        private ArrayPMapIterator() {
            this.ki = ArrayPMap.this.keys.iterator();
            this.vi = ArrayPMap.this.values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ki.hasNext();
        }

        @Override
        public AbstractMap.SimpleImmutableEntry<K, V> next() {
            return new AbstractMap.SimpleImmutableEntry(this.ki.next(), this.vi.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

