/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.pcollections.ArrayPVector;
import org.pcollections.OrderedPSet;
import org.pcollections.POrderedSet;
import org.pcollections.PVector;

public final class ArrayPSet<E>
implements POrderedSet<E>,
Serializable {
    private static final long serialVersionUID = 5643294766821496614L;
    static final int SIZELIMIT = 16;
    private PVector<E> entries;
    private int hashCode;
    private static ArrayPSet<?> empty = new ArrayPSet(ArrayPVector.empty());

    private ArrayPSet(PVector<E> entries) {
        this.entries = entries;
    }

    public static <T> ArrayPSet<T> empty() {
        return empty;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0 && this.size() > 0) {
            for (Object item : this.entries) {
                this.hashCode += item.hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Set)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Set other = (Set)obj;
        if (other.size() != this.entries.size()) {
            return false;
        }
        for (E item : this) {
            if (other.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.entries.contains(o);
    }

    @Override
    public POrderedSet<E> plus(E e) {
        if (this.contains(e)) {
            return this;
        }
        if (this.entries.size() >= 16) {
            OrderedPSet<E> s = OrderedPSet.empty();
            return s.plusAll(this.entries).plus(e);
        }
        return new ArrayPSet<E>(this.entries.plus(e));
    }

    POrderedSet<E> plusWithoutCheck(E e) {
        return new ArrayPSet<E>(this.entries.plus(e));
    }

    @Override
    public POrderedSet<E> plusAll(Collection<? extends E> list) {
        if (list.isEmpty()) {
            return this;
        }
        POrderedSet<E> r = this;
        for (E e : list) {
            r = r.plus(e);
        }
        return r;
    }

    @Override
    public POrderedSet<E> minus(Object e) {
        return this.contains(e) ? new ArrayPSet<E>(this.entries.minus(e)) : this;
    }

    @Override
    @Deprecated
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entries.toArray(a);
    }

    public PVector<E> toPVector() {
        return this.entries;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public POrderedSet<E> minusAll(Collection<?> list) {
        if (list.isEmpty()) {
            return this;
        }
        POrderedSet<E> r = this;
        for (Object e : list) {
            r = r.minus(e);
        }
        return r;
    }

    @Override
    public E get(int index) {
        return this.entries.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.entries.indexOf(o);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        String delim = "{";
        for (Object e : this.entries) {
            sb.append(delim).append(e);
            delim = ", ";
        }
        return sb.append("}").toString();
    }
}

