/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.pcollections.ArrayPSet;
import org.pcollections.OrderedPSet;
import org.pcollections.POrderedSet;

public class LinkedHashPSet<E>
implements POrderedSet<E> {
    private final LinkedHashSet<E> lhs;
    private final int storedHashCode;

    private LinkedHashPSet(LinkedHashSet<E> l) {
        this.lhs = l;
        this.storedHashCode = this.lhs.hashCode();
    }

    public static <T> LinkedHashPSet<T> immute(LinkedHashSet<T> lhs) {
        return new LinkedHashPSet<T>(lhs);
    }

    private final void checkUnmodified() {
        if (this.storedHashCode != this.lhs.hashCode()) {
            throw new RuntimeException("Backing LinkedHashSet was modified!");
        }
    }

    @Override
    public int hashCode() {
        this.checkUnmodified();
        return this.storedHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        this.checkUnmodified();
        if (obj == null || !(obj instanceof Set)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Set other = (Set)obj;
        if (other.size() != this.lhs.size()) {
            return false;
        }
        for (E item : this) {
            if (other.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final POrderedSet<E> plus(E e) {
        if (this.contains(e)) {
            return this;
        }
        return this.immute(1).plus(e);
    }

    @Override
    public final int size() {
        this.checkUnmodified();
        return this.lhs.size();
    }

    @Override
    public final boolean isEmpty() {
        this.checkUnmodified();
        return this.lhs.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        this.checkUnmodified();
        return this.lhs.contains(o);
    }

    @Override
    public final Iterator<E> iterator() {
        this.checkUnmodified();
        return new ImmutableIterator(this.lhs.iterator());
    }

    @Override
    public final Object[] toArray() {
        this.checkUnmodified();
        return this.lhs.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        this.checkUnmodified();
        return this.lhs.toArray(a);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.lhs.containsAll(c);
    }

    @Override
    public final E get(int index) {
        this.checkUnmodified();
        if (index < 0 || index > this.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        for (Object i : this.lhs) {
            if (index == 0) {
                return i;
            }
            --index;
        }
        throw new RuntimeException();
    }

    @Override
    public final int indexOf(Object o) {
        if (!this.contains(o)) {
            return -1;
        }
        int idx = 0;
        for (E i : this) {
            if (i == o) {
                return idx;
            }
            ++idx;
        }
        throw new RuntimeException();
    }

    @Override
    public final POrderedSet<E> plusAll(Collection<? extends E> list) {
        this.checkUnmodified();
        return this.immute(list.size()).plusAll(list);
    }

    private final POrderedSet<E> immute(int maxAddCount) {
        POrderedSet<Object> r = this.lhs.size() + maxAddCount <= 16 ? ArrayPSet.empty() : OrderedPSet.empty();
        return r.plusAll(this.lhs);
    }

    @Override
    public final POrderedSet<E> minus(Object e) {
        if (!this.contains(e)) {
            return this;
        }
        return this.immute(-1).minus(e);
    }

    @Override
    public final POrderedSet<E> minusAll(Collection<?> list) {
        this.checkUnmodified();
        return this.immute(-list.size()).minusAll(list);
    }

    public final String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        String delim = "{";
        for (Object e : this.lhs) {
            sb.append(delim).append(e);
            delim = ", ";
        }
        return sb.append("}").toString();
    }

    @Override
    @Deprecated
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private static final class ImmutableIterator<E>
    implements Iterator<E> {
        private Iterator<E> it;

        private ImmutableIterator(Iterator<E> i) {
            this.it = i;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

