/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.ant;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CreateMissingPackageDocumentation
extends Task {
    private File srcDir;

    public void setSrcDir(File file) {
        this.srcDir = file;
    }

    public void execute() {
        if (this.srcDir == null) {
            throw new BuildException("No source Folder specified.");
        }
        if (!this.srcDir.exists() || !this.srcDir.isDirectory()) {
            throw new BuildException("No valid source Folder specified.");
        }
        try {
            this.processDirectory(this.srcDir);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private void processDirectory(File file) throws IOException {
        File file2 = new File(file.getAbsoluteFile() + File.separator + "package-info.java");
        File[] fileArray = file.listFiles();
        boolean bl = false;
        for (File file3 : fileArray) {
            if (file3.isDirectory()) {
                this.processDirectory(file3);
            }
            if (bl || !file3.isFile()) continue;
            bl = true;
        }
        if (bl && !file2.exists()) {
            this.createDocumentation(file, file2);
        }
    }

    private void createDocumentation(File file, File file2) throws IOException {
        String string = this.computePackage(file);
        if (string.contains("-")) {
            return;
        }
        System.out.println("Creating " + file2.getName() + " for package " + string);
        PrintWriter printWriter = new PrintWriter(file2);
        printWriter.println("/**");
        printWriter.println(" * TODO [documentation] write documentation for this package.");
        printWriter.println(" */");
        printWriter.println();
        printWriter.print("package ");
        printWriter.print(string);
        printWriter.println(";");
        printWriter.flush();
        printWriter.close();
    }

    private String computePackage(File file) {
        String[] stringArray = this.srcDir.getAbsolutePath().split(File.separator);
        String[] stringArray2 = file.getAbsolutePath().split(File.separator);
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = stringArray.length; i < stringArray2.length; ++i) {
            if (i > stringArray.length) {
                stringBuilder.append(".");
            }
            stringBuilder.append(stringArray2[i]);
        }
        string = stringBuilder.toString();
        return string;
    }

    public static void main(String[] stringArray) {
        CreateMissingPackageDocumentation createMissingPackageDocumentation = new CreateMissingPackageDocumentation();
        createMissingPackageDocumentation.setSrcDir(new File("../jgralab/src"));
        createMissingPackageDocumentation.execute();
        System.out.println("Fini.");
    }
}

