/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.license_header;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class LicenseHeader {
    private static final String XML_ENCODING_PREFIX = "<?xml";
    private static final String INDENT = "    ";
    private static final String JAVA_FIRST_LINE = "/*";
    private static final String JAVA_PREFIX = " * ";
    private static final String JAVA_EMPTY_LINE = " *";
    private static final String JAVA_LAST_LINE = " */";
    private static final String XML_START = "<!-- ";
    private static final String XML_END = " -->";
    private static final String TG_PREFIX = "// ";
    private static final String TG_EMPTY_LINE = "//";
    private File input;
    private File licence;
    private boolean fullyRecursive;
    private boolean verbose;
    private int newlyAdded;
    private int replaced;
    private List<String> javaHeaderLines;
    private List<String> xmlHeaderLines;
    private List<String> tgHeaderLines;

    public static void main(String[] stringArray) {
        CommandLine commandLine = LicenseHeader.processCommandLineOptions(stringArray);
        assert (commandLine.hasOption('i'));
        assert (commandLine.hasOption('l'));
        LicenseHeader licenseHeader = new LicenseHeader(commandLine.getOptionValue('i'), commandLine.getOptionValue('l'), commandLine.hasOption('r'), commandLine.hasOption('V'));
        try {
            licenseHeader.process();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static CommandLine processCommandLineOptions(String[] stringArray) {
        OptionHandler optionHandler = new OptionHandler("java " + LicenseHeader.class.getName(), "1.0");
        Option option = new Option("i", "input", true, "(required): The file or directory to process.");
        option.setRequired(true);
        option.setArgName("fileOrDirectory");
        optionHandler.addOption(option);
        Option option2 = new Option("l", "licence", true, "(required): The file containing the licence header in the correct format. This file should be in plain text without any language specific syntax for comments.");
        option2.setRequired(true);
        option2.setArgName("licenseFile");
        optionHandler.addOption(option2);
        Option option3 = new Option("r", "recursive", false, "(optional): This flag tells the program to process the given directory fully recursively. If only a file is given, this option is ignored. If this flag is not set, only the given directory is processed, without subdirectories.");
        option3.setRequired(false);
        optionHandler.addOption(option3);
        Option option4 = new Option("V", "verbose", false, "(optional): This flag tells the program to be more verbose while processing the files. If it is not set, only a summary will be given in the end.");
        option4.setRequired(false);
        optionHandler.addOption(option4);
        return optionHandler.parse(stringArray);
    }

    public LicenseHeader(String string, String string2, boolean bl, boolean bl2) {
        this.input = new File(string);
        this.licence = new File(string2);
        this.fullyRecursive = bl;
        this.verbose = bl2;
        this.newlyAdded = 0;
        this.replaced = 0;
    }

    private void printIndent(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(INDENT);
        }
    }

    public void process() throws IOException {
        if (!this.input.exists()) {
            throw new FileNotFoundException("The given input file/directory \"" + this.input.getAbsolutePath() + "\" does not exist.");
        }
        if (!this.licence.exists()) {
            throw new FileNotFoundException("The given licence file \"" + this.licence.getAbsolutePath() + "\" does not exist.");
        }
        if (this.licence.isDirectory()) {
            throw new IllegalArgumentException("The given licence file \"" + this.licence.getAbsolutePath() + "\" is a directory");
        }
        if (this.input.isDirectory()) {
            System.out.println("Adding license headers to directory " + this.input.getAbsolutePath() + (this.fullyRecursive ? " and all subdirectories." : " ignoring subdirectories."));
            this.processDirectory(this.input, 0);
        } else {
            System.out.println("Adding license header to file " + this.input.getAbsolutePath());
            this.processJavaFile(this.input, 0, JAVA_FIRST_LINE, JAVA_PREFIX, JAVA_LAST_LINE);
        }
        int n = this.replaced + this.newlyAdded;
        System.out.println();
        System.out.println("Summary:");
        System.out.println("Processed " + n + " files.");
        System.out.println(this.newlyAdded + "/" + n + " files didn't have a license header.");
        System.out.println(this.replaced + "/" + n + " files' headers were replaced by the new one.");
        System.out.println();
    }

    private void processDirectory(final File file, int n) throws IOException {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().equals(".svn");
            }
        });
        File[] fileArray2 = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file2, String string) {
                return file2.getAbsolutePath().equals(file.getAbsolutePath()) && string.toLowerCase().endsWith(".java");
            }
        });
        File[] fileArray3 = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file2, String string) {
                String string2 = string.toLowerCase();
                return file2.getAbsolutePath().equals(file.getAbsolutePath()) && (string2.endsWith(".xml") || string2.endsWith(".xmi"));
            }
        });
        File[] fileArray4 = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file2, String string) {
                return file2.getAbsolutePath().equals(file.getAbsolutePath()) && string.toLowerCase().endsWith(".tg");
            }
        });
        if (this.fullyRecursive) {
            for (File file2 : fileArray) {
                if (this.verbose) {
                    this.printIndent(n);
                    System.out.println("Entering directory " + file2.getName());
                }
                this.processDirectory(file2, n + 1);
                if (!this.verbose) continue;
                this.printIndent(n);
                System.out.println("Leaving directory " + file2.getName());
            }
        }
        for (File file2 : fileArray2) {
            this.processJavaFile(file2, n, JAVA_FIRST_LINE, JAVA_PREFIX, JAVA_LAST_LINE);
        }
        for (File file2 : fileArray3) {
            this.processXMLFile(file2, n, 72);
        }
        for (File file2 : fileArray4) {
            this.processTGFile(file2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processXMLFile(File file, int n, int n2) throws FileNotFoundException, IOException {
        Object object;
        if (this.verbose) {
            this.printIndent(n);
            System.out.println("Processing file " + file.getName());
        }
        if (this.xmlHeaderLines == null) {
            this.cacheXMLHeader(n2);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            object = ParseState.BEFORE_HEADER;
            int n3 = 0;
            Iterator iterator = null;
            do {
                if ((iterator = bufferedReader.readLine()) == null) continue;
                String string2 = ((String)((Object)iterator)).trim();
                switch (5.$SwitchMap$de$uni_koblenz$ist$utilities$license_header$LicenseHeader$ParseState[((Enum)object).ordinal()]) {
                    case 1: {
                        if (string2.length() == 0) {
                            ++n3;
                            break;
                        }
                        if (string2.startsWith(XML_START.trim())) {
                            object = string2.endsWith(XML_END.trim()) ? ParseState.BEFORE_HEADER : ParseState.IN_HEADER;
                            ++n3;
                            break;
                        }
                        if (string2.toLowerCase().startsWith(XML_ENCODING_PREFIX)) {
                            linkedList.add((String)((Object)iterator));
                            break;
                        }
                        assert (string2.startsWith("<"));
                        object = ParseState.AFTER_HEADERS;
                        linkedList.add((String)((Object)iterator));
                        break;
                    }
                    case 2: {
                        ++n3;
                        if (!string2.endsWith(XML_END.trim())) break;
                        object = ParseState.BEFORE_HEADER;
                        break;
                    }
                    case 3: {
                        linkedList.add((String)((Object)iterator));
                    }
                }
            } while (iterator != null);
            if (n3 > 0) {
                if (this.verbose) {
                    this.printIndent(n + 1);
                    System.out.println("Skipped " + n3 + " lines and replaced " + (n3 == 1 ? "it" : "them") + " with new header.");
                }
                ++this.replaced;
            } else {
                if (this.verbose) {
                    this.printIndent(n + 1);
                    System.out.println("Added header.");
                }
                ++this.newlyAdded;
            }
        }
        finally {
            bufferedReader.close();
        }
        object = new PrintWriter(file);
        try {
            String string = (String)linkedList.get(0);
            if (string.trim().startsWith(XML_ENCODING_PREFIX)) {
                ((PrintWriter)object).println(string);
                linkedList.remove(0);
            }
            for (String string2 : this.xmlHeaderLines) {
                ((PrintWriter)object).println(string2);
            }
            for (String string2 : linkedList) {
                ((PrintWriter)object).println(string2);
            }
            ((PrintWriter)object).flush();
        }
        finally {
            ((PrintWriter)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTGFile(File file, int n) throws FileNotFoundException, IOException {
        Object object;
        if (this.verbose) {
            this.printIndent(n);
            System.out.println("Processing file " + file.getName());
        }
        if (this.tgHeaderLines == null) {
            this.cacheTGHeader();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            object = ParseState.IN_HEADER;
            int n2 = 0;
            String string = null;
            do {
                if ((string = bufferedReader.readLine()) == null) continue;
                String string2 = string.trim();
                switch (5.$SwitchMap$de$uni_koblenz$ist$utilities$license_header$LicenseHeader$ParseState[((Enum)object).ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (string2.length() == 0) {
                            ++n2;
                            break;
                        }
                        if (string2.startsWith(TG_EMPTY_LINE)) {
                            if (string.contains("Version :")) {
                                object = ParseState.AFTER_HEADERS;
                                linkedList.add(string);
                            }
                            ++n2;
                            break;
                        }
                        assert (string2.startsWith("TGraph2"));
                        object = ParseState.AFTER_HEADERS;
                        linkedList.add(string);
                        break;
                    }
                    case 3: {
                        linkedList.add(string);
                    }
                }
            } while (string != null);
            if (n2 > 0) {
                if (this.verbose) {
                    this.printIndent(n + 1);
                    System.out.println("Skipped " + n2 + " lines and replaced " + (n2 == 1 ? "it" : "them") + " with new header.");
                }
                ++this.replaced;
            } else {
                if (this.verbose) {
                    this.printIndent(n + 1);
                    System.out.println("Added header.");
                }
                ++this.newlyAdded;
            }
        }
        finally {
            bufferedReader.close();
        }
        object = new PrintWriter(file);
        try {
            for (String string : this.tgHeaderLines) {
                ((PrintWriter)object).println(string);
            }
            for (String string : linkedList) {
                ((PrintWriter)object).println(string);
            }
            ((PrintWriter)object).flush();
        }
        finally {
            ((PrintWriter)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJavaFile(File file, int n, String string, String string2, String string3) throws IOException {
        Object object;
        if (this.verbose) {
            this.printIndent(n);
            System.out.println("Processing file " + file.getName());
        }
        if (this.javaHeaderLines == null) {
            this.cacheJavaHeader(string, string3);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            object = ParseState.BEFORE_HEADER;
            int n2 = 0;
            String string4 = null;
            do {
                if ((string4 = bufferedReader.readLine()) == null) continue;
                switch (5.$SwitchMap$de$uni_koblenz$ist$utilities$license_header$LicenseHeader$ParseState[((Enum)object).ordinal()]) {
                    case 1: {
                        if (string4.trim().startsWith(string.trim()) && !string4.trim().startsWith("/**")) {
                            object = ParseState.IN_HEADER;
                            ++n2;
                            break;
                        }
                        if (string4.contains("package") || string4.contains("import") || string4.contains("class")) {
                            object = ParseState.AFTER_HEADERS;
                        }
                        linkedList.add(string4);
                        break;
                    }
                    case 2: {
                        if (!string4.trim().endsWith(string3.trim())) break;
                        object = ParseState.BEFORE_HEADER;
                        break;
                    }
                    case 3: {
                        linkedList.add(string4);
                    }
                }
            } while (string4 != null);
            if (n2 > 0) {
                if (this.verbose) {
                    this.printIndent(n + 1);
                    System.out.println("Skipped " + n2 + " headers and replaced " + (n2 == 1 ? "it" : "them") + " with new header.");
                }
                ++this.replaced;
            } else {
                if (this.verbose) {
                    this.printIndent(n + 1);
                    System.out.println("Added header.");
                }
                ++this.newlyAdded;
            }
        }
        finally {
            bufferedReader.close();
        }
        object = new PrintWriter(file);
        try {
            for (String string4 : this.javaHeaderLines) {
                ((PrintWriter)object).println(string4);
            }
            for (String string4 : linkedList) {
                ((PrintWriter)object).println(string4);
            }
            ((PrintWriter)object).flush();
        }
        finally {
            ((PrintWriter)object).close();
        }
    }

    private void cacheJavaHeader(String string, String string2) throws FileNotFoundException, IOException {
        if (this.verbose) {
            System.out.println("Caching license header for Java...");
        }
        this.javaHeaderLines = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.licence));
        this.javaHeaderLines.add(string);
        String string3 = null;
        do {
            if ((string3 = bufferedReader.readLine()) == null) continue;
            this.javaHeaderLines.add(string3.isEmpty() ? JAVA_EMPTY_LINE : JAVA_PREFIX + string3);
        } while (string3 != null);
        this.javaHeaderLines.add(string2);
        bufferedReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheXMLHeader(int n) throws FileNotFoundException, IOException {
        if (this.verbose) {
            System.out.println("Caching license header for XML...");
        }
        this.xmlHeaderLines = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.licence));
        try {
            String string = "";
            do {
                if ((string = bufferedReader.readLine()) == null) continue;
                this.xmlHeaderLines.add(this.createXMLHeaderLine(n, string));
            } while (string != null);
            this.xmlHeaderLines.add("");
        }
        finally {
            bufferedReader.close();
        }
    }

    private String createXMLHeaderLine(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(XML_START);
        stringBuilder.append(string);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(XML_END);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheTGHeader() throws FileNotFoundException, IOException {
        if (this.verbose) {
            System.out.println("Caching license header for TG...");
        }
        this.tgHeaderLines = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.licence));
        try {
            String string = "";
            do {
                if ((string = bufferedReader.readLine()) == null) continue;
                this.tgHeaderLines.add((TG_PREFIX + string).trim());
            } while (string != null);
            this.tgHeaderLines.add("");
        }
        finally {
            bufferedReader.close();
        }
    }

    static class 5 {
        static final /* synthetic */ int[] $SwitchMap$de$uni_koblenz$ist$utilities$license_header$LicenseHeader$ParseState;

        static {
            $SwitchMap$de$uni_koblenz$ist$utilities$license_header$LicenseHeader$ParseState = new int[ParseState.values().length];
            try {
                5.$SwitchMap$de$uni_koblenz$ist$utilities$license_header$LicenseHeader$ParseState[ParseState.BEFORE_HEADER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$de$uni_koblenz$ist$utilities$license_header$LicenseHeader$ParseState[ParseState.IN_HEADER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                5.$SwitchMap$de$uni_koblenz$ist$utilities$license_header$LicenseHeader$ParseState[ParseState.AFTER_HEADERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static enum ParseState {
        BEFORE_HEADER,
        IN_HEADER,
        AFTER_HEADERS;

    }
}

