/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.functions.ArrayPermutation;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.problems.CompleteTraversalSolver;
import de.uni_koblenz.jgralab.algolib.problems.TraversalFromVertexSolver;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.BitSetEdgeMarker;
import de.uni_koblenz.jgralab.graphmarker.BitSetVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.IntegerEdgeMarker;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;

public abstract class SearchAlgorithm
extends StructureOrientedAlgorithm
implements TraversalFromVertexSolver,
CompleteTraversalSolver {
    protected Vertex[] vertexOrder;
    protected Edge[] edgeOrder;
    protected BooleanFunction<Vertex> visitedVertices;
    protected BooleanFunction<Edge> visitedEdges;
    protected int num;
    protected int eNum;
    protected IntFunction<Vertex> level;
    protected IntFunction<Vertex> number;
    protected IntFunction<Edge> enumber;
    protected Function<Vertex, Edge> parent;

    public SearchAlgorithm(Graph graph, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
    }

    public SearchAlgorithm(Graph graph) {
        this(graph, null);
    }

    public SearchAlgorithm withLevel() {
        this.checkStateForSettingParameters();
        this.level = new IntegerVertexMarker(this.graph);
        return this;
    }

    public SearchAlgorithm withoutLevel() {
        this.checkStateForSettingParameters();
        this.level = null;
        return this;
    }

    public SearchAlgorithm withNumber() {
        this.checkStateForSettingParameters();
        this.number = new IntegerVertexMarker(this.graph);
        return this;
    }

    public SearchAlgorithm withoutNumber() {
        this.checkStateForSettingParameters();
        this.number = null;
        return this;
    }

    public SearchAlgorithm withENumber() {
        this.checkStateForSettingParameters();
        this.enumber = new IntegerEdgeMarker(this.graph);
        return this;
    }

    public SearchAlgorithm withoutENumber() {
        this.checkStateForSettingParameters();
        this.enumber = null;
        return this;
    }

    public SearchAlgorithm withParent() {
        this.checkStateForSettingParameters();
        this.parent = new ArrayVertexMarker<Edge>(this.graph);
        return this;
    }

    public SearchAlgorithm withoutParent() {
        this.checkStateForSettingParameters();
        this.parent = null;
        return this;
    }

    @Override
    public void disableOptionalResults() {
        this.checkStateForSettingParameters();
        this.level = null;
        this.number = null;
        this.enumber = null;
        this.parent = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.vertexOrder = new Vertex[this.graph.getVCount() + 1];
        this.edgeOrder = new Edge[this.graph.getECount() + 1];
        this.visitedVertices = new BitSetVertexMarker(this.graph);
        this.visitedEdges = new BitSetEdgeMarker(this.graph);
        this.level = this.level == null ? null : new IntegerVertexMarker(this.graph);
        this.number = this.number == null ? null : new IntegerVertexMarker(this.graph);
        this.enumber = this.enumber == null ? null : new IntegerEdgeMarker(this.graph);
        this.parent = this.parent == null ? null : new ArrayVertexMarker(this.graph);
        this.num = 1;
        this.eNum = 1;
    }

    public Vertex[] getInternalVertexOrder() {
        return this.vertexOrder;
    }

    public Edge[] getInternalEdgeOrder() {
        return this.edgeOrder;
    }

    public BooleanFunction<Vertex> getVisitedVertices() {
        return this.visitedVertices;
    }

    public BooleanFunction<Edge> getVisitedEdges() {
        return this.visitedEdges;
    }

    public int getNum() {
        return this.num;
    }

    public int getENum() {
        return this.eNum;
    }

    public IntFunction<Vertex> getInternalLevel() {
        return this.level;
    }

    public IntFunction<Vertex> getInternalNumber() {
        return this.number;
    }

    public IntFunction<Edge> getInternalEnumber() {
        return this.enumber;
    }

    public Function<Vertex, Edge> getInternalParent() {
        return this.parent;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public abstract SearchAlgorithm execute(Vertex var1) throws AlgorithmTerminatedException;

    @Override
    public SearchAlgorithm execute() throws AlgorithmTerminatedException {
        if (this.graph.getVCount() > 0) {
            for (Vertex vertex : this.graph.vertices()) {
                this.execute(vertex);
                if (this.state != AlgorithmStates.FINISHED) continue;
                break;
            }
        } else {
            this.done();
        }
        assert (this.state == AlgorithmStates.FINISHED);
        return this;
    }

    @Override
    protected void done() {
        if (this.state != AlgorithmStates.CANCELED) {
            this.state = this.num < this.graph.getVCount() + 1 ? AlgorithmStates.STOPPED : AlgorithmStates.FINISHED;
        }
    }

    @Override
    public Permutation<Vertex> getVertexOrder() {
        this.checkStateForResult();
        return new ArrayPermutation<Vertex>(this.vertexOrder);
    }

    @Override
    public Permutation<Edge> getEdgeOrder() {
        this.checkStateForResult();
        return new ArrayPermutation<Edge>(this.edgeOrder);
    }

    public IntFunction<Vertex> getLevel() {
        this.checkStateForResult();
        return this.level;
    }

    public IntFunction<Vertex> getNumber() {
        this.checkStateForResult();
        return this.number;
    }

    public IntFunction<Edge> getEnumber() {
        this.checkStateForResult();
        return this.enumber;
    }

    public Function<Vertex, Edge> getParent() {
        this.checkStateForResult();
        return this.parent;
    }
}

