/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca;

import de.uni_koblenz.jgralab.eca.Action;
import de.uni_koblenz.jgralab.eca.Condition;
import de.uni_koblenz.jgralab.eca.ECAIOException;
import de.uni_koblenz.jgralab.eca.ECARule;
import de.uni_koblenz.jgralab.eca.GreqlCondition;
import de.uni_koblenz.jgralab.eca.PrintAction;
import de.uni_koblenz.jgralab.eca.events.ChangeAttributeEventDescription;
import de.uni_koblenz.jgralab.eca.events.ChangeEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.CreateEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.CreateVertexEventDescription;
import de.uni_koblenz.jgralab.eca.events.DeleteEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.DeleteVertexEventDescription;
import de.uni_koblenz.jgralab.eca.events.EventDescription;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.eca.GretlTransformAction;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ECAIO {
    private static final int BUFFER_SIZE = 65536;
    private Schema schema;
    private List<ECARule<?>> rules = new ArrayList();
    private BufferedInputStream inStream;
    private DataOutputStream outStream;
    int la;

    public static List<ECARule<?>> loadECArules(Schema schema, String string) throws ECAIOException {
        List<ECARule<?>> list;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string), 65536);
            ECAIO eCAIO = new ECAIO();
            eCAIO.inStream = bufferedInputStream;
            eCAIO.schema = schema;
            eCAIO.load();
            list = eCAIO.rules;
        }
        catch (IOException iOException) {
            try {
                throw new ECAIOException("Error while reading file " + string);
            }
            catch (Throwable throwable) {
                ECAIO.close(bufferedInputStream);
                throw throwable;
            }
        }
        ECAIO.close(bufferedInputStream);
        return list;
    }

    public static void saveECArules(Schema schema, String string, List<ECARule<?>> list) throws ECAIOException {
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string), 65536));
            ECAIO eCAIO = new ECAIO();
            eCAIO.rules = list;
            eCAIO.schema = schema;
            eCAIO.outStream = dataOutputStream;
            eCAIO.save();
        }
        catch (IOException iOException) {
            try {
                throw new ECAIOException("Error while saving ECA rules to " + string);
            }
            catch (Throwable throwable) {
                ECAIO.close(dataOutputStream);
                throw throwable;
            }
        }
        ECAIO.close(dataOutputStream);
    }

    private ECAIO() {
    }

    private void save() throws ECAIOException {
        for (ECARule<?> eCARule : this.rules) {
            this.saveRule(eCARule);
        }
    }

    private void saveRule(ECARule<?> eCARule) throws ECAIOException {
        this.saveEventDescriptionToStream(eCARule.getEventDescription());
        if (eCARule.getCondition() != null) {
            this.saveConditionToStream(eCARule.getCondition());
        }
        this.saveActionToStream(eCARule.getAction());
    }

    private void saveEventDescriptionToStream(EventDescription<?> eventDescription) throws ECAIOException {
        String string = "";
        if (eventDescription.getContext().equals((Object)EventDescription.Context.EXPRESSION)) {
            string = string + eventDescription.getContextExpression();
            string = string + " : ";
        }
        string = eventDescription.getTime().equals((Object)EventDescription.EventTime.AFTER) ? string + "after " : string + "before ";
        string = string + this.getEventDescriptionType(eventDescription);
        this.writeToStream(string);
    }

    private String getEventDescriptionType(EventDescription<?> eventDescription) {
        if (eventDescription instanceof CreateVertexEventDescription) {
            return "createdVertex(" + this.getEventElementTypeString(eventDescription) + ") ";
        }
        if (eventDescription instanceof DeleteVertexEventDescription) {
            return "deletedVertex(" + this.getEventElementTypeString(eventDescription) + ") ";
        }
        if (eventDescription instanceof ChangeAttributeEventDescription) {
            return "updatedAttributeValue(" + this.getEventElementTypeString(eventDescription) + ", " + ((ChangeAttributeEventDescription)eventDescription).getConcernedAttribute() + ")";
        }
        if (eventDescription instanceof ChangeEdgeEventDescription) {
            if (((ChangeEdgeEventDescription)eventDescription).getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.ALPHA)) {
                return "updatedStartVertex(" + this.getEventElementTypeString(eventDescription) + ") ";
            }
            if (((ChangeEdgeEventDescription)eventDescription).getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.OMEGA)) {
                return "updatedEndVertex(" + this.getEventElementTypeString(eventDescription) + ") ";
            }
            return "updatedStartOrEndVertex(" + this.getEventElementTypeString(eventDescription) + ") ";
        }
        if (eventDescription instanceof CreateEdgeEventDescription) {
            return "createdEdge(" + this.getEventElementTypeString(eventDescription) + ") ";
        }
        return "deletedEdge(" + this.getEventElementTypeString(eventDescription) + ") ";
    }

    private String getEventElementTypeString(EventDescription<?> eventDescription) {
        String string = "";
        if (eventDescription.getContext().equals((Object)EventDescription.Context.TYPE)) {
            string = string + eventDescription.getType().getQualifiedName().replace(this.schema.getPackagePrefix() + ".", "");
        }
        return string;
    }

    private void saveConditionToStream(Condition<?> condition) throws ECAIOException {
        if (condition instanceof GreqlCondition) {
            this.writeToStream(" with \"" + ((GreqlCondition)condition).getConditionExpression() + "\" ");
        } else {
            this.writeToStream(" with class " + condition.getClass().getName() + " ");
        }
    }

    private void saveActionToStream(Action<?> action) throws ECAIOException {
        String string = "do ";
        if (action instanceof PrintAction) {
            string = string + "print \"";
            string = string + ((PrintAction)action).getMessage();
            string = string + "\"";
            string = string + "\n";
        } else if (action instanceof GretlTransformAction) {
            GretlTransformAction gretlTransformAction = (GretlTransformAction)action;
            string = string + gretlTransformAction.getTransformationClass().getName();
        } else {
            string = string + action.getClass().getName();
        }
        this.writeToStream(string);
    }

    private void writeToStream(String string) throws ECAIOException {
        try {
            this.outStream.writeChars(string);
        }
        catch (IOException iOException) {
            throw new ECAIOException("Error while writing " + string + " to stream.");
        }
    }

    private void load() throws ECAIOException {
        this.la = 0;
        while (this.la != -1) {
            this.parseRule();
            this.skipWs();
        }
    }

    private void parseRule() throws ECAIOException {
        EventDescription<?> eventDescription = this.parseEventDescription();
        Condition<?> condition = this.parseCondition();
        Action<?> action = this.parseAction();
        if (condition == null) {
            this.rules.add(new ECARule(eventDescription, action));
        } else {
            this.rules.add(new ECARule(eventDescription, condition, action));
        }
    }

    private EventDescription<?> parseEventDescription() throws ECAIOException {
        String string = null;
        String string2 = this.nextToken();
        String string3 = this.nextToken();
        if (string3.equals(":")) {
            string = string2;
            string2 = this.nextToken();
            string3 = this.nextToken();
        }
        EventDescription.EventTime eventTime = this.getEventTime(string2);
        String string4 = string3;
        String string5 = null;
        this.match("(");
        if (string == null) {
            string5 = this.nextToken();
        }
        if (string4.equals("updatedAttributeValue")) {
            this.match(",");
            return this.finishChangeAttributeEventDescription(string, eventTime, string5);
        }
        this.match(")");
        if (string4.equals("createdVertex")) {
            return this.finishCreateVertexEvent(string, eventTime, string5);
        }
        if (string4.equals("createdEdge")) {
            return this.finishCreateEdgeEventDescription(string, eventTime, string5);
        }
        if (string4.equals("updatedStartVertex")) {
            return this.finishChangeEdgeEventDescription(string, eventTime, string5, ChangeEdgeEventDescription.EdgeEnd.ALPHA);
        }
        if (string4.equals("updatedEndVertex")) {
            return this.finishChangeEdgeEventDescription(string, eventTime, string5, ChangeEdgeEventDescription.EdgeEnd.OMEGA);
        }
        if (string4.equals("updatedStartOrEndVertex")) {
            return this.finishChangeEdgeEventDescription(string, eventTime, string5, ChangeEdgeEventDescription.EdgeEnd.ANY);
        }
        if (string4.equals("deletedVertex")) {
            return this.finishDeleteVertexEventDescription(string, eventTime, string5);
        }
        if (string4.equals("deletedEdge")) {
            return this.finishDeleteEdgeEventDescription(string, eventTime, string5);
        }
        throw new ECAIOException("Type of EventDescription not recognized. Found " + string4 + " Possible are \"createVertex\", \"deleteVertex\", " + "\"createEdge\", \"deleteEdge\", " + "\"updatedStartVertex\", \"updatedEndVertex\", " + "\"updatedStartOrEndVertex\"" + "\"changeAttributeValue");
    }

    private EventDescription.EventTime getEventTime(String string) throws ECAIOException {
        EventDescription.EventTime eventTime;
        if (string.equals("after")) {
            eventTime = EventDescription.EventTime.AFTER;
        } else if (string.equals("before")) {
            eventTime = EventDescription.EventTime.BEFORE;
        } else {
            throw new ECAIOException("EventTime expected. Possible are \"before\" and \"after\". Found: \"" + string + "\" ");
        }
        return eventTime;
    }

    private EventDescription<EdgeClass> finishDeleteEdgeEventDescription(String string, EventDescription.EventTime eventTime, String string2) throws ECAIOException {
        if (string != null && string2 == null) {
            return new DeleteEdgeEventDescription(eventTime, string);
        }
        if (string == null && string2 != null) {
            return new DeleteEdgeEventDescription(eventTime, (EdgeClass)this.getAttributedElementClass(string2));
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + string + "\" and GraphElementType: \"" + string2 + "\"");
    }

    private EventDescription<VertexClass> finishDeleteVertexEventDescription(String string, EventDescription.EventTime eventTime, String string2) throws ECAIOException {
        if (string != null && string2 == null) {
            return new DeleteVertexEventDescription(eventTime, string);
        }
        if (string == null && string2 != null) {
            return new DeleteVertexEventDescription(eventTime, (VertexClass)this.getAttributedElementClass(string2));
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + string + "\" and type: \"" + string2 + "\"");
    }

    private EventDescription<EdgeClass> finishChangeEdgeEventDescription(String string, EventDescription.EventTime eventTime, String string2, ChangeEdgeEventDescription.EdgeEnd edgeEnd) throws ECAIOException {
        if (string != null && string2 == null) {
            return new ChangeEdgeEventDescription(eventTime, string);
        }
        if (string == null && string2 != null) {
            return new ChangeEdgeEventDescription(eventTime, (EdgeClass)this.getAttributedElementClass(string2), edgeEnd);
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + string + "\" and type: \"" + string2 + "\"");
    }

    private EventDescription<?> finishChangeAttributeEventDescription(String string, EventDescription.EventTime eventTime, String string2) throws ECAIOException {
        String string3 = this.nextToken();
        this.match(")");
        if (string != null && string2 == null) {
            return new ChangeAttributeEventDescription(eventTime, string, string3);
        }
        if (string == null && string2 != null) {
            return new ChangeAttributeEventDescription(eventTime, this.getAttributedElementClass(string2), string3);
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + string + "\" and type: \"" + string2 + "\"");
    }

    private EventDescription<EdgeClass> finishCreateEdgeEventDescription(String string, EventDescription.EventTime eventTime, String string2) throws ECAIOException {
        if (string != null && string2 == null) {
            return new CreateEdgeEventDescription(eventTime, string);
        }
        if (string == null && string2 != null) {
            return new CreateEdgeEventDescription(eventTime, (EdgeClass)this.getAttributedElementClass(string2));
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + string + "\" and type: \"" + string2 + "\"");
    }

    private EventDescription<VertexClass> finishCreateVertexEvent(String string, EventDescription.EventTime eventTime, String string2) throws ECAIOException {
        if (string != null && string2 == null) {
            return new CreateVertexEventDescription(eventTime, string);
        }
        if (string == null && string2 != null) {
            return new CreateVertexEventDescription(eventTime, (VertexClass)this.getAttributedElementClass(string2));
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + string + "\" and type: \"" + string2 + "\"");
    }

    private AttributedElementClass<?, ?> getAttributedElementClass(String string) {
        return this.schema.getAttributedElementClass(string);
    }

    private Condition<?> parseCondition() throws ECAIOException {
        String string = this.nextToken();
        if (this.isMatching(string, "do")) {
            return null;
        }
        if (this.isMatching(string, "with")) {
            String string2 = this.nextToken();
            if (string2.equals("class")) {
                Condition condition;
                string2 = this.nextToken();
                try {
                    Condition condition2;
                    System.out.println("classname: " + string2);
                    Class<?> clazz = Class.forName(string2);
                    condition = condition2 = (Condition)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ECAIOException("Specified Condition " + string + " not found.");
                }
                catch (InstantiationException instantiationException) {
                    throw new ECAIOException("Error while instanciating Condition " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ECAIOException("Error while instanciating Condition " + string);
                }
                this.match("do");
                return condition;
            }
            this.match("do");
            return new GreqlCondition(string2);
        }
        throw new ECAIOException("Parsing Error. Expected \"do\" or \"with\". Found: \"" + string + "\"");
    }

    private Action<?> parseAction() throws ECAIOException {
        String string = this.nextToken();
        if (this.isMatching("print", string)) {
            String string2 = this.nextToken();
            return new PrintAction(string2);
        }
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz.getSuperclass().equals(Transformation.class)) {
                return new GretlTransformAction(clazz);
            }
            return (Action)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ECAIOException("Specified Action " + string + " not found.");
        }
        catch (InstantiationException instantiationException) {
            throw new ECAIOException("Error while instanciating Action " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ECAIOException("Error while instanciating Action " + string);
        }
    }

    private boolean isMatching(String string, String string2) {
        return string.equals(string2);
    }

    private void match(String string) throws ECAIOException {
        String string2 = this.nextToken();
        if (!string2.equals(string)) {
            throw new ECAIOException("Parsing Error: Expected \"" + string + "\" Found: \"" + string2 + "\"");
        }
    }

    private String nextToken() throws ECAIOException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.skipWs();
            if (this.la == 34) {
                this.readUtfString(stringBuilder);
            } else if (this.isUnitSymbol(this.la)) {
                stringBuilder.append((char)this.la);
                this.la = this.inStream.read();
            } else if (this.la != -1) {
                do {
                    stringBuilder.append((char)this.la);
                    this.la = this.inStream.read();
                } while (!this.isWs(this.la) && !this.isUnitSymbol(this.la) && this.la != -1);
            }
        }
        catch (IOException iOException) {
            throw new ECAIOException("Error while reading next token from stream.");
        }
        return this.myTrim0(stringBuilder.toString());
    }

    private final void skipWs() throws ECAIOException {
        while (this.isWs(this.la) || this.la == 0) {
            try {
                this.la = this.inStream.read();
            }
            catch (IOException iOException) {
                throw new ECAIOException("Error while reading from stream.");
            }
        }
    }

    private String myTrim0(String string) {
        char[] cArray = string.toCharArray();
        String string2 = "";
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\u0000') continue;
            string2 = string2 + cArray[i];
        }
        return string2;
    }

    private boolean isWs(int n) {
        return n == 32 || n == 10 || n == 9 || n == 13;
    }

    private boolean isUnitSymbol(int n) {
        return n == 62 || n == 60 || n == 40 || n == 41 || n == 44;
    }

    private final void readUtfString(StringBuilder stringBuilder) throws IOException {
        this.la = this.inStream.read();
        block10: while (this.la != -1 && this.la != 34) {
            if (this.la == 0) {
                this.la = this.inStream.read();
                continue;
            }
            if (this.la < 32 || this.la > 127) {
                throw new RuntimeException("invalid character '" + (char)this.la + "'");
            }
            if (this.la == 92) {
                this.la = this.inStream.read();
                if (this.la == -1) break;
                switch (this.la) {
                    case 92: {
                        this.la = 92;
                        break;
                    }
                    case 34: {
                        this.la = 34;
                        break;
                    }
                    case 110: {
                        this.la = 10;
                        break;
                    }
                    case 114: {
                        this.la = 13;
                        break;
                    }
                    case 116: {
                        this.la = 9;
                        break;
                    }
                    case 117: {
                        this.la = this.inStream.read();
                        if (this.la == -1) break block10;
                        String string = "" + (char)this.la;
                        this.la = this.inStream.read();
                        if (this.la == -1) break block10;
                        string = string + (char)this.la;
                        this.la = this.inStream.read();
                        if (this.la == -1) break block10;
                        string = string + (char)this.la;
                        this.la = this.inStream.read();
                        if (this.la == -1) break block10;
                        string = string + (char)this.la;
                        try {
                            this.la = Integer.parseInt(string, 16);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new RuntimeException("invalid unicode escape sequence '\\u" + string);
                        }
                    }
                    default: {
                        throw new RuntimeException("invalid escape sequence in string");
                    }
                }
            }
            stringBuilder.append((char)this.la);
            this.la = this.inStream.read();
        }
        this.la = this.inStream.read();
    }

    private static void close(Closeable closeable) throws ECAIOException {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            throw new ECAIOException("Exception while closing the stream.", iOException);
        }
    }
}

