/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.ArrayGraphMarkerIterator;
import de.uni_koblenz.jgralab.graphmarker.BitSetGraphMarker;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BitSetVertexMarker
extends BitSetGraphMarker<Vertex> {
    public BitSetVertexMarker(Graph graph) {
        super(graph);
    }

    @Override
    public void vertexDeleted(Vertex vertex) {
        this.removeMark(vertex);
    }

    @Override
    public void edgeDeleted(Edge edge) {
    }

    @Override
    public Iterable<Vertex> getMarkedElements() {
        return new Iterable<Vertex>(){

            @Override
            public Iterator<Vertex> iterator() {
                return new ArrayGraphMarkerIterator<Vertex>(BitSetVertexMarker.this.version){

                    @Override
                    public boolean hasNext() {
                        return this.index != -1;
                    }

                    @Override
                    protected void moveIndex() {
                        this.index = BitSetVertexMarker.this.marks.nextSetBit(++this.index);
                    }

                    @Override
                    public Vertex next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException(NO_MORE_ELEMENTS_ERROR_MESSAGE);
                        }
                        if (this.version != BitSetVertexMarker.this.version) {
                            throw new ConcurrentModificationException(MODIFIED_ERROR_MESSAGE);
                        }
                        Vertex vertex = BitSetVertexMarker.this.graph.getVertex(this.index);
                        this.moveIndex();
                        return vertex;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<Vertex> getDomainElements() {
        return this.graph.vertices();
    }
}

