/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.DoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.entries.DoubleFunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.Iterator;

public abstract class DoubleGraphMarker<T extends GraphElement<?, ?>>
extends AbstractGraphMarker<T>
implements DoubleFunction<T> {
    protected double[] temporaryAttributes;
    protected int marked;
    protected long version;

    protected DoubleGraphMarker(Graph graph, int n) {
        super(graph);
        this.temporaryAttributes = this.createNewArray(n);
        this.marked = 0;
    }

    private double[] createNewArray(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.NaN;
        }
        return dArray;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.temporaryAttributes.length; ++i) {
            this.temporaryAttributes[i] = Double.NaN;
        }
        this.marked = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.marked == 0;
    }

    @Override
    public boolean isMarked(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return !Double.isNaN(this.temporaryAttributes[t.getId()]);
    }

    public double mark(T t, double d) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        double d2 = this.temporaryAttributes[t.getId()];
        this.temporaryAttributes[t.getId()] = d;
        ++this.marked;
        ++this.version;
        return d2;
    }

    public double getMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        double d = this.temporaryAttributes[t.getId()];
        return d;
    }

    @Override
    public boolean removeMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        if (Double.isNaN(this.temporaryAttributes[t.getId()])) {
            return false;
        }
        this.temporaryAttributes[t.getId()] = Double.NaN;
        --this.marked;
        ++this.version;
        return true;
    }

    @Override
    public int size() {
        return this.marked;
    }

    public int maxSize() {
        return this.temporaryAttributes.length - 1;
    }

    protected void expand(int n) {
        assert (n > this.temporaryAttributes.length);
        double[] dArray = this.createNewArray(n);
        System.arraycopy(this.temporaryAttributes, 0, dArray, 0, this.temporaryAttributes.length);
        this.temporaryAttributes = dArray;
    }

    @Override
    public double get(T t) {
        return this.getMark(t);
    }

    @Override
    public boolean isDefined(T t) {
        return this.isMarked(t);
    }

    @Override
    public void set(T t, double d) {
        this.mark(t, d);
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<DoubleFunctionEntry<T>> iterator() {
        final Iterator iterator = this.getMarkedElements().iterator();
        return new Iterator<DoubleFunctionEntry<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public DoubleFunctionEntry<T> next() {
                GraphElement graphElement = (GraphElement)iterator.next();
                return new DoubleFunctionEntry<GraphElement>(graphElement, DoubleGraphMarker.this.get(graphElement));
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

