/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.executable;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.executable.PathSystemMarkerEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutableSliceHelper {
    public static boolean isMarked(List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> list, Vertex vertex, int n) {
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker = list.get(n);
        Map map = (Map)graphMarker.getMark(vertex);
        return map != null;
    }

    public static boolean isMarked(List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> list, Vertex vertex, int n, Edge edge) {
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker = list.get(n);
        Map map = (Map)graphMarker.getMark(vertex);
        if (map != null) {
            return map.containsKey(edge);
        }
        return false;
    }

    public static boolean markVertex(List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> list, Vertex vertex, int n, boolean bl, Vertex vertex2, Edge edge, int n2, int n3) {
        PathSystemMarkerEntry pathSystemMarkerEntry;
        PathSystemMarkerEntry pathSystemMarkerEntry2 = new PathSystemMarkerEntry(vertex, vertex2, edge, n, bl, n2, n3);
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker = list.get(n);
        HashMap<Edge, PathSystemMarkerEntry> hashMap = (HashMap<Edge, PathSystemMarkerEntry>)graphMarker.getMark(vertex);
        if (hashMap == null) {
            hashMap = new HashMap<Edge, PathSystemMarkerEntry>();
            graphMarker.mark(vertex, hashMap);
        }
        if ((pathSystemMarkerEntry = (PathSystemMarkerEntry)hashMap.get(edge)) == null) {
            hashMap.put(edge, pathSystemMarkerEntry2);
            return true;
        }
        return false;
    }

    public static SubGraphMarker createSliceFromMarkings(Graph graph, Set<Vertex> set, List<Vertex> list, List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> list2) {
        SubGraphMarker subGraphMarker = new SubGraphMarker(graph);
        for (Vertex vertex2 : set) {
            subGraphMarker.mark(vertex2);
        }
        LinkedList linkedList = new LinkedList();
        int n = -1;
        GraphMarker<Set<Integer>> graphMarker = new GraphMarker<Set<Integer>>(graph);
        GraphMarker<Integer> graphMarker2 = new GraphMarker<Integer>(graph);
        for (Vertex vertex : list) {
            for (GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker3 : list2) {
                if (graphMarker3.getMark(vertex) == null) continue;
                for (PathSystemMarkerEntry pathSystemMarkerEntry : ((Map)graphMarker3.getMark(vertex)).values()) {
                    if (!pathSystemMarkerEntry.stateIsFinal || ExecutableSliceHelper.isVertexMarkedWithState(vertex, pathSystemMarkerEntry.stateNumber, graphMarker)) continue;
                    ExecutableSliceHelper.markVertexWithState(vertex, pathSystemMarkerEntry.stateNumber, graphMarker);
                    graphMarker2.mark(vertex, pathSystemMarkerEntry.stateNumber);
                    linkedList.add(vertex);
                    while (!linkedList.isEmpty()) {
                        Vertex vertex2;
                        vertex2 = (Vertex)linkedList.poll();
                        for (PathSystemMarkerEntry pathSystemMarkerEntry2 : ExecutableSliceHelper.getMarkersWithState(vertex2, (Integer)graphMarker2.getMark(vertex2), list2).values()) {
                            Vertex vertex3;
                            n = pathSystemMarkerEntry2.parentStateNumber;
                            subGraphMarker.mark(vertex2);
                            if (pathSystemMarkerEntry2.edgeToParentVertex != null) {
                                subGraphMarker.mark(pathSystemMarkerEntry2.edgeToParentVertex);
                            }
                            if ((vertex3 = pathSystemMarkerEntry2.parentVertex) == null || ExecutableSliceHelper.isVertexMarkedWithState(vertex3, n, graphMarker)) continue;
                            ExecutableSliceHelper.markVertexWithState(vertex3, n, graphMarker);
                            graphMarker2.mark(vertex3, n);
                            linkedList.add(vertex3);
                        }
                    }
                }
            }
        }
        return subGraphMarker;
    }

    private static boolean isVertexMarkedWithState(Vertex vertex, Integer n, GraphMarker<Set<Integer>> graphMarker) {
        if (graphMarker.getMark(vertex) == null) {
            return false;
        }
        return ((Set)graphMarker.getMark(vertex)).contains(n);
    }

    private static void markVertexWithState(Vertex vertex, Integer n, GraphMarker<Set<Integer>> graphMarker) {
        if (graphMarker.getMark(vertex) == null) {
            graphMarker.mark(vertex, new HashSet());
        }
        ((Set)graphMarker.getMark(vertex)).add(n);
    }

    private static Map<Edge, PathSystemMarkerEntry> getMarkersWithState(Vertex vertex, Integer n, List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> list) {
        if (vertex == null) {
            return null;
        }
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker = list.get(n);
        return (Map)graphMarker.getMark(vertex);
    }
}

