/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.statistics;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import java.util.Collection;

public class Sum
extends Function {
    @Description(params={"l"}, description="Returns the sum of the given collection of numbers.", categories={Function.Category.STATISTICS})
    public Sum() {
    }

    public Number evaluate(Collection<Number> collection) {
        if (collection.isEmpty()) {
            return 0;
        }
        Class clazz = Integer.class;
        for (Number object : collection) {
            if (object instanceof Integer) continue;
            if (object instanceof Long) {
                if (clazz != Integer.class) continue;
                clazz = Long.class;
                continue;
            }
            if (object instanceof Double) {
                clazz = Double.class;
                break;
            }
            throw new IllegalArgumentException("sum can't handle numbers of type " + object.getClass());
        }
        if (clazz == Integer.class) {
            int n = 0;
            for (Number number : collection) {
                n += number.intValue();
            }
            return n;
        }
        if (clazz == Long.class) {
            long l = 0L;
            for (Number number : collection) {
                l += number.longValue();
            }
            return l;
        }
        double d = 0.0;
        for (Number number : collection) {
            d += number.doubleValue();
        }
        return d;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        return arrayList.get(0);
    }
}

