/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.statistics;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import java.util.Collection;

public class Variance
extends Function {
    @Description(params={"l"}, description="Returns the variance of the given collection of numbers.\nIf the size of the collection is less than 2, the variance is undefined.", categories={Function.Category.STATISTICS})
    public Variance() {
    }

    public Double evaluate(Collection<Number> collection) {
        if (collection.size() < 1) {
            return null;
        }
        double d = 0.0;
        for (Number number : collection) {
            d += number.doubleValue();
        }
        double d2 = d / (double)collection.size();
        d = 0.0;
        for (Number number : collection) {
            double d3 = number.doubleValue() - d2;
            d += d3 * d3;
        }
        return d / (double)(collection.size() - 1);
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        return arrayList.get(0);
    }
}

