/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.strings;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.strings.ReMatch;
import java.util.List;
import java.util.regex.Pattern;
import org.pcollections.PVector;

public class Split
extends Function {
    @Description(params={"s", "regex"}, description="Splits the given string according to the given regular expression and returns the parts as list.", categories={Function.Category.STRINGS})
    public Split() {
        super(10L, 3L, 0.1);
    }

    public List<String> evaluate(String string, String string2) {
        Pattern pattern = ReMatch.patternCache.get(string2);
        if (pattern == null) {
            pattern = Pattern.compile(string2);
            ReMatch.patternCache.put(string2, pattern);
        }
        String[] stringArray = pattern.split(string);
        PVector<String> pVector = JGraLab.vector();
        for (String string3 : stringArray) {
            pVector = pVector.plus(string3);
        }
        return pVector;
    }
}

