/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.BinaryOperator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;

public class Or
extends BinaryOperator {
    public Or(GreqlQuery greqlQuery, Formula formula, Formula formula2) {
        super(greqlQuery, formula, formula2);
    }

    @Override
    public String toString() {
        return "(" + this.leftHandSide + " | " + this.rightHandSide + ")";
    }

    @Override
    public Expression toExpression() {
        GreqlGraph greqlGraph = this.query.getQueryGraph();
        FunctionApplication functionApplication = greqlGraph.createFunctionApplication();
        FunctionId functionId = OptimizerUtility.findOrCreateFunctionId("or", greqlGraph);
        greqlGraph.createIsFunctionIdOf(functionId, functionApplication);
        greqlGraph.createIsArgumentOf(this.leftHandSide.toExpression(), functionApplication);
        greqlGraph.createIsArgumentOf(this.rightHandSide.toExpression(), functionApplication);
        return functionApplication;
    }

    @Override
    protected Formula calculateReplacementFormula(Expression expression, Literal literal) {
        return new Or(this.query, this.leftHandSide.calculateReplacementFormula(expression, literal), this.rightHandSide.calculateReplacementFormula(expression, literal));
    }

    @Override
    public Formula simplify() {
        Formula formula = this.leftHandSide.simplify();
        Formula formula2 = this.rightHandSide.simplify();
        if (formula instanceof True) {
            return formula;
        }
        if (formula2 instanceof True) {
            return formula2;
        }
        if (formula instanceof False) {
            return formula2;
        }
        if (formula2 instanceof False) {
            return formula;
        }
        if (formula.equals(formula2)) {
            return formula;
        }
        return new Or(this.query, formula, formula2);
    }

    @Override
    public double getSelectivity() {
        double d = 1.0 - (1.0 - this.leftHandSide.getSelectivity()) * (1.0 - this.rightHandSide.getSelectivity());
        logger.finer("selectivity[" + this + "] = " + d);
        return d;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Or) {
            Or or = (Or)object;
            return this.leftHandSide.equals(or.leftHandSide) && this.rightHandSide.equals(or.rightHandSide);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode(19);
    }
}

