/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parallel;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.parallel.ParallelGreqlEvaluator;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class EvaluationEnvironment {
    Graph datagraph;
    GreqlEnvironment greqlEnvironment;
    ExecutorService executor;
    Exception exception;
    HashMap<ParallelGreqlEvaluator.TaskHandle, Integer> inDegree = new HashMap();
    HashMap<ParallelGreqlEvaluator.TaskHandle, ParallelGreqlEvaluator.EvaluationTask> tasks = new HashMap();
    long startTime;
    long doneTime;
    boolean sequentially;

    EvaluationEnvironment(boolean bl) {
        this.sequentially = bl;
    }

    public GreqlEnvironment getGreqlEnvironment() {
        return this.greqlEnvironment;
    }

    public Graph getDatagraph() {
        return this.datagraph;
    }

    public Object getResult(ParallelGreqlEvaluator.TaskHandle taskHandle) {
        ParallelGreqlEvaluator.EvaluationTask evaluationTask = this.tasks.get(taskHandle);
        if (!evaluationTask.isDone()) {
            throw new IllegalStateException(taskHandle + " is not yet done.");
        }
        if (!this.tasks.containsKey(taskHandle)) {
            throw new IllegalArgumentException(taskHandle + " does not belong to this EvaluationEnvironment.");
        }
        try {
            return this.tasks.get(taskHandle).get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
    }

    public long getEvaluationTime() {
        return this.doneTime - this.startTime;
    }

    public long getEvaluationTime(ParallelGreqlEvaluator.TaskHandle taskHandle) {
        return this.tasks.get(taskHandle).getEvaluationTime();
    }
}

