/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parser;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.DuplicateVariableException;
import de.uni_koblenz.jgralab.greql.exception.ParsingException;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.greql.parser.DoubleToken;
import de.uni_koblenz.jgralab.greql.parser.GreqlLexer;
import de.uni_koblenz.jgralab.greql.parser.LongToken;
import de.uni_koblenz.jgralab.greql.parser.ParserHelper;
import de.uni_koblenz.jgralab.greql.parser.RuleEnum;
import de.uni_koblenz.jgralab.greql.parser.SimpleSymbolTable;
import de.uni_koblenz.jgralab.greql.parser.SymbolTable;
import de.uni_koblenz.jgralab.greql.parser.Token;
import de.uni_koblenz.jgralab.greql.parser.TokenTypes;
import de.uni_koblenz.jgralab.greql.parser.VertexPosition;
import de.uni_koblenz.jgralab.greql.schema.AggregationPathDescription;
import de.uni_koblenz.jgralab.greql.schema.AlternativePathDescription;
import de.uni_koblenz.jgralab.greql.schema.BackwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Comprehension;
import de.uni_koblenz.jgralab.greql.schema.ConditionalExpression;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Definition;
import de.uni_koblenz.jgralab.greql.schema.Direction;
import de.uni_koblenz.jgralab.greql.schema.DoubleLiteral;
import de.uni_koblenz.jgralab.greql.schema.EdgePathDescription;
import de.uni_koblenz.jgralab.greql.schema.EdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.ElementSetExpression;
import de.uni_koblenz.jgralab.greql.schema.ExponentiatedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ExpressionDefinedSubgraph;
import de.uni_koblenz.jgralab.greql.schema.ForwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlSchema;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IntLiteral;
import de.uni_koblenz.jgralab.greql.schema.IntermediateVertexPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IsAlternativePathOf;
import de.uni_koblenz.jgralab.greql.schema.IsBoundExprOfDefinition;
import de.uni_koblenz.jgralab.greql.schema.IsBoundExprOfQuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.IsCompResultDefOf;
import de.uni_koblenz.jgralab.greql.schema.IsConditionOf;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsDefinitionOf;
import de.uni_koblenz.jgralab.greql.schema.IsDirectionOf;
import de.uni_koblenz.jgralab.greql.schema.IsEdgeExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsEdgeRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsExponentOf;
import de.uni_koblenz.jgralab.greql.schema.IsExponentiatedPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsExpressionOnSubgraph;
import de.uni_koblenz.jgralab.greql.schema.IsFalseExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsFirstValueOf;
import de.uni_koblenz.jgralab.greql.schema.IsFunctionIdOf;
import de.uni_koblenz.jgralab.greql.schema.IsGoalRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsIdOfStoreClause;
import de.uni_koblenz.jgralab.greql.schema.IsIntermediateVertexOf;
import de.uni_koblenz.jgralab.greql.schema.IsIteratedPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsKeyExprOfComprehension;
import de.uni_koblenz.jgralab.greql.schema.IsKeyExprOfConstruction;
import de.uni_koblenz.jgralab.greql.schema.IsLastValueOf;
import de.uni_koblenz.jgralab.greql.schema.IsOptionalPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsPartOf;
import de.uni_koblenz.jgralab.greql.schema.IsPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsQuantifiedDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsQuantifierOf;
import de.uni_koblenz.jgralab.greql.schema.IsQueryExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsRecordElementOf;
import de.uni_koblenz.jgralab.greql.schema.IsRecordExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsRecordIdOf;
import de.uni_koblenz.jgralab.greql.schema.IsSequenceElementOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsStartExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsStartRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsSubPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefiningExpression;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefinitionOf;
import de.uni_koblenz.jgralab.greql.schema.IsTargetExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsTransposedPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsTrueExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOfDeclaration;
import de.uni_koblenz.jgralab.greql.schema.IsTypeRestrOfExpression;
import de.uni_koblenz.jgralab.greql.schema.IsValueExprOfComprehension;
import de.uni_koblenz.jgralab.greql.schema.IsValueExprOfConstruction;
import de.uni_koblenz.jgralab.greql.schema.IsVarOf;
import de.uni_koblenz.jgralab.greql.schema.IteratedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IterationType;
import de.uni_koblenz.jgralab.greql.schema.LetExpression;
import de.uni_koblenz.jgralab.greql.schema.ListComprehension;
import de.uni_koblenz.jgralab.greql.schema.ListRangeConstruction;
import de.uni_koblenz.jgralab.greql.schema.LongLiteral;
import de.uni_koblenz.jgralab.greql.schema.MapComprehension;
import de.uni_koblenz.jgralab.greql.schema.MapConstruction;
import de.uni_koblenz.jgralab.greql.schema.OptionalPathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.PrimaryPathDescription;
import de.uni_koblenz.jgralab.greql.schema.QuantificationType;
import de.uni_koblenz.jgralab.greql.schema.QuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.Quantifier;
import de.uni_koblenz.jgralab.greql.schema.RecordConstruction;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.greql.schema.RecordId;
import de.uni_koblenz.jgralab.greql.schema.RoleId;
import de.uni_koblenz.jgralab.greql.schema.SequentialPathDescription;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SimplePathDescription;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.StringLiteral;
import de.uni_koblenz.jgralab.greql.schema.SubgraphDefinition;
import de.uni_koblenz.jgralab.greql.schema.SubgraphRestrictedExpression;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.schema.ThisVertex;
import de.uni_koblenz.jgralab.greql.schema.TransposedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.TupleConstruction;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.schema.TypeOrRoleId;
import de.uni_koblenz.jgralab.greql.schema.UndefinedLiteral;
import de.uni_koblenz.jgralab.greql.schema.ValueConstruction;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.schema.WhereExpression;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class GreqlParser
extends ParserHelper {
    private static final GreqlSchema SCHEMA = GreqlSchema.instance();
    private final Map<RuleEnum, int[]> testedRules = new HashMap<RuleEnum, int[]>();
    private List<Token> tokens = null;
    private int current = 0;
    private int farestOffset = 0;
    private ParsingException farestException = null;
    private final Stack<Integer> parsingStack;
    private final Stack<Boolean> predicateStack;
    private boolean predicateFulfilled = true;
    private Set<String> subQueryNames = null;

    public final Set<String> getValidVariables() {
        return this.duringParsingvariableSymbolTable.getKnownIdentifierSet();
    }

    private final void ruleSucceeds(RuleEnum ruleEnum, int n) {
        int[] nArray = this.testedRules.get((Object)ruleEnum);
        nArray[n] = this.current;
    }

    private final int alreadySucceeded(RuleEnum ruleEnum) {
        int n;
        int[] nArray = this.testedRules.get((Object)ruleEnum);
        if (nArray == null) {
            nArray = new int[this.tokens.size() + 1];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = -1;
            }
            this.testedRules.put(ruleEnum, nArray);
        }
        n = nArray[this.current];
        if (this.inPredicateMode()) {
            if (n == -1) {
                nArray[this.current] = -2;
            } else {
                if (n == -2) {
                    this.fail("Rule " + ruleEnum.toString() + " already tested at position " + this.current + " Current Token " + (Object)((Object)this.lookAhead(0)));
                    return -2;
                }
                this.current = n;
                return -1;
            }
        }
        return this.current;
    }

    private final boolean skipRule(int n) {
        return n < 0 && this.inPredicateMode();
    }

    public GreqlParser(String string) {
        this(string, null);
    }

    public GreqlParser(String string, Set<String> set) {
        this.query = string;
        this.parsingStack = new Stack();
        this.predicateStack = new Stack();
        this.graph = SCHEMA.createGreqlGraph(ImplementationType.STANDARD);
        this.tokens = GreqlLexer.scan(string);
        this.afterParsingvariableSymbolTable = new SymbolTable();
        this.duringParsingvariableSymbolTable = new SimpleSymbolTable();
        this.duringParsingvariableSymbolTable.blockBegin();
        this.functionSymbolTable = new HashMap();
        this.graphCleaned = false;
        this.lookAhead = this.tokens.get(0);
        this.subQueryNames = set;
    }

    protected final boolean isFunctionName(String string) {
        return this.subQueryNames != null && this.subQueryNames.contains(string) || FunLib.contains(string);
    }

    public void parse() {
        try {
            this.parseQuery();
        }
        catch (ParsingException parsingException) {
            if (this.farestException != null) {
                throw this.farestException;
            }
            throw parsingException;
        }
    }

    @Override
    protected void debug(String string) {
        for (int i = 0; i < this.parsingStack.size(); ++i) {
            System.out.print("    ");
        }
        System.out.println(string);
    }

    private final TokenTypes lookAhead(int n) {
        if (this.current + n < this.tokens.size()) {
            return this.tokens.get((int)(this.current + n)).type;
        }
        return TokenTypes.EOF;
    }

    protected final PVector<SourcePosition> createSourcePositionList(int n) {
        PVector pVector = JGraLab.vector();
        return pVector.plus(new SourcePosition(this.getCurrentOffset() - n, n));
    }

    public static GreqlGraph parse(String string) {
        return GreqlParser.parse(string, null);
    }

    public static GreqlGraph parse(String string, Set<String> set) {
        GreqlParser greqlParser = new GreqlParser(string, set);
        greqlParser.parse();
        return greqlParser.getGraph();
    }

    private final ValueConstruction createPartsOfValueConstruction(List<VertexPosition<Expression>> list, ValueConstruction valueConstruction) {
        return (ValueConstruction)this.createMultipleEdgesToParent(list, valueConstruction, IsPartOf.EC);
    }

    private final Vertex createMultipleEdgesToParent(List<VertexPosition<Expression>> list, Vertex vertex, EdgeClass edgeClass) {
        if (list != null) {
            for (VertexPosition<Expression> vertexPosition : list) {
                GreqlAggregation greqlAggregation = (GreqlAggregation)this.graph.createEdge(edgeClass, (Vertex)vertexPosition.node, vertex);
                greqlAggregation.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
            }
        }
        return vertex;
    }

    private final Vertex createMultipleEdgesToParent(List<VertexPosition<TypeId>> list, Vertex vertex, EdgeClass edgeClass, int n) {
        if (list != null) {
            for (VertexPosition<TypeId> vertexPosition : list) {
                GreqlAggregation greqlAggregation = (GreqlAggregation)this.graph.createEdge(edgeClass, (Vertex)vertexPosition.node, vertex);
                greqlAggregation.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
            }
        }
        return vertex;
    }

    private final Vertex createMultipleEdgesToParent(List<VertexPosition<SimpleDeclaration>> list, Vertex vertex, EdgeClass edgeClass, boolean bl) {
        if (list != null) {
            for (VertexPosition<SimpleDeclaration> vertexPosition : list) {
                GreqlAggregation greqlAggregation = (GreqlAggregation)this.graph.createEdge(edgeClass, (Vertex)vertexPosition.node, vertex);
                greqlAggregation.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
            }
        }
        return vertex;
    }

    private final Vertex createMultipleEdgesToParent(List<VertexPosition<Variable>> list, Vertex vertex, EdgeClass edgeClass, String string) {
        if (list != null) {
            for (VertexPosition<Variable> vertexPosition : list) {
                GreqlAggregation greqlAggregation = (GreqlAggregation)this.graph.createEdge(edgeClass, (Vertex)vertexPosition.node, vertex);
                greqlAggregation.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
            }
        }
        return vertex;
    }

    private final void predicateStart() {
        this.parsingStack.push(this.current);
        this.predicateStack.push(this.predicateFulfilled);
        this.predicateFulfilled = true;
    }

    private final void match() {
        ++this.current;
        this.lookAhead = this.current < this.tokens.size() ? this.tokens.get(this.current) : null;
    }

    @Override
    protected boolean inPredicateMode() {
        return !this.predicateStack.isEmpty();
    }

    private final boolean predicateHolds() {
        return this.predicateFulfilled;
    }

    private final boolean predicateEnd() {
        this.current = this.parsingStack.pop();
        this.lookAhead = this.current < this.tokens.size() ? this.tokens.get(this.current) : null;
        boolean bl = this.predicateFulfilled;
        this.predicateFulfilled = this.predicateStack.pop();
        return bl;
    }

    private final void fail(String string) {
        int n = this.query.length();
        int n2 = -1;
        String string2 = "";
        if (this.lookAhead != null) {
            n = this.lookAhead.getOffset();
            n2 = this.lookAhead.getLength();
            string2 = this.lookAhead.getValue();
        } else {
            string2 = this.lookAhead(0).name();
        }
        ParsingException parsingException = new ParsingException(string + " " + (Object)((Object)this.lookAhead(0)), string2, n, n2, this.query);
        this.predicateFulfilled = false;
        if (this.getCurrentOffset() > this.farestOffset) {
            this.farestException = parsingException;
            this.farestOffset = this.getCurrentOffset();
        }
        throw parsingException;
    }

    private final String matchIdentifier() {
        String string;
        if (this.lookAhead(0) == TokenTypes.IDENTIFIER && GreqlParser.isValidIdentifier(string = this.lookAhead.getValue())) {
            this.match();
            return string;
        }
        this.fail("expected identifier, but found");
        return null;
    }

    private final String matchSimpleName() {
        String string;
        if (this.lookAhead(0) == TokenTypes.IDENTIFIER && GreqlParser.isValidSimpleName(string = this.lookAhead.getValue())) {
            this.match();
            return string;
        }
        this.fail("expected simple name, but found");
        return null;
    }

    private final void match(TokenTypes tokenTypes) {
        if (this.lookAhead(0) == tokenTypes) {
            this.match();
        } else {
            this.fail("expected " + (Object)((Object)tokenTypes) + ", but found");
        }
    }

    private static final boolean isValidName(TokenTypes tokenTypes) {
        switch (tokenTypes) {
            case MAP: 
            case AS: 
            case IMPORT: 
            case IN: 
            case SET: 
            case LIST: 
            case REC: 
            case FROM: 
            case WITH: 
            case REPORT: 
            case WHERE: 
            case LET: {
                return true;
            }
        }
        return false;
    }

    private final String matchPackageName() {
        if ((this.lookAhead(0) == TokenTypes.IDENTIFIER || GreqlParser.isValidName(this.lookAhead(0))) && GreqlParser.isValidPackageName(this.getLookAheadValue(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.lookAhead.getValue());
            this.match();
            boolean bl = true;
            do {
                if (this.lookAhead(0) == TokenTypes.DOT) {
                    if ((this.lookAhead(1) == TokenTypes.IDENTIFIER || GreqlParser.isValidName(this.lookAhead(1))) && GreqlParser.isValidPackageName(this.getLookAheadValue(1))) {
                        bl = true;
                        this.match(TokenTypes.DOT);
                        stringBuilder.append(".");
                        stringBuilder.append(this.lookAhead.getValue());
                        this.match();
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (bl);
            return stringBuilder.toString();
        }
        this.fail("Package or type name expected, but found");
        return null;
    }

    private String getLookAheadValue(int n) {
        if (this.current + n < this.tokens.size()) {
            Token token = this.tokens.get(this.current + n);
            return token.getValue();
        }
        return null;
    }

    private final String matchQualifiedName() {
        StringBuilder stringBuilder = new StringBuilder();
        this.predicateStart();
        try {
            this.matchPackageName();
            this.match(TokenTypes.DOT);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            stringBuilder.append(this.matchPackageName());
            stringBuilder.append(".");
            this.match(TokenTypes.DOT);
        }
        stringBuilder.append(this.matchSimpleName());
        return stringBuilder.toString();
    }

    private static final boolean isValidPackageName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isLetter(cArray[0]) || !Character.isLowerCase(cArray[0]) || cArray[0] > '\u007f') {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if ((Character.isLowerCase(cArray[i]) || Character.isDigit(cArray[i]) || cArray[i] == '_') && cArray[i] <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static final boolean isValidSimpleName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isLetter(cArray[0]) || !Character.isUpperCase(cArray[0]) || cArray[0] > '\u007f') {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (cArray[i] <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static final boolean isValidIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) continue;
            return false;
        }
        return true;
    }

    private final void parseQuery() {
        GraphElement<EdgeClass, Edge> graphElement;
        if (this.lookAhead(0) == TokenTypes.EOF) {
            return;
        }
        GreqlExpression greqlExpression = this.graph.createGreqlExpression();
        greqlExpression.set_importedTypes(this.parseImports());
        if (this.lookAhead(0) == TokenTypes.USING) {
            this.match();
            List<VertexPosition<Variable>> list = this.parseVariableList();
            for (VertexPosition object2 : list) {
                graphElement = this.graph.createIsBoundVarOf((Variable)object2.node, greqlExpression);
                graphElement.set_sourcePositions(this.createSourcePositionList(object2.length, object2.offset));
            }
            this.match(TokenTypes.COLON);
        }
        int n = this.getCurrentOffset();
        Expression expression = this.parseExpression();
        if (expression == null) {
            return;
        }
        IsQueryExprOf isQueryExprOf = this.graph.createIsQueryExprOf(expression, greqlExpression);
        isQueryExprOf.set_sourcePositions(this.createSourcePositionList(n));
        if (this.lookAhead(0) == TokenTypes.STORE) {
            this.match();
            this.match(TokenTypes.AS);
            graphElement = this.graph.createIdentifier();
            n = this.getCurrentOffset();
            graphElement.set_name(this.matchIdentifier());
            IsIdOfStoreClause isIdOfStoreClause = this.graph.createIsIdOfStoreClause((Identifier)graphElement, greqlExpression);
            isIdOfStoreClause.set_sourcePositions(this.createSourcePositionList(n));
        }
        this.match(TokenTypes.EOF);
        this.testIllegalThisLiterals();
        this.mergeVariablesInGreqlExpression(greqlExpression);
    }

    private final PSet<String> parseImports() {
        PSet<String> pSet = JGraLab.set();
        while (this.lookAhead(0) == TokenTypes.IMPORT) {
            this.match(TokenTypes.IMPORT);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.matchPackageName());
            this.match(TokenTypes.DOT);
            if (this.lookAhead(0) == TokenTypes.STAR) {
                this.match(TokenTypes.STAR);
                stringBuilder.append(".*");
            } else {
                stringBuilder.append(".");
                stringBuilder.append(this.matchSimpleName());
            }
            pSet = pSet.plus(stringBuilder.toString());
            this.match(TokenTypes.SEMI);
        }
        return pSet;
    }

    private final List<VertexPosition<Variable>> parseVariableList() {
        ArrayList<VertexPosition<Variable>> arrayList = new ArrayList<VertexPosition<Variable>>();
        int n = this.getCurrentOffset();
        arrayList.add(new VertexPosition<Variable>(this.parseVariable(true), this.getLength(n), n));
        while (this.lookAhead(0) == TokenTypes.COMMA) {
            this.match();
            arrayList.add(new VertexPosition<Variable>(this.parseVariable(true), this.getLength(n), n));
        }
        return arrayList;
    }

    private final Variable parseVariable(boolean bl) {
        Variable variable;
        block4: {
            String string = this.matchIdentifier();
            variable = null;
            if (!this.inPredicateMode()) {
                variable = this.graph.createVariable();
                variable.set_name(string);
            }
            if (bl) {
                try {
                    this.duringParsingvariableSymbolTable.insert(string, variable);
                }
                catch (DuplicateVariableException duplicateVariableException) {
                    if (this.inPredicateMode()) break block4;
                    throw duplicateVariableException;
                }
            }
        }
        return variable;
    }

    private final Expression parseExpression() {
        int n = this.alreadySucceeded(RuleEnum.EXPRESSION);
        if (this.skipRule(n)) {
            return null;
        }
        Expression expression = this.parseSubgraphRestrictedExpression();
        this.ruleSucceeds(RuleEnum.EXPRESSION, n);
        return expression;
    }

    private final SubgraphDefinition parseSubgraphDefinition() {
        ExpressionDefinedSubgraph expressionDefinedSubgraph = null;
        int n = this.getCurrentOffset();
        Expression expression = this.parseExpression();
        if (!this.inPredicateMode()) {
            int n2 = this.getLength(n);
            expressionDefinedSubgraph = this.graph.createExpressionDefinedSubgraph();
            IsSubgraphDefiningExpression isSubgraphDefiningExpression = this.graph.createIsSubgraphDefiningExpression(expression, expressionDefinedSubgraph);
            isSubgraphDefiningExpression.set_sourcePositions(this.createSourcePositionList(n2, n));
        }
        return expressionDefinedSubgraph;
    }

    private final Expression parseSubgraphRestrictedExpression() {
        int n = this.alreadySucceeded(RuleEnum.SUBGRAPHRESTRICTEDEXPRESSION);
        if (this.skipRule(n)) {
            return null;
        }
        Expression expression = null;
        if (this.lookAhead(0) == TokenTypes.ON) {
            this.match();
            int n2 = this.getCurrentOffset();
            SubgraphDefinition subgraphDefinition = this.parseSubgraphDefinition();
            this.match(TokenTypes.COLON);
            int n3 = this.getLength(n2);
            int n4 = this.getCurrentOffset();
            Expression expression2 = this.parseWhereExpression();
            if (!this.inPredicateMode()) {
                int n5 = this.getLength(n4);
                SubgraphRestrictedExpression subgraphRestrictedExpression = this.graph.createSubgraphRestrictedExpression();
                IsSubgraphDefinitionOf isSubgraphDefinitionOf = this.graph.createIsSubgraphDefinitionOf(subgraphDefinition, subgraphRestrictedExpression);
                isSubgraphDefinitionOf.set_sourcePositions(this.createSourcePositionList(n3, n2));
                IsExpressionOnSubgraph isExpressionOnSubgraph = this.graph.createIsExpressionOnSubgraph(expression2, subgraphRestrictedExpression);
                isExpressionOnSubgraph.set_sourcePositions(this.createSourcePositionList(n5, n4));
                expression = subgraphRestrictedExpression;
            }
        } else {
            expression = this.parseLetExpression();
        }
        this.ruleSucceeds(RuleEnum.SUBGRAPHRESTRICTEDEXPRESSION, n);
        return expression;
    }

    private final boolean tryMatch(TokenTypes tokenTypes) {
        if (this.lookAhead(0) == tokenTypes) {
            this.match();
            return true;
        }
        return false;
    }

    private final Quantifier parseQuantifier() {
        QuantificationType quantificationType = null;
        if (this.tryMatch(TokenTypes.FORALL)) {
            quantificationType = QuantificationType.FORALL;
        } else if (this.tryMatch(TokenTypes.EXISTS_ONE)) {
            quantificationType = QuantificationType.EXISTSONE;
        } else if (this.tryMatch(TokenTypes.EXISTS)) {
            quantificationType = QuantificationType.EXISTS;
        }
        if (quantificationType != null) {
            if (!this.inPredicateMode()) {
                for (Quantifier quantifier : this.graph.getQuantifierVertices()) {
                    if (quantifier.get_type() != quantificationType) continue;
                    return quantifier;
                }
                Quantifier quantifier = this.graph.createQuantifier();
                quantifier.set_type(quantificationType);
                return quantifier;
            }
            return null;
        }
        this.fail("Expected a quantifier");
        return null;
    }

    private final Expression parseQuantifiedExpression() {
        if (this.lookAhead(0) == TokenTypes.EXISTS || this.lookAhead(0) == TokenTypes.EXISTS_ONE || this.lookAhead(0) == TokenTypes.FORALL) {
            int n = this.getCurrentOffset();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Quantifier quantifier = this.parseQuantifier();
            n4 = this.getLength(n);
            n2 = this.getCurrentOffset();
            this.duringParsingvariableSymbolTable.blockBegin();
            Declaration declaration = this.parseQuantifiedDeclaration();
            n5 = this.getLength(n2);
            this.match(TokenTypes.AT);
            n3 = this.getCurrentOffset();
            Expression expression = this.parseSubgraphRestrictedExpression();
            n6 = this.getLength(n3);
            QuantifiedExpression quantifiedExpression = null;
            if (!this.inPredicateMode()) {
                quantifiedExpression = this.graph.createQuantifiedExpression();
                IsQuantifierOf isQuantifierOf = this.graph.createIsQuantifierOf(quantifier, quantifiedExpression);
                isQuantifierOf.set_sourcePositions(this.createSourcePositionList(n4, n));
                IsQuantifiedDeclOf isQuantifiedDeclOf = this.graph.createIsQuantifiedDeclOf(declaration, quantifiedExpression);
                isQuantifiedDeclOf.set_sourcePositions(this.createSourcePositionList(n5, n2));
                IsBoundExprOfQuantifiedExpression isBoundExprOfQuantifiedExpression = this.graph.createIsBoundExprOfQuantifiedExpression(expression, quantifiedExpression);
                isBoundExprOfQuantifiedExpression.set_sourcePositions(this.createSourcePositionList(n6, n3));
            }
            this.duringParsingvariableSymbolTable.blockEnd();
            return quantifiedExpression;
        }
        return this.parseConditionalExpression();
    }

    private final Expression parseLetExpression() {
        if (this.lookAhead(0) == TokenTypes.LET) {
            this.match();
            this.duringParsingvariableSymbolTable.blockBegin();
            List<VertexPosition<Definition>> list = this.parseDefinitionList();
            this.match(TokenTypes.IN);
            int n = this.getCurrentOffset();
            Expression expression = this.parseLetExpression();
            LetExpression letExpression = null;
            if (!this.inPredicateMode() && !list.isEmpty()) {
                int n2 = this.getLength(n);
                letExpression = this.graph.createLetExpression();
                IsBoundExprOfDefinition isBoundExprOfDefinition = this.graph.createIsBoundExprOfDefinition(expression, letExpression);
                isBoundExprOfDefinition.set_sourcePositions(this.createSourcePositionList(n2, n));
                for (VertexPosition<Definition> vertexPosition : list) {
                    IsDefinitionOf isDefinitionOf = this.graph.createIsDefinitionOf((Definition)vertexPosition.node, letExpression);
                    isDefinitionOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                }
            }
            this.duringParsingvariableSymbolTable.blockEnd();
            return letExpression;
        }
        return this.parseWhereExpression();
    }

    private final Expression parseWhereExpression() {
        int n = this.getCurrentOffset();
        Expression expression = this.parseQuantifiedExpression();
        if (this.tryMatch(TokenTypes.WHERE)) {
            int n2 = this.getLength(n);
            List<VertexPosition<Definition>> list = this.parseDefinitionList();
            WhereExpression whereExpression = null;
            if (!this.inPredicateMode()) {
                whereExpression = this.graph.createWhereExpression();
                IsBoundExprOfDefinition isBoundExprOfDefinition = this.graph.createIsBoundExprOfDefinition(expression, whereExpression);
                isBoundExprOfDefinition.set_sourcePositions(this.createSourcePositionList(n2, n));
                for (VertexPosition<Definition> vertexPosition : list) {
                    IsDefinitionOf isDefinitionOf = this.graph.createIsDefinitionOf((Definition)vertexPosition.node, whereExpression);
                    isDefinitionOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                }
            }
            return whereExpression;
        }
        return expression;
    }

    private final List<VertexPosition<Definition>> parseDefinitionList() {
        ArrayList<VertexPosition<Definition>> arrayList = null;
        if (!this.inPredicateMode()) {
            arrayList = new ArrayList<VertexPosition<Definition>>();
        }
        do {
            int n = this.getCurrentOffset();
            Definition definition = this.parseDefinition();
            int n2 = this.getLength(n);
            if (this.inPredicateMode()) continue;
            arrayList.add(new VertexPosition<Definition>(definition, n, n2));
        } while (this.tryMatch(TokenTypes.COMMA));
        return arrayList;
    }

    private final Definition parseDefinition() {
        int n = this.getCurrentOffset();
        Variable variable = this.parseVariable(true);
        int n2 = this.getLength(n);
        this.match(TokenTypes.ASSIGN);
        int n3 = this.getCurrentOffset();
        Expression expression = this.parseExpression();
        int n4 = this.getLength(n3);
        if (!this.inPredicateMode()) {
            Definition definition = this.graph.createDefinition();
            IsVarOf isVarOf = this.graph.createIsVarOf(variable, definition);
            isVarOf.set_sourcePositions(this.createSourcePositionList(n2, n));
            IsExprOf isExprOf = this.graph.createIsExprOf(expression, definition);
            isExprOf.set_sourcePositions(this.createSourcePositionList(n4, n3));
            return definition;
        }
        return null;
    }

    private final Expression parseConditionalExpression() {
        int n = this.getCurrentOffset();
        Expression expression = this.parseOrExpression();
        int n2 = this.getLength(n);
        if (this.tryMatch(TokenTypes.QUESTION)) {
            int n3 = this.getCurrentOffset();
            Expression expression2 = this.parseConditionalExpression();
            int n4 = this.getLength(n3);
            this.match(TokenTypes.COLON);
            int n5 = this.getCurrentOffset();
            Expression expression3 = this.parseConditionalExpression();
            int n6 = this.getLength(n5);
            if (!this.inPredicateMode()) {
                ConditionalExpression conditionalExpression = this.graph.createConditionalExpression();
                IsConditionOf isConditionOf = this.graph.createIsConditionOf(expression, conditionalExpression);
                isConditionOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                IsTrueExprOf isTrueExprOf = this.graph.createIsTrueExprOf(expression2, conditionalExpression);
                isTrueExprOf.set_sourcePositions(this.createSourcePositionList(n4, n3));
                IsFalseExprOf isFalseExprOf = this.graph.createIsFalseExprOf(expression3, conditionalExpression);
                isFalseExprOf.set_sourcePositions(this.createSourcePositionList(n6, n5));
                expression = conditionalExpression;
            }
        }
        return expression;
    }

    private final Expression parseOrExpression() {
        ParserHelper.FunctionConstruct functionConstruct = new ParserHelper.FunctionConstruct(this);
        functionConstruct.preArg1();
        Expression expression = this.parseXorExpression();
        functionConstruct.preOp(expression);
        if (this.tryMatch(TokenTypes.OR)) {
            functionConstruct.postOp("or");
            return functionConstruct.postArg2(this.parseOrExpression());
        }
        return expression;
    }

    private final Expression parseXorExpression() {
        ParserHelper.FunctionConstruct functionConstruct = new ParserHelper.FunctionConstruct(this);
        functionConstruct.preArg1();
        Expression expression = this.parseAndExpression();
        functionConstruct.preOp(expression);
        if (this.tryMatch(TokenTypes.XOR)) {
            functionConstruct.postOp("xor");
            return functionConstruct.postArg2(this.parseXorExpression());
        }
        return expression;
    }

    private final Expression parseAndExpression() {
        ParserHelper.FunctionConstruct functionConstruct = new ParserHelper.FunctionConstruct(this);
        functionConstruct.preArg1();
        Expression expression = this.parseEqualityExpression();
        functionConstruct.preOp(expression);
        if (this.tryMatch(TokenTypes.AND)) {
            functionConstruct.postOp("and");
            return functionConstruct.postArg2(this.parseAndExpression());
        }
        return expression;
    }

    private final Expression parseEqualityExpression() {
        ParserHelper.FunctionConstruct functionConstruct = new ParserHelper.FunctionConstruct(this);
        functionConstruct.preArg1();
        Expression expression = this.parseRelationalExpression();
        functionConstruct.preOp(expression);
        if (this.tryMatch(TokenTypes.EQUAL)) {
            functionConstruct.postOp("equals");
            return functionConstruct.postArg2(this.parseEqualityExpression());
        }
        if (this.tryMatch(TokenTypes.NOT_EQUAL)) {
            functionConstruct.postOp("nequals");
            return functionConstruct.postArg2(this.parseEqualityExpression());
        }
        return expression;
    }

    private final Expression parseRelationalExpression() {
        ParserHelper.FunctionConstruct functionConstruct = new ParserHelper.FunctionConstruct(this);
        functionConstruct.preArg1();
        Expression expression = this.parseAdditiveExpression();
        functionConstruct.preOp(expression);
        String string = null;
        if (this.tryMatch(TokenTypes.L_T)) {
            string = "leThan";
        } else if (this.tryMatch(TokenTypes.LE)) {
            string = "leEqual";
        } else if (this.tryMatch(TokenTypes.GE)) {
            string = "grEqual";
        } else if (this.tryMatch(TokenTypes.G_T)) {
            string = "grThan";
        } else if (this.tryMatch(TokenTypes.MATCH)) {
            string = "reMatch";
        }
        if (string != null) {
            functionConstruct.postOp(string);
            return functionConstruct.postArg2(this.parseRelationalExpression());
        }
        return expression;
    }

    private final Expression parseAdditiveExpression() {
        ParserHelper.FunctionConstruct functionConstruct = null;
        String string = null;
        Expression expression = null;
        do {
            if (functionConstruct == null) {
                functionConstruct = new ParserHelper.FunctionConstruct(this);
                functionConstruct.preArg1();
                expression = this.parseMultiplicativeExpression();
            } else {
                functionConstruct = new ParserHelper.FunctionConstruct(this, functionConstruct);
            }
            string = null;
            functionConstruct.preOp(expression);
            if (this.tryMatch(TokenTypes.PLUS)) {
                string = "add";
            } else if (this.tryMatch(TokenTypes.MINUS)) {
                string = "sub";
            } else if (this.tryMatch(TokenTypes.PLUSPLUS)) {
                string = "concat";
            }
            if (string == null) continue;
            functionConstruct.postOp(string);
            expression = functionConstruct.postArg2(this.parseMultiplicativeExpression());
        } while (string != null);
        return expression;
    }

    private final Expression parseMultiplicativeExpression() {
        ParserHelper.FunctionConstruct functionConstruct = null;
        String string = null;
        Expression expression = null;
        do {
            if (functionConstruct == null) {
                functionConstruct = new ParserHelper.FunctionConstruct(this);
                functionConstruct.preArg1();
                expression = this.parseUnaryExpression();
            } else {
                functionConstruct = new ParserHelper.FunctionConstruct(this, functionConstruct);
            }
            string = null;
            functionConstruct.preOp(expression);
            if (this.tryMatch(TokenTypes.STAR)) {
                string = "mul";
            } else if (this.tryMatch(TokenTypes.MOD)) {
                string = "mod";
            } else if (this.tryMatch(TokenTypes.DIV)) {
                string = "div";
            }
            if (string == null) continue;
            functionConstruct.postOp(string);
            expression = functionConstruct.postArg2(this.parseUnaryExpression());
        } while (string != null);
        return expression;
    }

    private final Expression parseUnaryExpression() {
        Object object;
        ParserHelper.FunctionConstruct functionConstruct = null;
        if (this.lookAhead(0) == TokenTypes.NOT || this.lookAhead(0) == TokenTypes.MINUS) {
            functionConstruct = new ParserHelper.FunctionConstruct(this);
            functionConstruct.preUnaryOp();
            object = null;
            if (this.tryMatch(TokenTypes.NOT)) {
                object = "not";
            } else if (this.tryMatch(TokenTypes.MINUS)) {
                object = "neg";
            }
            if (!this.inPredicateMode()) {
                this.getFunctionId((String)object);
            }
            functionConstruct.postOp((String)object);
        }
        object = this.parsePathExpression();
        if (functionConstruct != null) {
            return functionConstruct.postArg2((Expression)object);
        }
        return object;
    }

    private final RoleId parseRoleId() {
        String string = this.matchIdentifier();
        if (!this.inPredicateMode()) {
            RoleId roleId = this.graph.createRoleId();
            roleId.set_name(string);
            return roleId;
        }
        return null;
    }

    private final Identifier parseIdentifier() {
        String string = this.matchIdentifier();
        if (!this.inPredicateMode()) {
            Identifier identifier = this.graph.createIdentifier();
            identifier.set_name(string);
            return identifier;
        }
        return null;
    }

    private final Expression parseValueAccess() {
        int n = this.getCurrentOffset();
        Expression expression = this.parsePrimaryExpression();
        int n2 = this.getLength(n);
        boolean bl = false;
        if (this.lookAhead(0) == TokenTypes.DOT) {
            bl = true;
        }
        if (this.lookAhead(0) == TokenTypes.LBRACK) {
            this.predicateStart();
            try {
                this.match(TokenTypes.LBRACK);
                this.parsePrimaryPathDescription();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (!this.predicateEnd()) {
                bl = true;
            }
        }
        if (bl) {
            return this.parseValueAccess2(expression, n, n2);
        }
        return expression;
    }

    private final Expression parseValueAccess2(Expression expression, int n, int n2) {
        String string = "get";
        int n3 = this.getCurrentOffset();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Expression expression2 = null;
        if (this.tryMatch(TokenTypes.DOT)) {
            string = "getValue";
            n4 = 1;
            n6 = this.getCurrentOffset();
            expression2 = this.parseIdentifier();
        } else if (this.tryMatch(TokenTypes.LBRACK)) {
            n6 = this.getCurrentOffset();
            expression2 = this.parseExpression();
            n5 = this.getLength(n6);
            this.match(TokenTypes.RBRACK);
            n4 = this.getLength(n3);
        }
        FunctionApplication functionApplication = null;
        if (!this.inPredicateMode()) {
            functionApplication = this.createFunctionIdAndArgumentOf(this.getFunctionId(string), n3, n4, expression, n, n2, expression2, n6, n5, true);
        }
        boolean bl = false;
        if (this.lookAhead(0) == TokenTypes.DOT) {
            bl = true;
        }
        if (this.lookAhead(0) == TokenTypes.LBRACK) {
            this.predicateStart();
            try {
                this.match(TokenTypes.LBRACK);
                this.parsePrimaryPathDescription();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (!this.predicateEnd()) {
                bl = true;
            }
        }
        if (bl) {
            return this.parseValueAccess2(functionApplication, n, this.getLength(n6));
        }
        return functionApplication;
    }

    private final Expression parsePrimaryExpression() {
        if (this.lookAhead(0) == TokenTypes.LPAREN) {
            return this.parseParenthesedExpression();
        }
        if (this.lookAhead(0) == TokenTypes.V || this.lookAhead(0) == TokenTypes.E) {
            return this.parseRangeExpression();
        }
        this.predicateStart();
        try {
            this.parseAltPathDescription();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            return this.parseAltPathDescription();
        }
        if (!(this.lookAhead(0) != TokenTypes.IDENTIFIER && this.lookAhead(0) != TokenTypes.AND && this.lookAhead(0) != TokenTypes.NOT && this.lookAhead(0) != TokenTypes.XOR && this.lookAhead(0) != TokenTypes.OR || this.lookAhead(1) != TokenTypes.LCURLY && this.lookAhead(1) != TokenTypes.LPAREN)) {
            this.predicateStart();
            try {
                this.parseFunctionApplication();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                return this.parseFunctionApplication();
            }
        }
        this.predicateStart();
        try {
            this.parseValueConstruction();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            return this.parseValueConstruction();
        }
        this.predicateStart();
        try {
            this.parseVariable(false);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            return this.parseVariable(false);
        }
        this.predicateStart();
        try {
            this.parseLiteral();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            return this.parseLiteral();
        }
        if (this.lookAhead(0) == TokenTypes.FROM) {
            return this.parseFWRExpression();
        }
        this.fail("Unrecognized token");
        return null;
    }

    private final Expression parseParenthesedExpression() {
        this.predicateStart();
        try {
            this.parseAltPathDescription();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            PathDescription pathDescription = this.parseAltPathDescription();
            return pathDescription;
        }
        this.match(TokenTypes.LPAREN);
        Expression expression = this.parseExpression();
        this.match(TokenTypes.RPAREN);
        return expression;
    }

    private final PathDescription parseAltPathDescription() {
        int n = this.alreadySucceeded(RuleEnum.ALTERNATIVE_PATH_DESCRIPTION);
        if (this.skipRule(n)) {
            return null;
        }
        int n2 = this.getCurrentOffset();
        PathDescription pathDescription = this.parseIntermediateVertexPathDescription();
        int n3 = this.getLength(n2);
        if (this.tryMatch(TokenTypes.BOR)) {
            int n4 = this.getCurrentOffset();
            PathDescription pathDescription2 = this.parseAltPathDescription();
            int n5 = this.getLength(n4);
            if (!this.inPredicateMode()) {
                pathDescription = this.addPathElement(AlternativePathDescription.VC, IsAlternativePathOf.EC, null, pathDescription, n2, n3, pathDescription2, n4, n5);
            }
        }
        this.ruleSucceeds(RuleEnum.ALTERNATIVE_PATH_DESCRIPTION, n);
        return pathDescription;
    }

    private final PathDescription parseIntermediateVertexPathDescription() {
        int n = this.getCurrentOffset();
        PathDescription pathDescription = this.parseSequentialPathDescription();
        int n2 = this.getLength(n);
        this.predicateStart();
        try {
            this.parseValueAccess();
            if (this.predicateHolds()) {
                this.parseSequentialPathDescription();
            }
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            int n3 = this.getCurrentOffset();
            Expression expression = this.parseValueAccess();
            int n4 = this.getLength(n3);
            int n5 = this.getCurrentOffset();
            PathDescription pathDescription2 = this.parseIntermediateVertexPathDescription();
            int n6 = this.getLength(n5);
            IntermediateVertexPathDescription intermediateVertexPathDescription = null;
            if (!this.inPredicateMode()) {
                intermediateVertexPathDescription = (IntermediateVertexPathDescription)this.addPathElement(IntermediateVertexPathDescription.VC, IsSubPathOf.EC, null, pathDescription, n, n2, pathDescription2, n5, n6);
                IsIntermediateVertexOf isIntermediateVertexOf = this.graph.createIsIntermediateVertexOf(expression, intermediateVertexPathDescription);
                isIntermediateVertexOf.set_sourcePositions(this.createSourcePositionList(n4, n3));
            }
            return intermediateVertexPathDescription;
        }
        return pathDescription;
    }

    private final PathDescription parseSequentialPathDescription() {
        int n = this.getCurrentOffset();
        PathDescription pathDescription = this.parseStartRestrictedPathDescription();
        int n2 = this.getLength(n);
        this.predicateStart();
        try {
            this.parseSequentialPathDescription();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            int n3 = this.getCurrentOffset();
            PathDescription pathDescription2 = this.parseSequentialPathDescription();
            int n4 = this.getLength(n3);
            if (!this.inPredicateMode()) {
                return this.addPathElement(SequentialPathDescription.VC, IsSequenceElementOf.EC, null, pathDescription, n, n2, pathDescription2, n3, n4);
            }
            return null;
        }
        return pathDescription;
    }

    private final PathDescription parseStartRestrictedPathDescription() {
        int n = this.getCurrentOffset();
        List<VertexPosition<? extends TypeOrRoleId>> list = null;
        Expression expression = null;
        int n2 = 0;
        int n3 = 0;
        if (this.tryMatch(TokenTypes.LCURLY)) {
            this.predicateStart();
            try {
                this.parseTypeAndRoleExpressionList();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                list = this.parseTypeAndRoleExpressionList();
            }
            if (this.tryMatch(TokenTypes.AT)) {
                n3 = this.getCurrentOffset();
                expression = this.parseExpression();
                n2 = this.getLength(n3);
            }
            this.match(TokenTypes.RCURLY);
            this.match(TokenTypes.AMP);
        }
        PathDescription pathDescription = this.parseGoalRestrictedPathDescription();
        if (!this.inPredicateMode()) {
            if (expression != null) {
                IsStartRestrOf isStartRestrOf = this.graph.createIsStartRestrOf(expression, pathDescription);
                isStartRestrOf.set_sourcePositions(this.createSourcePositionList(n2, n));
            }
            if (list != null) {
                for (VertexPosition vertexPosition : list) {
                    IsStartRestrOf isStartRestrOf = this.graph.createIsStartRestrOf((Expression)vertexPosition.node, pathDescription);
                    isStartRestrOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                }
            }
        }
        return pathDescription;
    }

    private final PathDescription parseGoalRestrictedPathDescription() {
        PathDescription pathDescription = this.parseIteratedOrTransposedPathDescription();
        if (this.tryMatch(TokenTypes.AMP)) {
            IsGoalRestrOf isGoalRestrOf;
            this.match(TokenTypes.LCURLY);
            this.predicateStart();
            try {
                this.parseTypeAndRoleExpressionList();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                List<VertexPosition<? extends TypeOrRoleId>> list = this.parseTypeAndRoleExpressionList();
                if (!this.inPredicateMode()) {
                    for (VertexPosition vertexPosition : list) {
                        isGoalRestrOf = this.graph.createIsGoalRestrOf((Expression)vertexPosition.node, pathDescription);
                        isGoalRestrOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                    }
                }
            }
            if (this.tryMatch(TokenTypes.AT)) {
                int n = this.getCurrentOffset();
                Expression expression = this.parseExpression();
                int n2 = this.getLength(n);
                if (!this.inPredicateMode()) {
                    isGoalRestrOf = this.graph.createIsGoalRestrOf(expression, pathDescription);
                    isGoalRestrOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                }
            }
            this.match(TokenTypes.RCURLY);
        }
        return pathDescription;
    }

    private final PathDescription parseIteratedOrTransposedPathDescription() {
        int n = this.getCurrentOffset();
        PathDescription pathDescription = this.parsePrimaryPathDescription();
        int n2 = this.getLength(n);
        if (this.lookAhead(0) == TokenTypes.STAR || this.lookAhead(0) == TokenTypes.PLUS || this.lookAhead(0) == TokenTypes.TRANSPOSED || this.lookAhead(0) == TokenTypes.CARET) {
            return this.parseIteration(pathDescription, n, n2);
        }
        return pathDescription;
    }

    private final PathDescription parseIteration(PathDescription pathDescription, int n, int n2) {
        IterationType iterationType = null;
        PathDescription pathDescription2 = null;
        if (this.tryMatch(TokenTypes.STAR)) {
            iterationType = IterationType.STAR;
        } else if (this.tryMatch(TokenTypes.PLUS)) {
            iterationType = IterationType.PLUS;
        }
        if (iterationType != null) {
            if (!this.inPredicateMode()) {
                IteratedPathDescription iteratedPathDescription = this.graph.createIteratedPathDescription();
                iteratedPathDescription.set_times(iterationType);
                IsIteratedPathOf isIteratedPathOf = this.graph.createIsIteratedPathOf(pathDescription, iteratedPathDescription);
                isIteratedPathOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                pathDescription2 = iteratedPathDescription;
            }
        } else if (this.tryMatch(TokenTypes.TRANSPOSED)) {
            if (!this.inPredicateMode()) {
                TransposedPathDescription transposedPathDescription = this.graph.createTransposedPathDescription();
                IsTransposedPathOf isTransposedPathOf = this.graph.createIsTransposedPathOf(pathDescription, transposedPathDescription);
                isTransposedPathOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                pathDescription2 = transposedPathDescription;
            }
        } else if (this.tryMatch(TokenTypes.CARET)) {
            int n3 = this.getCurrentOffset();
            Expression expression = this.parseNumericLiteral();
            if (!this.inPredicateMode()) {
                if (!(expression instanceof IntLiteral)) {
                    this.fail("Expected integer constant as iteration quantifier or T, but found");
                }
                int n4 = this.getLength(n3);
                ExponentiatedPathDescription exponentiatedPathDescription = this.graph.createExponentiatedPathDescription();
                IsExponentiatedPathOf isExponentiatedPathOf = this.graph.createIsExponentiatedPathOf(pathDescription, exponentiatedPathDescription);
                isExponentiatedPathOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                IsExponentOf isExponentOf = this.graph.createIsExponentOf((IntLiteral)expression, exponentiatedPathDescription);
                isExponentOf.set_sourcePositions(this.createSourcePositionList(n4, n3));
                pathDescription2 = exponentiatedPathDescription;
            }
        } else {
            this.fail("No iteration or transposition at iterated path description");
        }
        if (this.lookAhead(0) == TokenTypes.STAR || this.lookAhead(0) == TokenTypes.PLUS || this.lookAhead(0) == TokenTypes.CARET) {
            return this.parseIteration(pathDescription2, n, this.getLength(n));
        }
        return pathDescription2;
    }

    private final PathDescription parsePrimaryPathDescription() {
        if (this.lookAhead(0) == TokenTypes.LPAREN) {
            this.predicateStart();
            try {
                this.match(TokenTypes.LPAREN);
                this.parseAltPathDescription();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                this.match(TokenTypes.LPAREN);
                PathDescription pathDescription = this.parseAltPathDescription();
                this.match(TokenTypes.RPAREN);
                return pathDescription;
            }
        }
        if (this.lookAhead(0) == TokenTypes.OUTAGGREGATION || this.lookAhead(0) == TokenTypes.INAGGREGATION) {
            return this.parseAggregationPathDescription();
        }
        if (this.lookAhead(0) == TokenTypes.RARROW || this.lookAhead(0) == TokenTypes.LARROW || this.lookAhead(0) == TokenTypes.ARROW) {
            return this.parseSimplePathDescription();
        }
        if (this.lookAhead(0) == TokenTypes.EDGESTART || this.lookAhead(0) == TokenTypes.EDGEEND || this.lookAhead(0) == TokenTypes.EDGE) {
            return this.parseEdgePathDescription();
        }
        if (this.tryMatch(TokenTypes.LBRACK)) {
            int n = this.getCurrentOffset();
            PathDescription pathDescription = this.parseAltPathDescription();
            int n2 = this.getLength(n);
            this.match(TokenTypes.RBRACK);
            if (!this.inPredicateMode()) {
                OptionalPathDescription optionalPathDescription = this.graph.createOptionalPathDescription();
                IsOptionalPathOf isOptionalPathOf = this.graph.createIsOptionalPathOf(pathDescription, optionalPathDescription);
                isOptionalPathOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                return optionalPathDescription;
            }
            return null;
        }
        this.fail("Unrecognized token");
        return null;
    }

    private final PrimaryPathDescription parseSimplePathDescription() {
        Direction direction = null;
        EdgeRestriction edgeRestriction = null;
        GReQLDirection gReQLDirection = GReQLDirection.INOUT;
        int n = this.getCurrentOffset();
        int n2 = 0;
        int n3 = 0;
        if (this.tryMatch(TokenTypes.RARROW)) {
            gReQLDirection = GReQLDirection.OUT;
        } else if (this.tryMatch(TokenTypes.LARROW)) {
            gReQLDirection = GReQLDirection.IN;
        } else {
            this.match(TokenTypes.ARROW);
        }
        if (this.tryMatch(TokenTypes.LCURLY)) {
            n2 = this.getCurrentOffset();
            edgeRestriction = this.parseEdgeRestriction();
            n3 = this.getLength(n2);
            this.match(TokenTypes.RCURLY);
        }
        if (!this.inPredicateMode()) {
            SimplePathDescription simplePathDescription = this.graph.createSimplePathDescription();
            for (direction = (Direction)this.graph.getFirstVertex(Direction.VC); direction != null && !direction.get_dirValue().equals((Object)gReQLDirection); direction = direction.getNextDirection()) {
            }
            if (direction == null) {
                direction = this.graph.createDirection();
                direction.set_dirValue(gReQLDirection);
            }
            IsDirectionOf isDirectionOf = this.graph.createIsDirectionOf(direction, simplePathDescription);
            isDirectionOf.set_sourcePositions(this.createSourcePositionList(0, n));
            if (edgeRestriction != null) {
                IsEdgeRestrOf isEdgeRestrOf = this.graph.createIsEdgeRestrOf(edgeRestriction, simplePathDescription);
                isEdgeRestrOf.set_sourcePositions(this.createSourcePositionList(n3, n2));
            }
            return simplePathDescription;
        }
        return null;
    }

    private final PrimaryPathDescription parseAggregationPathDescription() {
        boolean bl = true;
        EdgeRestriction edgeRestriction = null;
        int n = 0;
        int n2 = 0;
        if (this.tryMatch(TokenTypes.INAGGREGATION)) {
            bl = false;
        } else {
            this.match(TokenTypes.OUTAGGREGATION);
        }
        if (this.tryMatch(TokenTypes.LCURLY)) {
            n = this.getCurrentOffset();
            edgeRestriction = this.parseEdgeRestriction();
            n2 = this.getLength(n);
            this.match(TokenTypes.RCURLY);
        }
        if (!this.inPredicateMode()) {
            AggregationPathDescription aggregationPathDescription = this.graph.createAggregationPathDescription();
            aggregationPathDescription.set_outAggregation(bl);
            if (edgeRestriction != null) {
                IsEdgeRestrOf isEdgeRestrOf = this.graph.createIsEdgeRestrOf(edgeRestriction, aggregationPathDescription);
                isEdgeRestrOf.set_sourcePositions(this.createSourcePositionList(n2, n));
            }
            return aggregationPathDescription;
        }
        return null;
    }

    private final EdgePathDescription parseEdgePathDescription() {
        Direction direction = null;
        boolean bl = false;
        boolean bl2 = false;
        GReQLDirection gReQLDirection = GReQLDirection.INOUT;
        int n = this.getCurrentOffset();
        if (this.tryMatch(TokenTypes.EDGESTART)) {
            bl = true;
        } else {
            this.match(TokenTypes.EDGE);
        }
        int n2 = this.getCurrentOffset();
        Expression expression = this.parseExpression();
        int n3 = this.getLength(n2);
        if (this.tryMatch(TokenTypes.EDGEEND)) {
            bl2 = true;
        } else {
            this.match(TokenTypes.EDGE);
        }
        if (!this.inPredicateMode()) {
            int n4 = this.getLength(n);
            EdgePathDescription edgePathDescription = this.graph.createEdgePathDescription();
            if (bl && !bl2) {
                gReQLDirection = GReQLDirection.IN;
            } else if (!bl && bl2) {
                gReQLDirection = GReQLDirection.OUT;
            }
            for (direction = (Direction)this.graph.getFirstVertex(Direction.VC); direction != null && !direction.get_dirValue().equals((Object)gReQLDirection); direction = direction.getNextDirection()) {
            }
            if (direction == null) {
                direction = this.graph.createDirection();
                direction.set_dirValue(gReQLDirection);
            }
            IsDirectionOf isDirectionOf = this.graph.createIsDirectionOf(direction, edgePathDescription);
            isDirectionOf.set_sourcePositions(this.createSourcePositionList(n4, n));
            IsEdgeExprOf isEdgeExprOf = this.graph.createIsEdgeExprOf(expression, edgePathDescription);
            isEdgeExprOf.set_sourcePositions(this.createSourcePositionList(n3, n2));
            return edgePathDescription;
        }
        return null;
    }

    private final FunctionApplication parseFunctionApplication() {
        List<VertexPosition<TypeId>> list = null;
        if (!(this.lookAhead(0) != TokenTypes.IDENTIFIER && this.lookAhead(0) != TokenTypes.AND && this.lookAhead(0) != TokenTypes.NOT && this.lookAhead(0) != TokenTypes.XOR && this.lookAhead(0) != TokenTypes.OR || !this.isFunctionName(this.lookAhead.getValue()) || this.lookAhead(1) != TokenTypes.LCURLY && this.lookAhead(1) != TokenTypes.LPAREN)) {
            int n = this.getCurrentOffset();
            String string = this.lookAhead.getValue();
            this.match();
            int n2 = this.getLength(n);
            if (this.tryMatch(TokenTypes.LCURLY)) {
                list = this.parseTypeExpressionList();
                this.match(TokenTypes.RCURLY);
            }
            this.match(TokenTypes.LPAREN);
            List<VertexPosition<Expression>> list2 = null;
            if (this.lookAhead(0) != TokenTypes.RPAREN) {
                list2 = this.parseExpressionList(TokenTypes.COMMA);
            }
            this.match(TokenTypes.RPAREN);
            if (!this.inPredicateMode()) {
                GreqlAggregation greqlAggregation;
                FunctionApplication functionApplication = this.graph.createFunctionApplication();
                FunctionId functionId = this.getFunctionId(string);
                IsFunctionIdOf isFunctionIdOf = this.graph.createIsFunctionIdOf(functionId, functionApplication);
                isFunctionIdOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                if (list != null) {
                    for (VertexPosition<Expression> vertexPosition : list) {
                        greqlAggregation = this.graph.createIsTypeExprOfFunction((Expression)vertexPosition.node, functionApplication);
                        greqlAggregation.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                    }
                }
                if (list2 != null) {
                    for (VertexPosition<Expression> vertexPosition : list2) {
                        greqlAggregation = this.graph.createIsArgumentOf((Expression)vertexPosition.node, functionApplication);
                        greqlAggregation.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                    }
                }
                return functionApplication;
            }
            return null;
        }
        this.fail("No function application");
        return null;
    }

    private final Expression parseValueConstruction() {
        if (this.lookAhead(0) != null) {
            switch (this.lookAhead(0)) {
                case REC: {
                    return this.parseRecordConstruction();
                }
                case MAP: {
                    return this.parseMapConstruction();
                }
                case LIST: {
                    return this.parseListConstruction();
                }
                case SET: {
                    this.match();
                    this.match(TokenTypes.LPAREN);
                    if (this.tryMatch(TokenTypes.RPAREN)) {
                        return this.graph.createSetConstruction();
                    }
                    List<VertexPosition<Expression>> list = this.parseExpressionList(TokenTypes.COMMA);
                    this.match(TokenTypes.RPAREN);
                    if (!this.inPredicateMode()) {
                        return this.createPartsOfValueConstruction(list, this.graph.createSetConstruction());
                    }
                    return null;
                }
                case TUP: {
                    this.match();
                    this.match(TokenTypes.LPAREN);
                    if (this.tryMatch(TokenTypes.RPAREN)) {
                        return this.graph.createTupleConstruction();
                    }
                    List<VertexPosition<Expression>> list = this.parseExpressionList(TokenTypes.COMMA);
                    this.match(TokenTypes.RPAREN);
                    if (!this.inPredicateMode()) {
                        return this.createPartsOfValueConstruction(list, this.graph.createTupleConstruction());
                    }
                    return null;
                }
            }
        }
        this.fail("Expected value construction, but found");
        return null;
    }

    private final MapConstruction parseMapConstruction() {
        IsValueExprOfConstruction isValueExprOfConstruction;
        IsKeyExprOfConstruction isKeyExprOfConstruction;
        this.match(TokenTypes.MAP);
        this.match(TokenTypes.LPAREN);
        if (this.tryMatch(TokenTypes.RPAREN)) {
            return this.graph.createMapConstruction();
        }
        MapConstruction mapConstruction = null;
        if (!this.inPredicateMode()) {
            mapConstruction = this.graph.createMapConstruction();
        }
        int n = this.getCurrentOffset();
        Expression expression = this.parseExpression();
        int n2 = this.getLength(n);
        this.match(TokenTypes.EDGEEND);
        int n3 = this.getCurrentOffset();
        Expression expression2 = this.parseExpression();
        int n4 = this.getLength(n3);
        if (!this.inPredicateMode()) {
            isKeyExprOfConstruction = this.graph.createIsKeyExprOfConstruction(expression, mapConstruction);
            isKeyExprOfConstruction.set_sourcePositions(this.createSourcePositionList(n2, n));
            isValueExprOfConstruction = this.graph.createIsValueExprOfConstruction(expression2, mapConstruction);
            isValueExprOfConstruction.set_sourcePositions(this.createSourcePositionList(n4, n3));
        }
        while (this.tryMatch(TokenTypes.COMMA)) {
            n = this.getCurrentOffset();
            expression = this.parseExpression();
            n2 = this.getLength(n);
            this.match(TokenTypes.EDGEEND);
            n3 = this.getCurrentOffset();
            expression2 = this.parseExpression();
            n4 = this.getLength(n3);
            if (this.inPredicateMode()) continue;
            isKeyExprOfConstruction = this.graph.createIsKeyExprOfConstruction(expression, mapConstruction);
            isKeyExprOfConstruction.set_sourcePositions(this.createSourcePositionList(n2, n));
            isValueExprOfConstruction = this.graph.createIsValueExprOfConstruction(expression2, mapConstruction);
            isValueExprOfConstruction.set_sourcePositions(this.createSourcePositionList(n4, n3));
        }
        this.match(TokenTypes.RPAREN);
        return mapConstruction;
    }

    private final ValueConstruction parseListConstruction() {
        this.match(TokenTypes.LIST);
        this.match(TokenTypes.LPAREN);
        if (this.tryMatch(TokenTypes.RPAREN)) {
            return this.graph.createListConstruction();
        }
        ValueConstruction valueConstruction = null;
        int n = this.getCurrentOffset();
        Expression expression = this.parseExpression();
        int n2 = this.getLength(n);
        if (this.tryMatch(TokenTypes.DOTDOT)) {
            int n3 = this.getCurrentOffset();
            Expression expression2 = this.parseExpression();
            int n4 = this.getLength(n3);
            if (!this.inPredicateMode()) {
                valueConstruction = this.graph.createListRangeConstruction();
                IsFirstValueOf isFirstValueOf = this.graph.createIsFirstValueOf(expression, (ListRangeConstruction)valueConstruction);
                isFirstValueOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                IsLastValueOf isLastValueOf = this.graph.createIsLastValueOf(expression2, (ListRangeConstruction)valueConstruction);
                isLastValueOf.set_sourcePositions(this.createSourcePositionList(n4, n3));
            }
        } else {
            List<VertexPosition<Expression>> list = null;
            if (this.tryMatch(TokenTypes.COMMA)) {
                list = this.parseExpressionList(TokenTypes.COMMA);
            }
            if (!this.inPredicateMode()) {
                VertexPosition<Expression> vertexPosition = new VertexPosition<Expression>(expression, n2, n);
                if (list == null) {
                    list = new ArrayList<VertexPosition<Expression>>(1);
                }
                list.add(0, vertexPosition);
                valueConstruction = this.createPartsOfValueConstruction(list, this.graph.createListConstruction());
            }
        }
        this.match(TokenTypes.RPAREN);
        return valueConstruction;
    }

    private final ValueConstruction parseRecordConstruction() {
        this.match(TokenTypes.REC);
        this.match(TokenTypes.LPAREN);
        ArrayList<VertexPosition<RecordElement>> arrayList = new ArrayList<VertexPosition<RecordElement>>();
        do {
            int n = this.getCurrentOffset();
            RecordElement recordElement = this.parseRecordElement();
            int n2 = this.getLength(n);
            arrayList.add(new VertexPosition<RecordElement>(recordElement, n2, n));
        } while (this.tryMatch(TokenTypes.COMMA));
        this.match(TokenTypes.RPAREN);
        if (!this.inPredicateMode()) {
            RecordConstruction recordConstruction = this.graph.createRecordConstruction();
            if (arrayList != null) {
                for (VertexPosition vertexPosition : arrayList) {
                    IsRecordElementOf isRecordElementOf = this.graph.createIsRecordElementOf((RecordElement)vertexPosition.node, recordConstruction);
                    isRecordElementOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                }
            }
            return recordConstruction;
        }
        return null;
    }

    private final RecordElement parseRecordElement() {
        int n = this.getCurrentOffset();
        String string = this.matchIdentifier();
        int n2 = this.getLength(n);
        this.match(TokenTypes.COLON);
        int n3 = this.getCurrentOffset();
        Expression expression = this.parseExpression();
        int n4 = this.getLength(n3);
        if (!this.inPredicateMode()) {
            RecordId recordId = this.graph.createRecordId();
            recordId.set_name(string);
            RecordElement recordElement = this.graph.createRecordElement();
            IsRecordIdOf isRecordIdOf = this.graph.createIsRecordIdOf(recordId, recordElement);
            isRecordIdOf.set_sourcePositions(this.createSourcePositionList(n2, n));
            IsRecordExprOf isRecordExprOf = this.graph.createIsRecordExprOf(expression, recordElement);
            isRecordExprOf.set_sourcePositions(this.createSourcePositionList(n4, n3));
            return recordElement;
        }
        return null;
    }

    private final Declaration parseQuantifiedDeclaration() {
        List<VertexPosition<SimpleDeclaration>> list = this.parseDeclarationList();
        Declaration declaration = null;
        if (!this.inPredicateMode()) {
            declaration = (Declaration)this.createMultipleEdgesToParent(list, (Vertex)this.graph.createDeclaration(), IsSimpleDeclOf.EC, false);
        }
        while (this.tryMatch(TokenTypes.COMMA)) {
            int n = this.getCurrentOffset();
            Expression expression = this.parseExpression();
            int n2 = this.getLength(n);
            if (!this.inPredicateMode()) {
                IsConstraintOf isConstraintOf = this.graph.createIsConstraintOf(expression, declaration);
                isConstraintOf.set_sourcePositions(this.createSourcePositionList(n2, n));
            }
            this.predicateStart();
            try {
                this.match(TokenTypes.COMMA);
                this.parseSimpleDeclaration();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (!this.predicateEnd()) continue;
            this.match(TokenTypes.COMMA);
            list = this.parseDeclarationList();
            if (this.inPredicateMode()) continue;
            this.createMultipleEdgesToParent(list, (Vertex)declaration, IsSimpleDeclOf.EC, false);
        }
        return declaration;
    }

    private final List<VertexPosition<SimpleDeclaration>> parseDeclarationList() {
        ArrayList<VertexPosition<SimpleDeclaration>> arrayList = new ArrayList<VertexPosition<SimpleDeclaration>>();
        int n = this.getCurrentOffset();
        SimpleDeclaration simpleDeclaration = this.parseSimpleDeclaration();
        int n2 = this.getLength(n);
        arrayList.add(new VertexPosition<SimpleDeclaration>(simpleDeclaration, n2, n));
        if (this.lookAhead(0) == TokenTypes.COMMA) {
            this.predicateStart();
            try {
                this.match(TokenTypes.COMMA);
                this.parseSimpleDeclaration();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                this.match(TokenTypes.COMMA);
                arrayList.addAll(this.parseDeclarationList());
            }
        }
        return arrayList;
    }

    private final SimpleDeclaration parseSimpleDeclaration() {
        List<VertexPosition<Variable>> list = this.parseVariableList();
        this.match(TokenTypes.COLON);
        int n = this.getCurrentOffset();
        Expression expression = this.parseExpression();
        int n2 = this.getLength(n);
        if (!this.inPredicateMode()) {
            SimpleDeclaration simpleDeclaration = (SimpleDeclaration)this.createMultipleEdgesToParent(list, (Vertex)this.graph.createSimpleDeclaration(), IsDeclaredVarOf.EC, "");
            IsTypeExprOfDeclaration isTypeExprOfDeclaration = this.graph.createIsTypeExprOfDeclaration(expression, simpleDeclaration);
            isTypeExprOfDeclaration.set_sourcePositions(this.createSourcePositionList(n2, n));
            return simpleDeclaration;
        }
        return null;
    }

    private final List<VertexPosition<Expression>> parseExpressionList(TokenTypes tokenTypes) {
        int n = this.alreadySucceeded(RuleEnum.EXPRESSION_LIST);
        if (this.skipRule(n)) {
            return null;
        }
        ArrayList<VertexPosition<Expression>> arrayList = new ArrayList<VertexPosition<Expression>>();
        do {
            int n2 = this.getCurrentOffset();
            Expression expression = this.parseExpression();
            int n3 = this.getLength(n2);
            arrayList.add(new VertexPosition<Expression>(expression, n3, n2));
        } while (this.tryMatch(tokenTypes));
        this.ruleSucceeds(RuleEnum.EXPRESSION_LIST, n);
        return arrayList;
    }

    private final Expression parseRangeExpression() {
        ElementSetExpression elementSetExpression = null;
        if (this.tryMatch(TokenTypes.V)) {
            if (!this.inPredicateMode()) {
                elementSetExpression = this.graph.createVertexSetExpression();
            }
        } else {
            this.match(TokenTypes.E);
            if (!this.inPredicateMode()) {
                elementSetExpression = this.graph.createEdgeSetExpression();
            }
        }
        if (this.tryMatch(TokenTypes.LCURLY) && !this.tryMatch(TokenTypes.RCURLY)) {
            List<VertexPosition<TypeId>> list = this.parseTypeExpressionList();
            this.match(TokenTypes.RCURLY);
            if (!this.inPredicateMode()) {
                this.createMultipleEdgesToParent(list, (Vertex)elementSetExpression, IsTypeRestrOfExpression.EC, 0);
            }
        }
        return elementSetExpression;
    }

    private final List<VertexPosition<TypeId>> parseTypeExpressionList() {
        ArrayList<VertexPosition<TypeId>> arrayList = new ArrayList<VertexPosition<TypeId>>();
        do {
            int n = this.getCurrentOffset();
            TypeId typeId = this.parseTypeId();
            int n2 = this.getLength(n);
            arrayList.add(new VertexPosition<TypeId>(typeId, n2, n));
        } while (this.tryMatch(TokenTypes.COMMA));
        return arrayList;
    }

    private final TypeId parseTypeId() {
        TypeId typeId = null;
        if (!this.inPredicateMode()) {
            typeId = this.graph.createTypeId();
        }
        if (this.tryMatch(TokenTypes.CARET) && !this.inPredicateMode()) {
            typeId.set_excluded(true);
        }
        String string = this.matchQualifiedName();
        if (!this.inPredicateMode()) {
            typeId.set_name(string);
        }
        if (this.tryMatch(TokenTypes.EXCL) && !this.inPredicateMode()) {
            typeId.set_type(true);
        }
        return typeId;
    }

    private TypeOrRoleId parseTypeOrRoleId() {
        TypeOrRoleId typeOrRoleId = null;
        this.predicateStart();
        try {
            this.parseTypeId();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        typeOrRoleId = this.predicateEnd() ? this.parseTypeId() : this.parseRoleId();
        return typeOrRoleId;
    }

    private final List<VertexPosition<? extends TypeOrRoleId>> parseTypeAndRoleExpressionList() {
        ArrayList<VertexPosition<? extends TypeOrRoleId>> arrayList = new ArrayList<VertexPosition<? extends TypeOrRoleId>>();
        do {
            int n = this.getCurrentOffset();
            TypeOrRoleId typeOrRoleId = this.parseTypeOrRoleId();
            int n2 = this.getLength(n);
            arrayList.add(new VertexPosition<TypeOrRoleId>(typeOrRoleId, n2, n));
        } while (this.tryMatch(TokenTypes.COMMA));
        return arrayList;
    }

    private final EdgeRestriction parseEdgeRestriction() {
        Object object;
        Object object2;
        ArrayList<VertexPosition> arrayList = null;
        ArrayList<VertexPosition> arrayList2 = null;
        Expression expression = null;
        int n = 0;
        int n2 = 0;
        this.predicateStart();
        try {
            this.parseTypeOrRoleId();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd() && (object2 = this.parseTypeAndRoleExpressionList()) != null) {
            arrayList = new ArrayList<VertexPosition>();
            arrayList2 = new ArrayList<VertexPosition>();
            object = object2.iterator();
            while (object.hasNext()) {
                VertexPosition vertexPosition = (VertexPosition)object.next();
                if (vertexPosition.node instanceof TypeId) {
                    arrayList.add(vertexPosition);
                    continue;
                }
                arrayList2.add(vertexPosition);
            }
        }
        if (this.tryMatch(TokenTypes.AT)) {
            n = this.getCurrentOffset();
            expression = this.parseExpression();
            n2 = this.getLength(n);
        }
        object2 = null;
        if (!this.inPredicateMode()) {
            GreqlAggregation greqlAggregation;
            object2 = this.graph.createEdgeRestriction();
            if (arrayList != null) {
                for (VertexPosition vertexPosition : arrayList) {
                    greqlAggregation = this.graph.createIsTypeIdOf((TypeId)vertexPosition.node, (EdgeRestriction)object2);
                    greqlAggregation.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                }
            }
            if (arrayList2 != null) {
                for (VertexPosition vertexPosition : arrayList2) {
                    greqlAggregation = this.graph.createIsRoleIdOf((RoleId)vertexPosition.node, (EdgeRestriction)object2);
                    greqlAggregation.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                }
            }
            if (expression != null) {
                object = this.graph.createIsBooleanPredicateOfEdgeRestriction(expression, (EdgeRestriction)object2);
                object.set_sourcePositions(this.createSourcePositionList(n2, n));
            }
        }
        return object2;
    }

    private final Comprehension parseLabeledReportList() {
        Edge edge;
        GraphElement<EdgeClass, Edge> graphElement;
        TupleConstruction tupleConstruction = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ListComprehension listComprehension = null;
        Expression expression = null;
        int n5 = 0;
        Expression expression2 = null;
        this.match(TokenTypes.REPORT);
        do {
            bl = false;
            n2 = n = this.getCurrentOffset();
            expression = this.parseExpression();
            n5 = this.getLength(n);
            if (this.tryMatch(TokenTypes.AS)) {
                n3 = this.getCurrentOffset();
                expression2 = this.parseExpression();
                n4 = this.getLength(n3);
                bl = true;
            }
            if (this.inPredicateMode()) continue;
            if (listComprehension == null) {
                listComprehension = this.graph.createListComprehension();
                tupleConstruction = this.graph.createTupleConstruction();
                graphElement = this.graph.createIsCompResultDefOf(tupleConstruction, listComprehension);
                graphElement.set_sourcePositions(this.createSourcePositionList(this.getLength(n2), n2));
            }
            graphElement = this.graph.createIsPartOf(expression, tupleConstruction);
            graphElement.set_sourcePositions(this.createSourcePositionList(n5, n));
            if (!bl) continue;
            edge = this.graph.createIsTableHeaderOf(expression2, listComprehension);
            edge.set_sourcePositions(this.createSourcePositionList(n4, n3));
        } while (this.tryMatch(TokenTypes.COMMA));
        if (!this.inPredicateMode() && tupleConstruction.getDegree(EdgeDirection.IN) == 1) {
            graphElement = tupleConstruction.getFirstIncidence(EdgeDirection.IN).getAlpha();
            edge = tupleConstruction.getFirstIncidence(EdgeDirection.OUT);
            edge.setAlpha((Vertex)graphElement);
            tupleConstruction.delete();
        }
        return listComprehension;
    }

    private final Comprehension parseReportClause() {
        Comprehension comprehension = null;
        boolean bl = false;
        TokenTypes tokenTypes = TokenTypes.COMMA;
        TokenTypes tokenTypes2 = this.lookAhead(0);
        switch (tokenTypes2) {
            case REPORT: {
                return this.parseLabeledReportList();
            }
            case REPORTLIST: 
            case REPORTLISTN: {
                if (!this.inPredicateMode()) {
                    comprehension = this.graph.createListComprehension();
                }
                this.match();
                if (tokenTypes2 != TokenTypes.REPORTLISTN) break;
                Expression expression = this.parseExpression();
                if (!this.inPredicateMode()) {
                    comprehension.add_maxCount(expression);
                }
                this.match(TokenTypes.COLON);
                break;
            }
            case REPORTSET: 
            case REPORTSETN: {
                if (!this.inPredicateMode()) {
                    comprehension = this.graph.createSetComprehension();
                }
                this.match();
                if (tokenTypes2 != TokenTypes.REPORTSETN) break;
                Expression expression = this.parseExpression();
                if (!this.inPredicateMode()) {
                    comprehension.add_maxCount(expression);
                }
                this.match(TokenTypes.COLON);
                break;
            }
            case REPORTMAP: 
            case REPORTMAPN: {
                if (!this.inPredicateMode()) {
                    comprehension = this.graph.createMapComprehension();
                }
                bl = true;
                tokenTypes = TokenTypes.EDGEEND;
                this.match();
                if (tokenTypes2 != TokenTypes.REPORTMAPN) break;
                Expression expression = this.parseExpression();
                if (!this.inPredicateMode()) {
                    comprehension.add_maxCount(expression);
                }
                this.match(TokenTypes.COLON);
                break;
            }
            default: {
                this.fail("Unrecognized token");
            }
        }
        int n = this.getCurrentOffset();
        List<VertexPosition<Expression>> list = this.parseExpressionList(tokenTypes);
        int n2 = this.getLength(n);
        IsCompResultDefOf isCompResultDefOf = null;
        if (bl) {
            if (!this.inPredicateMode()) {
                if (list.size() != 2) {
                    this.fail("reportMap keyExpr -> valueExpr must be followed by exactly two arguments");
                }
                IsKeyExprOfComprehension isKeyExprOfComprehension = this.graph.createIsKeyExprOfComprehension((Expression)list.get((int)0).node, (MapComprehension)comprehension);
                IsValueExprOfComprehension isValueExprOfComprehension = this.graph.createIsValueExprOfComprehension((Expression)list.get((int)1).node, (MapComprehension)comprehension);
                isKeyExprOfComprehension.set_sourcePositions(this.createSourcePositionList(list.get((int)0).length, list.get((int)0).offset));
                isValueExprOfComprehension.set_sourcePositions(this.createSourcePositionList(list.get((int)1).length, list.get((int)1).offset));
            }
        } else if (!this.inPredicateMode()) {
            if (list.size() > 1) {
                TupleConstruction tupleConstruction = (TupleConstruction)this.createMultipleEdgesToParent(list, this.graph.createTupleConstruction(), IsPartOf.EC);
                isCompResultDefOf = this.graph.createIsCompResultDefOf(tupleConstruction, comprehension);
            } else {
                isCompResultDefOf = this.graph.createIsCompResultDefOf((Expression)list.get((int)0).node, comprehension);
            }
            isCompResultDefOf.set_sourcePositions(this.createSourcePositionList(n2, n));
        }
        return comprehension;
    }

    private final Comprehension parseFWRExpression() {
        GraphElement<VertexClass, Vertex> graphElement;
        this.match(TokenTypes.FROM);
        int n = this.getCurrentOffset();
        this.duringParsingvariableSymbolTable.blockBegin();
        List<VertexPosition<SimpleDeclaration>> list = this.parseDeclarationList();
        int n2 = this.getLength(n);
        Declaration declaration = null;
        if (!this.inPredicateMode()) {
            declaration = this.graph.createDeclaration();
            this.createMultipleEdgesToParent(list, (Vertex)declaration, IsSimpleDeclOf.EC, false);
        }
        if (this.tryMatch(TokenTypes.WITH)) {
            int n3 = this.getCurrentOffset();
            graphElement = this.parseExpression();
            int n4 = this.getLength(n3);
            n2 += n4;
            if (!this.inPredicateMode()) {
                IsConstraintOf isConstraintOf = this.graph.createIsConstraintOf((Expression)graphElement, declaration);
                isConstraintOf.set_sourcePositions(this.createSourcePositionList(n4, n3));
            }
        }
        Comprehension comprehension = this.parseReportClause();
        if (!this.inPredicateMode()) {
            graphElement = this.graph.createIsCompDeclOf(declaration, comprehension);
            graphElement.set_sourcePositions(this.createSourcePositionList(n2, n));
        }
        this.match(TokenTypes.END);
        this.duringParsingvariableSymbolTable.blockEnd();
        return comprehension;
    }

    private final Expression parsePathExpression() {
        int n = this.alreadySucceeded(RuleEnum.PATH_EXPRESSION);
        if (this.skipRule(n)) {
            return null;
        }
        Expression expression = null;
        this.predicateStart();
        try {
            this.parseAltPathDescription();
            if (!this.tryMatch(TokenTypes.SMILEY)) {
                this.parseValueAccess();
            }
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            expression = this.parseRegBackwardVertexSetOrPathSystem();
        } else {
            this.predicateStart();
            try {
                this.parseValueAccess();
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                int n2 = this.getCurrentOffset();
                expression = this.parseValueAccess();
                int n3 = this.getLength(n2);
                if (this.lookAhead(0) == TokenTypes.SMILEY) {
                    expression = this.parseRegPathOrPathSystem(expression, n2, n3);
                } else {
                    this.predicateStart();
                    try {
                        this.parseAltPathDescription();
                    }
                    catch (ParsingException parsingException) {
                        // empty catch block
                    }
                    if (this.predicateEnd()) {
                        expression = this.parseRegPathExistenceOrForwardVertexSet(expression, n2, n3);
                    }
                }
            } else {
                expression = this.parseAltPathDescription();
            }
        }
        this.ruleSucceeds(RuleEnum.PATH_EXPRESSION, n);
        return expression;
    }

    private final Expression parseRegPathExistenceOrForwardVertexSet(Expression expression, int n, int n2) {
        int n3 = this.getCurrentOffset();
        int n4 = this.getCurrentOffset();
        PathDescription pathDescription = this.parseAltPathDescription();
        int n5 = this.getLength(n4);
        Expression expression2 = null;
        this.predicateStart();
        try {
            this.parsePrimaryExpression();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            expression2 = this.parseValueAccess();
            if (!this.inPredicateMode()) {
                int n6 = this.getLength(n3);
                PathExistence pathExistence = this.graph.createPathExistence();
                IsStartExprOf isStartExprOf = this.graph.createIsStartExprOf(expression, pathExistence);
                isStartExprOf.set_sourcePositions(this.createSourcePositionList(n2, n));
                IsTargetExprOf isTargetExprOf = this.graph.createIsTargetExprOf(expression2, pathExistence);
                isTargetExprOf.set_sourcePositions(this.createSourcePositionList(n6, n3));
                IsPathOf isPathOf = this.graph.createIsPathOf(pathDescription, pathExistence);
                isPathOf.set_sourcePositions(this.createSourcePositionList(n5, n4));
                return pathExistence;
            }
            return null;
        }
        if (!this.inPredicateMode()) {
            ForwardVertexSet forwardVertexSet = this.graph.createForwardVertexSet();
            IsStartExprOf isStartExprOf = this.graph.createIsStartExprOf(expression, forwardVertexSet);
            isStartExprOf.set_sourcePositions(this.createSourcePositionList(n2, n));
            IsPathOf isPathOf = this.graph.createIsPathOf(pathDescription, forwardVertexSet);
            isPathOf.set_sourcePositions(this.createSourcePositionList(n5, n4));
            return forwardVertexSet;
        }
        return null;
    }

    private final Expression parseRegPathOrPathSystem(Expression expression, int n, int n2) {
        boolean bl = false;
        int n3 = this.getCurrentOffset();
        int n4 = n;
        int n5 = 0;
        Expression expression2 = null;
        this.match(TokenTypes.SMILEY);
        int n6 = this.getCurrentOffset();
        PathDescription pathDescription = this.parseAltPathDescription();
        int n7 = this.getLength(n6);
        int n8 = this.getCurrentOffset();
        if (this.tryMatch(TokenTypes.SMILEY)) {
            n4 = this.getCurrentOffset();
            expression2 = this.parseValueAccess();
            n5 = this.getLength(n4);
        }
        if (!this.inPredicateMode()) {
            FunctionId functionId = this.getFunctionId("pathSystem");
            FunctionApplication functionApplication = this.createFunctionIdAndArgumentOf(functionId, n3, 3, expression, n, n2, pathDescription, n6, n7, true);
            if (bl) {
                functionApplication = this.createFunctionIdAndArgumentOf(functionId, n3, 3, functionApplication, n, -n + n8 + 3, expression2, n4, n5, true);
            }
            return functionApplication;
        }
        return null;
    }

    private final Expression parseRegBackwardVertexSetOrPathSystem() {
        boolean bl = false;
        int n = this.getCurrentOffset();
        PathDescription pathDescription = this.parseAltPathDescription();
        int n2 = this.getLength(n);
        int n3 = this.getCurrentOffset();
        if (this.tryMatch(TokenTypes.SMILEY)) {
            bl = true;
        }
        int n4 = this.getCurrentOffset();
        Expression expression = this.parseValueAccess();
        int n5 = this.getLength(n4);
        if (!this.inPredicateMode()) {
            if (bl) {
                FunctionId functionId = this.getFunctionId("pathSystem");
                return this.createFunctionIdAndArgumentOf(functionId, n3, 3, pathDescription, n, n2, expression, n4, n5, true);
            }
            BackwardVertexSet backwardVertexSet = this.graph.createBackwardVertexSet();
            IsTargetExprOf isTargetExprOf = this.graph.createIsTargetExprOf(expression, backwardVertexSet);
            isTargetExprOf.set_sourcePositions(this.createSourcePositionList(n5, n4));
            IsPathOf isPathOf = this.graph.createIsPathOf(pathDescription, backwardVertexSet);
            isPathOf.set_sourcePositions(this.createSourcePositionList(n2, n));
            return backwardVertexSet;
        }
        return null;
    }

    private final Expression parseNumericLiteral() {
        if (this.lookAhead(0) == TokenTypes.DOUBLELITERAL) {
            double d = ((DoubleToken)this.lookAhead).getNumber();
            this.match();
            if (!this.inPredicateMode()) {
                DoubleLiteral doubleLiteral = this.graph.createDoubleLiteral();
                doubleLiteral.set_doubleValue(d);
                return doubleLiteral;
            }
            return null;
        }
        if (this.lookAhead(0) == TokenTypes.LONGLITERAL) {
            long l = ((LongToken)this.lookAhead).getNumber();
            this.match();
            if (!this.inPredicateMode()) {
                if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    IntLiteral intLiteral = this.graph.createIntLiteral();
                    intLiteral.set_intValue((int)l);
                    return intLiteral;
                }
                LongLiteral longLiteral = this.graph.createLongLiteral();
                longLiteral.set_longValue(l);
                return longLiteral;
            }
            return null;
        }
        this.fail("Unrecognized literal");
        return null;
    }

    private final Expression parseLiteral() {
        if (this.lookAhead(0) != null) {
            switch (this.lookAhead(0)) {
                case UNDEFINED: {
                    UndefinedLiteral undefinedLiteral = null;
                    if (!this.inPredicateMode() && (undefinedLiteral = this.graph.getFirstUndefinedLiteral()) == null) {
                        undefinedLiteral = this.graph.createUndefinedLiteral();
                    }
                    this.match();
                    return undefinedLiteral;
                }
                case DOUBLELITERAL: 
                case LONGLITERAL: {
                    return this.parseNumericLiteral();
                }
                case STRING: {
                    StringLiteral stringLiteral = null;
                    if (!this.inPredicateMode()) {
                        stringLiteral = this.graph.createStringLiteral();
                        stringLiteral.set_stringValue(this.lookAhead.getValue());
                    }
                    this.match();
                    return stringLiteral;
                }
                case THISEDGE: {
                    this.match();
                    ThisEdge thisEdge = null;
                    if (!this.inPredicateMode() && (thisEdge = this.graph.getFirstThisEdge()) == null) {
                        thisEdge = this.graph.createThisEdge();
                    }
                    return thisEdge;
                }
                case THISVERTEX: {
                    this.match();
                    ThisVertex thisVertex = null;
                    if (!this.inPredicateMode() && (thisVertex = this.graph.getFirstThisVertex()) == null) {
                        thisVertex = this.graph.createThisVertex();
                    }
                    return thisVertex;
                }
                case TRUE: {
                    this.match();
                    BoolLiteral boolLiteral = null;
                    if (!this.inPredicateMode()) {
                        for (boolLiteral = this.graph.getFirstBoolLiteral(); boolLiteral != null && !boolLiteral.is_boolValue(); boolLiteral = boolLiteral.getNextBoolLiteral()) {
                        }
                        if (boolLiteral == null) {
                            boolLiteral = this.graph.createBoolLiteral();
                            boolLiteral.set_boolValue(true);
                        }
                    }
                    return boolLiteral;
                }
                case FALSE: {
                    this.match();
                    BoolLiteral boolLiteral = null;
                    if (!this.inPredicateMode()) {
                        for (boolLiteral = this.graph.getFirstBoolLiteral(); boolLiteral != null && boolLiteral.is_boolValue(); boolLiteral = boolLiteral.getNextBoolLiteral()) {
                        }
                        if (boolLiteral == null) {
                            boolLiteral = this.graph.createBoolLiteral();
                            boolLiteral.set_boolValue(false);
                        }
                    }
                    return boolLiteral;
                }
            }
        }
        this.fail("Unrecognized literal");
        return null;
    }

    public GreqlSchema getSchema() {
        return SCHEMA;
    }
}

