/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.gretl.AddSuperClass;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CopyDomain;
import de.uni_koblenz.jgralab.gretl.CreateAbstractEdgeClass;
import de.uni_koblenz.jgralab.gretl.CreateAbstractVertexClass;
import de.uni_koblenz.jgralab.gretl.CreateAttribute;
import de.uni_koblenz.jgralab.gretl.CreateEdgeClass;
import de.uni_koblenz.jgralab.gretl.CreateVertexClass;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CopyTransformation
extends Transformation<Graph> {
    protected Pattern excludePattern;
    protected Pattern includePattern;
    private final HashSet<String> vcsCreated = new HashSet();
    private final HashSet<String> ecsCreated = new HashSet();
    private final HashSet<String> attrsCreated = new HashSet();
    private static Logger logger = JGraLab.getLogger(CopyTransformation.class);

    public CopyTransformation(Context context, Pattern pattern, Pattern pattern2) {
        super(context);
        this.excludePattern = pattern;
        this.includePattern = pattern2;
    }

    public CopyTransformation(Context context) {
        this(context, null, null);
    }

    @Override
    protected final Graph transform() {
        this.createVertexClasses();
        this.transformVertexClasses();
        this.createEdgeClasses();
        this.transformEdgeClasses();
        this.createAttributes();
        return this.context.getTargetGraph();
    }

    protected void transformVertexClasses() {
    }

    protected void transformEdgeClasses() {
    }

    @Transformation.After
    protected void clearNameCaches() {
        this.vcsCreated.clear();
        this.ecsCreated.clear();
        this.attrsCreated.clear();
    }

    private void createAttributes() {
        for (Map.Entry<String, Graph> entry : this.context.getSourceGraphs().entrySet()) {
            String string = entry.getValue().getSchema().getQualifiedName();
            if (this.context.getPhase() == Context.TransformationPhase.SCHEMA && this.attrsCreated.contains(string)) continue;
            this.attrsCreated.add(string);
            GraphClass graphClass = entry.getValue().getSchema().getGraphClass();
            this.createAttributes(graphClass, entry);
            for (GraphElementClass<?, ?> graphElementClass : graphClass.getGraphElementClasses()) {
                if (this.isExcluded(graphElementClass.getQualifiedName())) continue;
                this.createAttributes(graphElementClass, entry);
            }
        }
    }

    private boolean isExcluded(String string) {
        if (this.excludePattern == null && this.includePattern == null) {
            return false;
        }
        if (this.excludePattern == null) {
            return !this.includePattern.matcher(string).matches();
        }
        if (this.includePattern == null) {
            return this.excludePattern.matcher(string).matches();
        }
        return this.excludePattern.matcher(string).matches() && !this.includePattern.matcher(string).matches();
    }

    private void createAttributes(AttributedElementClass<?, ?> attributedElementClass, Map.Entry<String, Graph> entry) {
        for (Attribute attribute : attributedElementClass.getOwnAttributeList()) {
            if (this.isExcluded(attributedElementClass.getQualifiedName() + "." + attribute.getName())) {
                logger.finer("Skipping attribute '" + attributedElementClass.getQualifiedName() + "#" + attribute.getName() + "' because it is excluded.");
                continue;
            }
            AttributedElementClass<?, ?> attributedElementClass2 = this.aec(attributedElementClass.getQualifiedName());
            if (attributedElementClass2 == null) {
                throw new GReTLException(this.context, "Cannot create attribute '" + attribute.getName() + "' when copying '" + attributedElementClass.getQualifiedName() + "'.");
            }
            Domain domain = (Domain)new CopyDomain(this.context, attribute.getDomain()).execute();
            String string = null;
            if (attributedElementClass instanceof GraphClass) {
                string = "#" + entry.getKey() + "# map(getGraph() -> " + CopyTransformation.getAttributeReportString("getGraph()", attribute.getName(), domain) + ")";
            } else {
                String string2 = "x";
                string = "#" + entry.getKey() + "# from " + string2 + " : keySet(" + Context.toGReTLVarNotation(attributedElementClass.getQualifiedName(), Context.GReTLVariableType.IMG) + ") reportMap " + string2 + " -> " + CopyTransformation.getAttributeReportString(string2, attribute.getName(), domain) + " end";
            }
            new CreateAttribute(this.context, new CreateAttribute.AttributeSpec(attributedElementClass2, attribute.getName(), domain, attribute.getDefaultValueAsString()), string).execute();
            logger.info("Copied Attribute '" + attributedElementClass.getQualifiedName() + "#" + attribute.getName() + "'.");
        }
    }

    public static String getAttributeReportString(String string, String string2, Domain domain) {
        StringBuilder stringBuilder = new StringBuilder();
        if (domain instanceof RecordDomain) {
            RecordDomain recordDomain = (RecordDomain)domain;
            stringBuilder.append("rec(");
            boolean bl = true;
            for (RecordDomain.RecordComponent recordComponent : recordDomain.getComponents()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(recordComponent.getName());
                stringBuilder.append(" : ");
                stringBuilder.append(string);
                stringBuilder.append(".");
                stringBuilder.append(recordComponent.getName());
            }
            stringBuilder.append(")");
        } else {
            stringBuilder.append(string);
            stringBuilder.append(".");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private void createEdgeClasses() {
        for (Map.Entry<String, Graph> entry : this.context.getSourceGraphs().entrySet()) {
            String string = entry.getValue().getSchema().getQualifiedName();
            if (this.context.getPhase() == Context.TransformationPhase.SCHEMA && this.ecsCreated.contains(string)) continue;
            this.ecsCreated.add(string);
            for (EdgeClass edgeClass : entry.getValue().getGraphClass().getEdgeClasses()) {
                if (this.isExcluded(edgeClass.getQualifiedName())) {
                    logger.finer("CopyTransformation: Skipped rule for EdgeClass " + edgeClass.getQualifiedName() + ", because it is excluded.");
                    continue;
                }
                IncidenceClass incidenceClass = edgeClass.getFrom();
                IncidenceClass incidenceClass2 = edgeClass.getTo();
                EdgeClass edgeClass2 = null;
                String string2 = edgeClass.getQualifiedName();
                VertexClass vertexClass = this.context.getTargetSchema().getGraphClass().getVertexClass(incidenceClass.getVertexClass().getQualifiedName());
                VertexClass vertexClass2 = this.context.getTargetSchema().getGraphClass().getVertexClass(incidenceClass2.getVertexClass().getQualifiedName());
                if (vertexClass == null && this.isExcluded(incidenceClass.getVertexClass().getQualifiedName()) || vertexClass2 == null && this.isExcluded(incidenceClass2.getVertexClass().getQualifiedName())) {
                    logger.finer("Skipping edge class '" + string2 + "' because its from or to vertex class is excluded.");
                    continue;
                }
                if (vertexClass == null || vertexClass2 == null) {
                    throw new GReTLException(this.context, "Couldn't get from or to vertex class of '" + string2 + "' although they are not excluded.");
                }
                if (edgeClass.isAbstract()) {
                    edgeClass2 = (EdgeClass)new CreateAbstractEdgeClass(this.context, string2, new CreateEdgeClass.IncidenceClassSpec(vertexClass, incidenceClass), new CreateEdgeClass.IncidenceClassSpec(vertexClass2, incidenceClass2)).execute();
                } else {
                    String string3 = "#" + entry.getKey() + "# from e : E{" + edgeClass.getQualifiedName() + "!} " + "reportSet e, startVertex(e), endVertex(e) end";
                    edgeClass2 = (EdgeClass)new CreateEdgeClass(this.context, string2, new CreateEdgeClass.IncidenceClassSpec(vertexClass, incidenceClass), new CreateEdgeClass.IncidenceClassSpec(vertexClass2, incidenceClass2), string3).execute();
                }
                assert (edgeClass2 != null) : "The newly created EdgeClass '" + string2 + "' is null!";
                for (EdgeClass edgeClass3 : edgeClass.getDirectSuperClasses()) {
                    if (this.isExcluded(edgeClass3.getQualifiedName())) continue;
                    EdgeClass edgeClass4 = edgeClass3;
                    EdgeClass edgeClass5 = this.ec(edgeClass4.getQualifiedName());
                    new AddSuperClass(this.context, edgeClass2, edgeClass5).execute();
                }
                logger.info("Copied EdgeClass '" + edgeClass.getQualifiedName() + "'.");
            }
        }
    }

    private void createVertexClasses() {
        for (Map.Entry<String, Graph> entry : this.context.getSourceGraphs().entrySet()) {
            String string = entry.getValue().getSchema().getQualifiedName();
            if (this.context.getPhase() == Context.TransformationPhase.SCHEMA && this.vcsCreated.contains(string)) continue;
            this.vcsCreated.add(string);
            for (VertexClass vertexClass : entry.getValue().getSchema().getGraphClass().getVertexClasses()) {
                if (this.isExcluded(vertexClass.getQualifiedName())) {
                    logger.finer("CopyTransformation: Skipped rule for VertexClass " + vertexClass.getQualifiedName() + ", because it is excluded.");
                    continue;
                }
                VertexClass vertexClass2 = null;
                vertexClass2 = vertexClass.isAbstract() ? (VertexClass)new CreateAbstractVertexClass(this.context, vertexClass.getQualifiedName()).execute() : (VertexClass)new CreateVertexClass(this.context, vertexClass.getQualifiedName(), "#" + entry.getKey() + "# V{" + vertexClass.getQualifiedName() + "!}").execute();
                for (VertexClass vertexClass3 : vertexClass.getDirectSuperClasses()) {
                    if (this.isExcluded(vertexClass3.getQualifiedName())) continue;
                    VertexClass vertexClass4 = (VertexClass)this.context.getTargetSchema().getAttributedElementClass(vertexClass3.getQualifiedName());
                    new AddSuperClass(this.context, vertexClass2, vertexClass4).execute();
                }
                logger.info("Copied VertexClass '" + vertexClass.getQualifiedName() + "'.");
            }
        }
    }
}

