/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateEdges;
import de.uni_koblenz.jgralab.gretl.CreateVertices;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.SetAttributes;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.gretl.template.CreateEdge;
import de.uni_koblenz.jgralab.gretl.template.CreateVertex;
import de.uni_koblenz.jgralab.gretl.template.TemplateGraph;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphParser;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.pcollections.Empty;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class CreateSubgraph
extends Transformation<Void> {
    private TemplateGraph templateGraph = null;
    private Object match;
    private String matchText;
    private Set<GraphElement<?, ?>> createdElements = new HashSet();

    public CreateSubgraph(Context context, String string, Object object) {
        super(context);
        this.templateGraph = TemplateGraphParser.parse(string);
        this.match = object;
    }

    public CreateSubgraph(Context context, String string, String string2) {
        super(context);
        this.templateGraph = TemplateGraphParser.parse(string);
        this.matchText = string2;
    }

    public CreateSubgraph(Context context, TemplateGraph templateGraph, String string) {
        super(context);
        this.templateGraph = templateGraph;
        this.matchText = string;
    }

    public static CreateSubgraph parseAndCreate(ExecuteTransformation executeTransformation) {
        TemplateGraph templateGraph = TemplateGraphParser.parse(executeTransformation.match((TokenTypes)TokenTypes.DOMAIN_SPECIFIC).value);
        executeTransformation.matchTransformationArrow();
        String string = executeTransformation.matchSemanticExpression();
        return new CreateSubgraph(executeTransformation.context, templateGraph, string);
    }

    private String getUniqueArchetype() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'");
        stringBuilder.append(this.context.getUniqueString().toString());
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    @Override
    protected Void transform() {
        if (this.context.getPhase() == Context.TransformationPhase.SCHEMA) {
            return null;
        }
        if (this.context.getTargetSchema() == null) {
            throw new GReTLException(this.context, CreateSubgraph.class.getSimpleName() + " needs an existing target schema!");
        }
        for (CreateVertex createVertex : this.templateGraph.getCreateVertexVertices()) {
            if (createVertex.get_archetype() != null) continue;
            throw new GReTLException(this.context, "All vertices in the template graph need to have an archetype!");
        }
        if (this.match == null) {
            this.match = this.context.evaluateGReQLQuery(this.matchText);
        }
        PSet<Object> pSet = null;
        if (this.match instanceof Collection) {
            pSet = (PSet)this.match;
        } else {
            pSet = Empty.set();
            pSet = pSet.plus(this.match);
        }
        this.applyVertexCreations(pSet);
        this.applyEdgeCreations(pSet);
        this.applyAttributeSetting(pSet);
        return null;
    }

    private void applyVertexCreations(PSet<Object> pSet) {
        for (CreateVertex createVertex : this.templateGraph.getCreateVertexVertices()) {
            String string = CreateSubgraph.getVertexClassName(createVertex, this.context);
            VertexClass vertexClass = this.vc(string);
            if (vertexClass == null) {
                throw new GReTLException(this.context, "There's no vertex class '" + string + "' in the target schema.");
            }
            PSet pSet2 = Empty.set();
            for (Object e : pSet) {
                this.context.setGReQLVariable("$", e);
                Object t = this.context.evaluateGReQLQuery(createVertex.get_archetype());
                if (this.context.getImg(vertexClass).containsKey(t)) {
                    logger.finer("There's already an image for '" + t + "' in " + Context.toGReTLVarNotation(string, Context.GReTLVariableType.IMG) + ", so we use that instead.");
                    continue;
                }
                pSet2 = pSet2.plus(t);
            }
            logger.finer("Instantiating " + pSet2.size() + " '" + vertexClass.getQualifiedName() + "' vertices.");
            this.createdElements.addAll((Collection)new CreateVertices(this.context, vertexClass, pSet2).execute());
        }
    }

    public static String getVertexClassName(CreateVertex createVertex, Context context) {
        if (createVertex.get_typeName() != null) {
            String string = createVertex.get_typeName();
            if (createVertex.is_typeNameIsQuery()) {
                return context.evaluateGReQLQuery(string).toString();
            }
            return createVertex.get_typeName();
        }
        VertexClass vertexClass = context.getTargetSchema().getGraphClass().getDefaultVertexClass();
        for (CreateEdge createEdge : createVertex.getCreateEdgeIncidences()) {
            String string = createEdge.get_typeName();
            EdgeClass edgeClass = (EdgeClass)context.getTargetSchema().getAttributedElementClass(string);
            VertexClass vertexClass2 = createEdge.isNormal() ? edgeClass.getFrom().getVertexClass() : edgeClass.getTo().getVertexClass();
            if (!vertexClass2.isSubClassOf(vertexClass)) continue;
            vertexClass = vertexClass2;
        }
        if (vertexClass == context.getTargetSchema().getGraphClass().getDefaultVertexClass()) {
            throw new GReTLException(context, "Couldn't determine typeName for " + createVertex + ".");
        }
        createVertex.set_typeName(vertexClass.getQualifiedName());
        return createVertex.get_typeName();
    }

    private void applyEdgeCreations(PSet<Object> pSet) {
        for (CreateEdge createEdge : this.templateGraph.getCreateEdgeEdges()) {
            String string = createEdge.get_typeName();
            EdgeClass edgeClass = null;
            if (createEdge.is_typeNameIsQuery()) {
                this.ec(this.context.evaluateGReQLQuery(string).toString());
            } else {
                edgeClass = this.ec(string);
            }
            if (edgeClass == null) {
                throw new GReTLException(this.context, "There's no edge class '" + string + "' in the target schema.");
            }
            PSet<Tuple> pSet2 = Empty.set();
            for (Object e : pSet) {
                this.context.setGReQLVariable("$", e);
                Tuple tuple = Tuple.empty();
                Object t = this.context.evaluateGReQLQuery(this.getArch(createEdge.get_archetype()));
                tuple = tuple.plus(t);
                tuple = tuple.plus(this.context.evaluateGReQLQuery(createEdge.getAlpha().get_archetype()));
                tuple = tuple.plus(this.context.evaluateGReQLQuery(createEdge.getOmega().get_archetype()));
                pSet2 = pSet2.plus(tuple);
            }
            logger.finer("Instantiating " + pSet2.size() + " '" + edgeClass.getQualifiedName() + "' edges.");
            this.createdElements.addAll((Collection)new CreateEdges(this.context, edgeClass, pSet2).execute());
        }
    }

    private String getArch(String string) {
        if (string == null) {
            return this.getUniqueArchetype();
        }
        return string;
    }

    private void applyAttributeSetting(PSet<Object> pSet) {
        LinkedList<Iterable<GraphElement<VertexClass, Vertex>>> linkedList = new LinkedList<Iterable<GraphElement<VertexClass, Vertex>>>();
        linkedList.add(this.templateGraph.getCreateVertexVertices());
        linkedList.add(this.templateGraph.getCreateEdgeEdges());
        for (Iterable iterable : linkedList) {
            for (GraphElement graphElement : iterable) {
                PMap<String, String> pMap;
                String string;
                AttributedElementClass<?, ?> attributedElementClass;
                String string2;
                Object object;
                if (graphElement instanceof CreateVertex) {
                    object = (CreateVertex)graphElement;
                    string2 = CreateSubgraph.getVertexClassName(object, this.context);
                    attributedElementClass = this.aec(string2);
                    string = object.get_archetype();
                    pMap = object.get_attributes();
                } else {
                    object = (CreateEdge)graphElement;
                    string2 = object.get_typeName();
                    attributedElementClass = this.aec(string2);
                    string = object.get_archetype();
                    pMap = object.get_attributes();
                }
                if (attributedElementClass == null) {
                    throw new GReTLException(this.context, "There's no attributed element class '" + string2 + "' in the target schema.");
                }
                if (pMap == null) continue;
                for (Map.Entry entry : pMap.entrySet()) {
                    Attribute attribute = attributedElementClass.getAttribute((String)entry.getKey());
                    if (attribute == null) {
                        throw new GReTLException(this.context, "There's no attribute '" + (String)entry.getKey() + "' defined for '" + attributedElementClass.getQualifiedName() + "' in the target schema.");
                    }
                    PMap pMap2 = Empty.orderedMap();
                    for (Object e : pSet) {
                        this.context.setGReQLVariable("$", e);
                        pMap2 = pMap2.plus(this.context.evaluateGReQLQuery(string), this.context.evaluateGReQLQuery((String)entry.getValue()));
                    }
                    new SetAttributes(this.context, attribute, pMap2).execute();
                }
            }
        }
    }
}

