/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CountingTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import java.util.LinkedList;

public abstract class InPlaceTransformation
extends CountingTransformation {
    protected InPlaceTransformation(Context context) {
        super(context);
        this.assertInPlace();
    }

    private void assertInPlace() {
        if (this.context.getSourceGraph() != this.context.getTargetGraph()) {
            throw new GReTLException(this.context, "In-place transformation " + this.getClass().getSimpleName() + " executed in non-in-place context!");
        }
    }

    protected void relinkIncidences(Vertex vertex, Vertex vertex2) {
        if (vertex == vertex2) {
            return;
        }
        LinkedList<InternalEdge> linkedList = new LinkedList<InternalEdge>();
        for (Edge edge : vertex.incidences()) {
            linkedList.add((InternalEdge)edge);
        }
        for (InternalEdge internalEdge : linkedList) {
            internalEdge.setThis(vertex2);
        }
    }
}

