/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.grumlschema;

import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.impl.std.SchemaGraphFactoryImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.lang.ref.WeakReference;

public class GrumlSchema
extends SchemaImpl {
    static WeakReference<GrumlSchema> theInstance = new WeakReference<Object>(null);

    public static synchronized GrumlSchema instance() {
        GrumlSchema grumlSchema = (GrumlSchema)theInstance.get();
        if (grumlSchema != null) {
            return grumlSchema;
        }
        grumlSchema = new GrumlSchema();
        theInstance = new WeakReference<GrumlSchema>(grumlSchema);
        return grumlSchema;
    }

    private GrumlSchema() {
        super("GrumlSchema", "de.uni_koblenz.jgralab.grumlschema");
        NamedElement namedElement = this.createEnumDomain("structure.AggregationKind");
        namedElement.addConst("NONE");
        namedElement.addConst("SHARED");
        namedElement.addConst("COMPOSITE");
        this.createListDomain(this.getDomain("String"));
        namedElement = this.createGraphClass("SchemaGraph");
        VertexClass vertexClass = namedElement.createVertexClass("structure.NamedElement");
        vertexClass.setAbstract(true);
        vertexClass.createAttribute("qualifiedName", this.getDomain("String"), null);
        VertexClass vertexClass2 = namedElement.createVertexClass("structure.Comment");
        vertexClass2.setAbstract(false);
        vertexClass2.createAttribute("text", this.getDomain("String"), null);
        VertexClass vertexClass3 = namedElement.createVertexClass("structure.IncidenceClass");
        vertexClass3.setAbstract(false);
        vertexClass3.createAttribute("aggregation", this.getDomain("structure.AggregationKind"), null);
        vertexClass3.createAttribute("max", this.getDomain("Integer"), null);
        vertexClass3.createAttribute("min", this.getDomain("Integer"), null);
        vertexClass3.createAttribute("roleName", this.getDomain("String"), null);
        vertexClass3.addConstraint(new ConstraintImpl("Each IncidenceClass must either have a ComesFrom or a GoesTo Edge.", "import structure.*; forall ic : V{IncidenceClass} @ count(ic --<>{ComesFrom, GoesTo}) = 1", "import structure.*; from ic : V{IncidenceClass} with count(ic --<>{ComesFrom, GoesTo}) <> 1 reportSet ic end"));
        vertexClass3.addComment("The implementation in jgralab.schema.impl gets an \"edgeclass\" attribute to ensure two-way navigability of ComesFrom/GoesTo associations.");
        VertexClass vertexClass4 = namedElement.createVertexClass("structure.Schema");
        vertexClass4.setAbstract(false);
        vertexClass4.createAttribute("name", this.getDomain("String"), null);
        vertexClass4.createAttribute("packagePrefix", this.getDomain("String"), null);
        VertexClass vertexClass5 = namedElement.createVertexClass("structure.Constraint");
        vertexClass5.setAbstract(false);
        vertexClass5.createAttribute("message", this.getDomain("String"), null);
        vertexClass5.createAttribute("offendingElementsQuery", this.getDomain("String"), null);
        vertexClass5.createAttribute("predicateQuery", this.getDomain("String"), null);
        VertexClass vertexClass6 = namedElement.createVertexClass("structure.Attribute");
        vertexClass6.setAbstract(false);
        vertexClass6.createAttribute("defaultValue", this.getDomain("String"), null);
        vertexClass6.createAttribute("name", this.getDomain("String"), null);
        vertexClass6.addComment("The defaultValue is a string constant in TG syntax, compatible to the Domain of the Attribute.\ndefaultValue may be null (which means no default value is specified).");
        VertexClass vertexClass7 = namedElement.createVertexClass("structure.Package");
        vertexClass7.setAbstract(false);
        vertexClass7.addSuperClass(vertexClass);
        vertexClass7.addConstraint(new ConstraintImpl("A Package must either be default or subpackage, but not both", "import structure.*; forall p: V{Package} @ (inDegree{ContainsDefaultPackage}(p) + inDegree{ContainsSubPackage}(p)) = 1", "import structure.*; from p: V{Package} with (inDegree{ContainsDefaultPackage}(p) + inDegree{ContainsSubPackage}(p)) <> 1 reportSet p end"));
        VertexClass vertexClass8 = namedElement.createVertexClass("structure.AttributedElementClass");
        vertexClass8.setAbstract(true);
        vertexClass8.addSuperClass(vertexClass);
        VertexClass vertexClass9 = namedElement.createVertexClass("domains.Domain");
        vertexClass9.setAbstract(true);
        vertexClass9.addSuperClass(vertexClass);
        VertexClass vertexClass10 = namedElement.createVertexClass("structure.GraphClass");
        vertexClass10.setAbstract(false);
        vertexClass10.addSuperClass(vertexClass8);
        vertexClass10.addConstraint(new ConstraintImpl("There must be exactly one GraphClass.", "count(V{structure.GraphClass}) = 1", "V{structure.GraphClass}"));
        VertexClass vertexClass11 = namedElement.createVertexClass("structure.GraphElementClass");
        vertexClass11.setAbstract(true);
        vertexClass11.addSuperClass(vertexClass8);
        vertexClass11.createAttribute("abstract", this.getDomain("Boolean"), null);
        VertexClass vertexClass12 = namedElement.createVertexClass("domains.CollectionDomain");
        vertexClass12.setAbstract(true);
        vertexClass12.addSuperClass(vertexClass9);
        VertexClass vertexClass13 = namedElement.createVertexClass("domains.BasicDomain");
        vertexClass13.setAbstract(true);
        vertexClass13.addSuperClass(vertexClass9);
        VertexClass vertexClass14 = namedElement.createVertexClass("domains.RecordDomain");
        vertexClass14.setAbstract(false);
        vertexClass14.addSuperClass(vertexClass9);
        VertexClass vertexClass15 = namedElement.createVertexClass("domains.MapDomain");
        vertexClass15.setAbstract(false);
        vertexClass15.addSuperClass(vertexClass9);
        VertexClass vertexClass16 = namedElement.createVertexClass("domains.EnumDomain");
        vertexClass16.setAbstract(false);
        vertexClass16.addSuperClass(vertexClass9);
        vertexClass16.createAttribute("enumConstants", this.getDomain("List<String>"), null);
        VertexClass vertexClass17 = namedElement.createVertexClass("structure.VertexClass");
        vertexClass17.setAbstract(false);
        vertexClass17.addSuperClass(vertexClass11);
        VertexClass vertexClass18 = namedElement.createVertexClass("structure.EdgeClass");
        vertexClass18.setAbstract(false);
        vertexClass18.addSuperClass(vertexClass11);
        vertexClass18.addConstraint(new ConstraintImpl("An EdgeClass may have at most one shared/composite end.", "import structure.*; forall ec : V{EdgeClass}, degree{ComesFrom}(ec) = 1 and degree{GoesTo}(ec) = 1 @ theElement(ec <>--{ComesFrom}).aggregation = \"NONE\" or theElement(ec <>--{GoesTo}).aggregation = \"NONE\"", "import structure.*; from ec : V{EdgeClass} with degree{ComesFrom}(ec) = 1 and degree{GoesTo}(ec) = 1 ? theElement(ec <>--{ComesFrom}).aggregation <> \"NONE\" and theElement(ec <>--{GoesTo}).aggregation <> \"NONE\" : false reportSet ec end"));
        VertexClass vertexClass19 = namedElement.createVertexClass("domains.SetDomain");
        vertexClass19.setAbstract(false);
        vertexClass19.addSuperClass(vertexClass12);
        VertexClass vertexClass20 = namedElement.createVertexClass("domains.ListDomain");
        vertexClass20.setAbstract(false);
        vertexClass20.addSuperClass(vertexClass12);
        VertexClass vertexClass21 = namedElement.createVertexClass("domains.StringDomain");
        vertexClass21.setAbstract(false);
        vertexClass21.addSuperClass(vertexClass13);
        VertexClass vertexClass22 = namedElement.createVertexClass("domains.IntegerDomain");
        vertexClass22.setAbstract(false);
        vertexClass22.addSuperClass(vertexClass13);
        VertexClass vertexClass23 = namedElement.createVertexClass("domains.LongDomain");
        vertexClass23.setAbstract(false);
        vertexClass23.addSuperClass(vertexClass13);
        VertexClass vertexClass24 = namedElement.createVertexClass("domains.DoubleDomain");
        vertexClass24.setAbstract(false);
        vertexClass24.addSuperClass(vertexClass13);
        VertexClass vertexClass25 = namedElement.createVertexClass("domains.BooleanDomain");
        vertexClass25.setAbstract(false);
        vertexClass25.addSuperClass(vertexClass13);
        EdgeClass edgeClass = namedElement.createEdgeClass("structure.Annotates", vertexClass2, 0, Integer.MAX_VALUE, "comments", AggregationKind.NONE, vertexClass, 1, 1, "annotatedelement", AggregationKind.NONE);
        edgeClass.setAbstract(false);
        EdgeClass edgeClass2 = namedElement.createEdgeClass("structure.EndsAt", vertexClass3, 0, Integer.MAX_VALUE, "incidences", AggregationKind.NONE, vertexClass17, 1, 1, "targetclass", AggregationKind.NONE);
        edgeClass2.setAbstract(false);
        EdgeClass edgeClass3 = namedElement.createEdgeClass("structure.HasDomain", vertexClass6, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vertexClass9, 1, 1, "domain", AggregationKind.NONE);
        edgeClass3.setAbstract(false);
        EdgeClass edgeClass4 = namedElement.createEdgeClass("structure.HasConstraint", vertexClass8, 1, 1, "constrainedelement", AggregationKind.NONE, vertexClass5, 0, Integer.MAX_VALUE, "constraints", AggregationKind.COMPOSITE);
        edgeClass4.setAbstract(false);
        EdgeClass edgeClass5 = namedElement.createEdgeClass("structure.HasAttribute", vertexClass8, 1, 1, "element", AggregationKind.NONE, vertexClass6, 0, Integer.MAX_VALUE, "attributes", AggregationKind.COMPOSITE);
        edgeClass5.setAbstract(false);
        EdgeClass edgeClass6 = namedElement.createEdgeClass("structure.SpecializesEdgeClass", vertexClass18, 0, Integer.MAX_VALUE, "subclasses", AggregationKind.NONE, vertexClass18, 0, Integer.MAX_VALUE, "superclasses", AggregationKind.NONE);
        edgeClass6.setAbstract(false);
        EdgeClass edgeClass7 = namedElement.createEdgeClass("structure.ContainsSubPackage", vertexClass7, 0, 1, "", AggregationKind.NONE, vertexClass7, 0, Integer.MAX_VALUE, "subpackages", AggregationKind.COMPOSITE);
        edgeClass7.setAbstract(false);
        EdgeClass edgeClass8 = namedElement.createEdgeClass("structure.ContainsDomain", vertexClass7, 1, 1, "package", AggregationKind.NONE, vertexClass9, 0, Integer.MAX_VALUE, "domains", AggregationKind.COMPOSITE);
        edgeClass8.setAbstract(false);
        EdgeClass edgeClass9 = namedElement.createEdgeClass("structure.ContainsGraphElementClass", vertexClass7, 1, 1, "package", AggregationKind.NONE, vertexClass11, 0, Integer.MAX_VALUE, "graphelementclasses", AggregationKind.COMPOSITE);
        edgeClass9.setAbstract(false);
        EdgeClass edgeClass10 = namedElement.createEdgeClass("structure.ContainsDefaultPackage", vertexClass4, 0, 1, "", AggregationKind.NONE, vertexClass7, 1, 1, "defaultpackage", AggregationKind.COMPOSITE);
        edgeClass10.setAbstract(false);
        EdgeClass edgeClass11 = namedElement.createEdgeClass("structure.DefinesGraphClass", vertexClass4, 1, 1, "", AggregationKind.NONE, vertexClass10, 1, 1, "graphclass", AggregationKind.COMPOSITE);
        edgeClass11.setAbstract(false);
        EdgeClass edgeClass12 = namedElement.createEdgeClass("structure.SpecializesVertexClass", vertexClass17, 0, Integer.MAX_VALUE, "subclasses", AggregationKind.NONE, vertexClass17, 0, Integer.MAX_VALUE, "superclasses", AggregationKind.NONE);
        edgeClass12.setAbstract(false);
        EdgeClass edgeClass13 = namedElement.createEdgeClass("structure.ComesFrom", vertexClass18, 0, 1, "", AggregationKind.NONE, vertexClass3, 1, 1, "from", AggregationKind.COMPOSITE);
        edgeClass13.setAbstract(false);
        EdgeClass edgeClass14 = namedElement.createEdgeClass("structure.GoesTo", vertexClass18, 0, 1, "", AggregationKind.NONE, vertexClass3, 1, 1, "to", AggregationKind.COMPOSITE);
        edgeClass14.setAbstract(false);
        EdgeClass edgeClass15 = namedElement.createEdgeClass("domains.HasBaseDomain", vertexClass12, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vertexClass9, 1, 1, "basedomain", AggregationKind.NONE);
        edgeClass15.setAbstract(false);
        EdgeClass edgeClass16 = namedElement.createEdgeClass("domains.HasValueDomain", vertexClass15, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vertexClass9, 1, 1, "valuedomain", AggregationKind.NONE);
        edgeClass16.setAbstract(false);
        EdgeClass edgeClass17 = namedElement.createEdgeClass("domains.HasKeyDomain", vertexClass15, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vertexClass9, 1, 1, "keydomain", AggregationKind.NONE);
        edgeClass17.setAbstract(false);
        EdgeClass edgeClass18 = namedElement.createEdgeClass("domains.HasRecordDomainComponent", vertexClass14, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vertexClass9, 1, Integer.MAX_VALUE, "componentdomains", AggregationKind.SHARED);
        edgeClass18.setAbstract(false);
        edgeClass18.createAttribute("name", this.getDomain("String"), null);
        this.finish();
    }

    @Override
    public GraphFactory createDefaultGraphFactory(ImplementationType implementationType) {
        switch (implementationType) {
            case GENERIC: {
                return new GenericGraphFactoryImpl(this);
            }
            case STANDARD: {
                return new SchemaGraphFactoryImpl();
            }
        }
        throw new UnsupportedOperationException("No " + (Object)((Object)implementationType) + " support compiled.");
    }

    public SchemaGraph createSchemaGraph(ImplementationType implementationType) {
        return this.createSchemaGraph(implementationType, null, 100, 100);
    }

    public SchemaGraph createSchemaGraph(ImplementationType implementationType, String string, int n, int n2) {
        GraphFactory graphFactory = this.createDefaultGraphFactory(implementationType);
        return (SchemaGraph)graphFactory.createGraph(this.getGraphClass(), string, n, n2);
    }

    public SchemaGraph createSchemaGraph(GraphFactory graphFactory) {
        return (SchemaGraph)graphFactory.createGraph(this.getGraphClass(), null, 100, 100);
    }

    public SchemaGraph createSchemaGraph(GraphFactory graphFactory, String string, int n, int n2) {
        return (SchemaGraph)graphFactory.createGraph(this.getGraphClass(), string, n, n2);
    }

    public SchemaGraph loadSchemaGraph(String string) throws GraphIOException {
        GraphFactory graphFactory = this.createDefaultGraphFactory(ImplementationType.STANDARD);
        return this.loadSchemaGraph(string, graphFactory, null);
    }

    public SchemaGraph loadSchemaGraph(String string, ProgressFunction progressFunction) throws GraphIOException {
        GraphFactory graphFactory = this.createDefaultGraphFactory(ImplementationType.STANDARD);
        return this.loadSchemaGraph(string, graphFactory, progressFunction);
    }

    public SchemaGraph loadSchemaGraph(String string, ImplementationType implementationType) throws GraphIOException {
        GraphFactory graphFactory = this.createDefaultGraphFactory(implementationType);
        return this.loadSchemaGraph(string, graphFactory, null);
    }

    public SchemaGraph loadSchemaGraph(String string, ImplementationType implementationType, ProgressFunction progressFunction) throws GraphIOException {
        GraphFactory graphFactory = this.createDefaultGraphFactory(implementationType);
        return this.loadSchemaGraph(string, graphFactory, progressFunction);
    }

    public SchemaGraph loadSchemaGraph(String string, GraphFactory graphFactory) throws GraphIOException {
        return (SchemaGraph)GraphIO.loadGraphFromFile(string, graphFactory, null);
    }

    public SchemaGraph loadSchemaGraph(String string, GraphFactory graphFactory, ProgressFunction progressFunction) throws GraphIOException {
        return (SchemaGraph)GraphIO.loadGraphFromFile(string, graphFactory, progressFunction);
    }

    @Override
    public boolean reopen() {
        throw new UnsupportedOperationException("Cannot reopen a compiled Schema.");
    }
}

