/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.impl.IncidenceImpl;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;

public abstract class EdgeBaseImpl
extends IncidenceImpl
implements Edge,
InternalEdge {
    protected final ReversedEdgeBaseImpl reversedEdge;

    protected EdgeBaseImpl(int n, Graph graph, Vertex vertex, Vertex vertex2) {
        super(graph);
        this.setId(n);
        this.reversedEdge = this.createReversedEdge();
    }

    @Override
    public final int compareTo(AttributedElement<EdgeClass, Edge> attributedElement) {
        assert (attributedElement != null);
        assert (attributedElement instanceof Edge);
        if (this == attributedElement) {
            return 0;
        }
        Edge edge = (Edge)attributedElement;
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        if (edge == this.getReversedEdge()) {
            return -1;
        }
        int n = Math.abs(this.getId()) - Math.abs(edge.getId());
        if (n != 0) {
            return n;
        }
        return this.getGraph().compareTo(edge.getGraph());
    }

    @Override
    public final void delete() {
        assert (this.isValid());
        this.graph.deleteEdge(this);
    }

    @Override
    public Vertex getAlpha() {
        assert (this.isValid());
        return this.getIncidentVertex();
    }

    @Override
    public final Edge getNextEdge() {
        InternalEdge internalEdge;
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && internalEdge != null && !traversalContext.containsEdge(internalEdge)) {
            for (internalEdge = this.getNextEdgeInESeq(); internalEdge != null && !traversalContext.containsEdge(internalEdge); internalEdge = internalEdge.getNextEdgeInESeq()) {
            }
        }
        return internalEdge;
    }

    @Override
    public final Edge getPrevEdge() {
        InternalEdge internalEdge;
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && internalEdge != null && !traversalContext.containsEdge(internalEdge)) {
            for (internalEdge = this.getPrevEdgeInESeq(); internalEdge != null && !traversalContext.containsEdge(internalEdge); internalEdge = internalEdge.getPrevEdgeInESeq()) {
            }
        }
        return internalEdge;
    }

    @Override
    public final Edge getNextEdge(EdgeClass edgeClass) {
        assert (edgeClass != null);
        assert (this.isValid());
        for (Edge edge = this.getNextEdge(); edge != null; edge = edge.getNextEdge()) {
            if (!edge.isInstanceOf(edgeClass)) continue;
            return edge;
        }
        return null;
    }

    @Override
    public final Edge getNormalEdge() {
        return this;
    }

    @Override
    public Vertex getOmega() {
        assert (this.isValid());
        return this.reversedEdge.getIncidentVertex();
    }

    @Override
    public final Edge getReversedEdge() {
        return this.reversedEdge;
    }

    @Override
    public final Vertex getThat() {
        assert (this.isValid());
        return this.getOmega();
    }

    @Override
    public final String getThatRole() {
        assert (this.isValid());
        return this.getAttributedElementClass().getTo().getRolename();
    }

    @Override
    public final Vertex getThis() {
        assert (this.isValid());
        return this.getAlpha();
    }

    @Override
    public final String getThisRole() {
        assert (this.isValid());
        return this.getAttributedElementClass().getFrom().getRolename();
    }

    @Override
    public final boolean isAfterEdge(Edge edge) {
        InternalEdge internalEdge;
        assert (edge != null);
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        if ((edge = edge.getNormalEdge()) == this) {
            return false;
        }
        for (internalEdge = this.getPrevEdgeInESeq(); internalEdge != null && internalEdge != edge; internalEdge = internalEdge.getPrevEdgeInESeq()) {
        }
        return internalEdge != null;
    }

    @Override
    public final boolean isBeforeEdge(Edge edge) {
        InternalEdge internalEdge;
        assert (edge != null);
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        if ((edge = edge.getNormalEdge()) == this) {
            return false;
        }
        for (internalEdge = this.getNextEdgeInESeq(); internalEdge != null && internalEdge != edge; internalEdge = internalEdge.getNextEdgeInESeq()) {
        }
        return internalEdge != null;
    }

    @Override
    public final boolean isNormal() {
        return true;
    }

    @Override
    public final void putAfterEdge(Edge edge) {
        assert (edge != null);
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        assert (edge != this);
        assert (edge != this.reversedEdge);
        this.graph.putEdgeAfterInGraph((InternalEdge)edge.getNormalEdge(), this);
    }

    @Override
    public final void putBeforeEdge(Edge edge) {
        assert (edge != null);
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        assert (edge != this);
        assert (edge != this.reversedEdge);
        this.graph.putEdgeBeforeInGraph((InternalEdge)edge.getNormalEdge(), this);
    }

    @Override
    public final void setAlpha(Vertex vertex) {
        InternalVertex internalVertex = (InternalVertex)vertex;
        assert (this.isValid());
        assert (internalVertex != null);
        assert (internalVertex.isValid());
        assert (this.getGraph() == internalVertex.getGraph());
        InternalVertex internalVertex2 = this.getIncidentVertex();
        this.graph.fireBeforeChangeAlpha(this, internalVertex2, internalVertex);
        if (internalVertex == internalVertex2) {
            return;
        }
        if (!internalVertex.getAttributedElementClass().isValidFromFor((EdgeClass)this.getAttributedElementClass())) {
            throw new GraphException("Edges of class " + this.getAttributedElementClass().getUniqueName() + " may not start at vertices of class " + internalVertex.getAttributedElementClass().getUniqueName());
        }
        internalVertex2.removeIncidenceFromISeq(this);
        internalVertex2.incidenceListModified();
        InternalVertex internalVertex3 = internalVertex;
        internalVertex3.appendIncidenceToISeq(this);
        internalVertex3.incidenceListModified();
        this.setIncidentVertex(internalVertex3);
        this.graph.fireAfterChangeAlpha(this, internalVertex2, internalVertex);
    }

    @Override
    public final void setOmega(Vertex vertex) {
        InternalVertex internalVertex = (InternalVertex)vertex;
        assert (this.isValid());
        assert (internalVertex != null);
        assert (internalVertex.isValid());
        assert (this.getGraph() == internalVertex.getGraph());
        InternalVertex internalVertex2 = this.reversedEdge.getIncidentVertex();
        this.graph.fireBeforeChangeOmega(this, internalVertex2, internalVertex);
        if (internalVertex == internalVertex2) {
            return;
        }
        if (!internalVertex.getAttributedElementClass().isValidToFor((EdgeClass)this.getAttributedElementClass())) {
            throw new GraphException("Edges of class " + this.getAttributedElementClass().getUniqueName() + " may not end at at vertices of class " + internalVertex.getAttributedElementClass().getUniqueName());
        }
        internalVertex2.removeIncidenceFromISeq(this.reversedEdge);
        internalVertex2.incidenceListModified();
        InternalVertex internalVertex3 = internalVertex;
        internalVertex3.appendIncidenceToISeq(this.reversedEdge);
        internalVertex3.incidenceListModified();
        this.reversedEdge.setIncidentVertex(internalVertex3);
        this.graph.fireAfterChangeOmega(this, internalVertex2, internalVertex);
    }

    @Override
    public final void setThat(Vertex vertex) {
        assert (this.isValid());
        assert (vertex != null);
        assert (vertex.isValid());
        assert (this.getGraph() == vertex.getGraph());
        this.setOmega(vertex);
    }

    @Override
    public final void setThis(Vertex vertex) {
        assert (this.isValid());
        assert (vertex != null);
        assert (vertex.isValid());
        assert (this.getGraph() == vertex.getGraph());
        this.setAlpha(vertex);
    }

    public String toString() {
        return "+e" + this.id + ": " + this.getAttributedElementClass().getQualifiedName();
    }

    @Override
    public final boolean isValid() {
        return this.graph.eSeqContainsEdge(this);
    }

    @Override
    public final AggregationKind getThisAggregationKind() {
        assert (this.isValid());
        return this.getAlphaAggregationKind();
    }

    @Override
    public final AggregationKind getThatAggregationKind() {
        assert (this.isValid());
        return this.getOmegaAggregationKind();
    }

    protected abstract ReversedEdgeBaseImpl createReversedEdge();
}

