/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.impl.GraphElementImpl;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.VertexBaseImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;

public abstract class IncidenceImpl
extends GraphElementImpl<EdgeClass, Edge>
implements Edge,
InternalEdge {
    protected IncidenceImpl(Graph graph) {
        super(graph);
    }

    @Override
    public InternalEdge getNextIncidence() {
        InternalEdge internalEdge;
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && internalEdge != null && !traversalContext.containsEdge(internalEdge)) {
            for (internalEdge = this.getNextIncidenceInISeq(); internalEdge != null && !traversalContext.containsEdge(internalEdge); internalEdge = internalEdge.getNextIncidenceInISeq()) {
            }
        }
        return internalEdge;
    }

    @Override
    public InternalEdge getPrevIncidence() {
        InternalEdge internalEdge;
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && internalEdge != null && !traversalContext.containsEdge(internalEdge)) {
            for (internalEdge = this.getPrevIncidenceInISeq(); internalEdge != null && !traversalContext.containsEdge(internalEdge); internalEdge = internalEdge.getPrevIncidenceInISeq()) {
            }
        }
        return internalEdge;
    }

    @Override
    public Edge getNextIncidence(EdgeDirection edgeDirection) {
        assert (this.isValid());
        switch (edgeDirection) {
            case IN: {
                Edge edge;
                for (edge = this.getNextIncidence(); edge != null && edge.isNormal(); edge = edge.getNextIncidence()) {
                }
                return edge;
            }
            case OUT: {
                Edge edge;
                while (edge != null && !edge.isNormal()) {
                    edge = edge.getNextIncidence();
                }
                return edge;
            }
            case INOUT: {
                Edge edge;
                return edge;
            }
        }
        throw new RuntimeException("FIXME!");
    }

    @Override
    public Edge getNextIncidence(boolean bl, AggregationKind ... aggregationKindArray) {
        Edge edge;
        assert (this.isValid());
        if (aggregationKindArray.length == 0) {
            return edge;
        }
        for (edge = this.getNextIncidence(); edge != null; edge = edge.getNextIncidence()) {
            for (AggregationKind aggregationKind : aggregationKindArray) {
                if ((bl ? edge.getThisAggregationKind() : edge.getThatAggregationKind()) != aggregationKind) continue;
                return edge;
            }
        }
        return null;
    }

    @Override
    public Edge getNextIncidence(EdgeClass edgeClass) {
        assert (edgeClass != null);
        assert (this.isValid());
        return this.getNextIncidence(edgeClass, EdgeDirection.INOUT, false);
    }

    @Override
    public Edge getNextIncidence(EdgeClass edgeClass, boolean bl) {
        assert (edgeClass != null);
        assert (this.isValid());
        return this.getNextIncidence(edgeClass, EdgeDirection.INOUT, bl);
    }

    @Override
    public Edge getNextIncidence(EdgeClass edgeClass, EdgeDirection edgeDirection) {
        assert (edgeClass != null);
        assert (this.isValid());
        return this.getNextIncidence(edgeClass, edgeDirection, false);
    }

    @Override
    public Edge getNextIncidence(EdgeClass edgeClass, EdgeDirection edgeDirection, boolean bl) {
        assert (edgeClass != null);
        assert (this.isValid());
        for (Edge edge = this.getNextIncidence(edgeDirection); edge != null; edge = edge.getNextIncidence(edgeDirection)) {
            if (!(bl ? edgeClass == edge.getAttributedElementClass() : edge.isInstanceOf(edgeClass))) continue;
            return edge;
        }
        return null;
    }

    @Override
    public boolean isBeforeIncidence(Edge edge) {
        IncidenceImpl incidenceImpl;
        assert (edge != null);
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        assert (this.getThis() == edge.getThis());
        if (edge == this) {
            return false;
        }
        for (incidenceImpl = (IncidenceImpl)this.getNextIncidenceInISeq(); incidenceImpl != null && incidenceImpl != edge; incidenceImpl = (IncidenceImpl)incidenceImpl.getNextIncidenceInISeq()) {
        }
        return incidenceImpl != null;
    }

    @Override
    public boolean isAfterIncidence(Edge edge) {
        IncidenceImpl incidenceImpl;
        assert (edge != null);
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        assert (this.getThis() == edge.getThis());
        if (edge == this) {
            return false;
        }
        for (incidenceImpl = (IncidenceImpl)this.getPrevIncidenceInISeq(); incidenceImpl != null && incidenceImpl != edge; incidenceImpl = (IncidenceImpl)incidenceImpl.getPrevIncidenceInISeq()) {
        }
        return incidenceImpl != null;
    }

    @Override
    public void putIncidenceBefore(Edge edge) {
        assert (edge != null);
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        assert (this.getThis() == edge.getThis());
        VertexBaseImpl vertexBaseImpl = (VertexBaseImpl)this.getThis();
        assert (vertexBaseImpl.isValid());
        assert (edge != this);
        if (this != edge) {
            vertexBaseImpl.putIncidenceBefore((IncidenceImpl)edge, this);
        }
    }

    @Override
    public void putIncidenceAfter(Edge edge) {
        assert (edge != null);
        assert (this.isValid());
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        assert (this.getThis() == edge.getThis()) : "this-vertices don't match: " + this.getThis() + " != " + edge.getThis();
        VertexBaseImpl vertexBaseImpl = (VertexBaseImpl)this.getThis();
        assert (vertexBaseImpl.isValid());
        assert (edge != this);
        if (this != edge) {
            vertexBaseImpl.putIncidenceAfter((IncidenceImpl)edge, this);
        }
    }
}

