/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.generic;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.impl.GraphFactoryImpl;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.impl.generic.GenericEdgeImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericVertexImpl;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;

public class GenericGraphFactoryImpl
extends GraphFactoryImpl {
    public GenericGraphFactoryImpl(Schema schema) {
        super(schema, ImplementationType.GENERIC);
    }

    @Override
    public void setGraphImplementationClass(GraphClass graphClass, Class<? extends Graph> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVertexImplementationClass(VertexClass vertexClass, Class<? extends Vertex> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEdgeImplementationClass(EdgeClass edgeClass, Class<? extends Edge> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <G extends Graph> G createGraph(GraphClass graphClass, String string, int n, int n2) {
        if (this.schema != graphClass.getSchema()) {
            throw new GraphException(graphClass + " is not in schema " + this.schema);
        }
        GenericGraphImpl genericGraphImpl = new GenericGraphImpl(graphClass, string, n, n2);
        genericGraphImpl.setGraphFactory(this);
        return (G)genericGraphImpl;
    }

    @Override
    public <V extends Vertex> V createVertex(VertexClass vertexClass, int n, Graph graph) {
        if (this.schema != vertexClass.getSchema()) {
            throw new GraphException(vertexClass + " is not in schema " + this.schema);
        }
        InternalGraph internalGraph = (InternalGraph)graph;
        internalGraph.fireBeforeCreateVertex(vertexClass);
        GenericVertexImpl genericVertexImpl = new GenericVertexImpl(vertexClass, n, graph);
        internalGraph.fireAfterCreateVertex(genericVertexImpl);
        return (V)genericVertexImpl;
    }

    @Override
    public <E extends Edge> E createEdge(EdgeClass edgeClass, int n, Graph graph, Vertex vertex, Vertex vertex2) {
        if (this.schema != edgeClass.getSchema()) {
            throw new GraphException(edgeClass + " is not in schema " + this.schema);
        }
        InternalGraph internalGraph = (InternalGraph)graph;
        internalGraph.fireBeforeCreateEdge(edgeClass, vertex, vertex2);
        GenericEdgeImpl genericEdgeImpl = new GenericEdgeImpl(edgeClass, n, graph, vertex, vertex2);
        internalGraph.fireAfterCreateEdge(genericEdgeImpl);
        return (E)genericEdgeImpl;
    }
}

