/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.std;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.TemporaryEdge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.exception.TemporaryGraphElementException;
import de.uni_koblenz.jgralab.impl.GraphBaseImpl;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import de.uni_koblenz.jgralab.impl.std.EdgeImpl;
import de.uni_koblenz.jgralab.impl.std.TemporaryReversedEdgeImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TemporaryEdgeImpl
extends EdgeImpl
implements TemporaryEdge {
    private HashMap<String, Object> attributes;
    private EdgeClass preliminaryType;

    protected TemporaryEdgeImpl(int n, Graph graph, Vertex vertex, Vertex vertex2) {
        super(n, graph, vertex, vertex2);
        this.attributes = new HashMap();
        ((GraphBaseImpl)graph).addEdge(this, vertex, vertex2);
    }

    protected TemporaryEdgeImpl(int n, Graph graph, EdgeClass edgeClass, Vertex vertex, Vertex vertex2) {
        super(n, graph, vertex, vertex2);
        this.preliminaryType = edgeClass;
        this.attributes = new HashMap();
        ((GraphBaseImpl)graph).addEdge(this, vertex, vertex2);
    }

    @Override
    public EdgeClass getAttributedElementClass() {
        return this.graph.getGraphClass().getTemporaryEdgeClass();
    }

    @Override
    public <T> T getAttribute(String string) throws NoSuchAttributeException {
        return (T)this.attributes.get(string);
    }

    @Override
    public <T> void setAttribute(String string, T t) throws NoSuchAttributeException {
        this.attributes.put(string, t);
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
    }

    @Override
    public boolean isInstanceOf(EdgeClass edgeClass) {
        return edgeClass.equals(this.graph.getGraphClass().getTemporaryEdgeClass());
    }

    @Override
    public Edge bless() {
        if (this.preliminaryType == null) {
            throw new TemporaryGraphElementException("Transformation of temporary edge " + this + " failed. " + "There is no preliminary EdgeClass set.");
        }
        return this.bless(this.preliminaryType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Edge bless(EdgeClass edgeClass) {
        void var12_15;
        this.validateConversion(edgeClass);
        GraphBaseImpl graphBaseImpl = this.graph;
        int n = this.id;
        InternalEdge internalEdge = this.getPrevEdgeInESeq();
        InternalEdge internalEdge2 = this.getNextEdgeInESeq();
        InternalEdge internalEdge3 = this.getPrevIncidenceInISeq();
        InternalEdge internalEdge4 = this.getNextIncidenceInISeq();
        InternalEdge internalEdge5 = ((InternalEdge)this.getReversedEdge()).getPrevIncidenceInISeq();
        InternalEdge internalEdge6 = ((InternalEdge)this.getReversedEdge()).getNextIncidenceInISeq();
        InternalEdge internalEdge7 = (InternalEdge)graphBaseImpl.createEdge(edgeClass, this.getAlpha(), this.getOmega());
        for (String object2 : this.attributes.keySet()) {
            if (!internalEdge7.getAttributedElementClass().containsAttribute(object2)) continue;
            internalEdge7.setAttribute(object2, this.attributes.get(object2));
        }
        Object object3 = internalEdge7.getPrevIncidenceInISeq();
        InternalEdge internalEdge8 = ((InternalEdge)internalEdge7.getReversedEdge()).getPrevIncidenceInISeq();
        this.delete();
        if (internalEdge2 != null) {
            internalEdge7.putBeforeEdge(internalEdge2);
        }
        if (internalEdge != null) {
            internalEdge7.putAfterEdge(internalEdge);
        }
        if (object3 == this) {
            object3 = internalEdge7;
        }
        this.correctISeq(internalEdge3, internalEdge4, internalEdge7, (InternalEdge)object3);
        if (internalEdge5 == this) {
            internalEdge5 = internalEdge7;
        }
        if (internalEdge6 == this) {
            internalEdge6 = internalEdge7;
        }
        if (internalEdge8 == this.getReversedEdge()) {
            InternalEdge internalEdge9 = (InternalEdge)internalEdge7.getReversedEdge();
        }
        this.correctISeq(internalEdge5, internalEdge6, (InternalEdge)internalEdge7.getReversedEdge(), (InternalEdge)var12_15);
        int n2 = internalEdge7.getId();
        internalEdge7.setId(n);
        graphBaseImpl.allocateEdgeIndex(n);
        graphBaseImpl.freeEdgeIndex(n2);
        InternalEdge[] internalEdgeArray = graphBaseImpl.getEdge();
        internalEdgeArray[n] = internalEdge7;
        internalEdgeArray[n2] = null;
        InternalEdge[] internalEdgeArray2 = graphBaseImpl.getRevEdge();
        internalEdgeArray2[n] = (InternalEdge)internalEdge7.getReversedEdge();
        internalEdgeArray2[n2] = null;
        return internalEdge7;
    }

    private void validateConversion(EdgeClass edgeClass) {
        if (!this.isValid()) {
            throw new TemporaryGraphElementException("This temporary edge isn't valid anymore! " + this);
        }
        if (!this.getAlpha().getAttributedElementClass().isValidFromFor(edgeClass)) {
            throw new TemporaryGraphElementException("Transformation of temporary edge " + this + " failed. " + this.getAlpha() + " is not a valid source for " + edgeClass);
        }
        if (!this.getOmega().getAttributedElementClass().isValidToFor(edgeClass)) {
            throw new TemporaryGraphElementException("Transformation of temporary edge " + this + " failed. " + this.getOmega() + " is not a valid target for " + edgeClass);
        }
        for (String string : this.attributes.keySet()) {
            if (!edgeClass.containsAttribute(string) || edgeClass.getAttribute(string).getDomain().isConformValue(this.attributes.get(string))) continue;
            throw new TemporaryGraphElementException("Transformation of temporary vertex " + this + " failed. " + edgeClass + " has an attribute " + string + " but " + this.attributes.get(string) + " is not a valid value.");
        }
    }

    private void correctISeq(InternalEdge internalEdge, InternalEdge internalEdge2, InternalEdge internalEdge3, InternalEdge internalEdge4) {
        if (internalEdge2 != null) {
            internalEdge2.setPrevIncidenceInternal(internalEdge3);
            internalEdge3.setNextIncidenceInternal(internalEdge2);
            internalEdge3.setPrevIncidenceInternal(internalEdge);
        }
        internalEdge4.setNextIncidenceInternal(null);
        if (internalEdge != null) {
            internalEdge.setNextIncidenceInternal(internalEdge3);
        } else {
            ((InternalVertex)internalEdge3.getThis()).setFirstIncidence(internalEdge3);
        }
        ((InternalVertex)internalEdge3.getThis()).setLastIncidence(internalEdge4);
    }

    @Override
    public void deleteAttribute(String string) {
        ((TemporaryEdge)this.getNormalEdge()).deleteAttribute(string);
    }

    @Override
    protected ReversedEdgeBaseImpl createReversedEdge() {
        return new TemporaryReversedEdgeImpl(this, this.graph);
    }

    @Override
    public AggregationKind getAlphaAggregationKind() {
        return this.getAttributedElementClass().getFrom().getAggregationKind();
    }

    @Override
    public AggregationKind getOmegaAggregationKind() {
        return this.getAttributedElementClass().getTo().getAggregationKind();
    }

    @Override
    public Class<? extends Edge> getSchemaClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readAttributeValueFromString(String string, String string2) throws GraphIOException, NoSuchAttributeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String writeAttributeValueToString(String string) throws IOException, GraphIOException, NoSuchAttributeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeAttributeValues(GraphIO graphIO) throws IOException, GraphIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readAttributeValues(GraphIO graphIO) throws GraphIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AggregationKind getAggregationKind() {
        AggregationKind aggregationKind = this.getAttributedElementClass().getFrom().getAggregationKind();
        AggregationKind aggregationKind2 = this.getAttributedElementClass().getTo().getAggregationKind();
        return aggregationKind != AggregationKind.NONE ? aggregationKind : (aggregationKind2 != AggregationKind.NONE ? aggregationKind2 : AggregationKind.NONE);
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public EdgeClass getPreliminaryType() {
        return this.preliminaryType;
    }

    @Override
    public void setPreliminaryType(EdgeClass edgeClass) {
        this.preliminaryType = edgeClass;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("+te");
        stringBuilder.append(this.id);
        stringBuilder.append(": ");
        if (this.preliminaryType != null) {
            stringBuilder.append(this.preliminaryType.getQualifiedName());
        } else {
            stringBuilder.append("-MissingPreliminaryType-");
        }
        stringBuilder.append(" {");
        boolean bl = true;
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" -> ");
            stringBuilder.append(entry.getValue());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

