/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;

public class EnumCodeGenerator
extends CodeGenerator {
    private EnumDomain enumDomain;

    public EnumCodeGenerator(EnumDomain enumDomain, String string) {
        super(string, enumDomain.getPackageName(), new CodeGeneratorConfiguration());
        this.rootBlock.setVariable("simpleClassName", enumDomain.getSimpleName());
        this.rootBlock.setVariable("isClassOnly", "true");
        this.enumDomain = enumDomain;
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = new CodeList();
        if (this.currentCycle.isClassOnly()) {
            CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
            String string = "";
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : this.enumDomain.getConsts()) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                string = ", ";
            }
            stringBuilder.append(";");
            codeSnippet.add(stringBuilder.toString());
            CodeSnippet codeSnippet2 = new CodeSnippet(true, new String[0]);
            codeSnippet2.add("public static #simpleClassName# valueOfPermitNull(String val) {", "\tif (val == null) {", "\t\treturn null;", "\t}", "\treturn valueOf(val);", "}");
            codeList.add(codeSnippet);
            codeList.add(codeSnippet2);
        }
        return codeList;
    }

    @Override
    protected CodeBlock createHeader() {
        if (this.currentCycle.isClassOnly()) {
            return new CodeSnippet(true, "public enum #simpleClassName# {");
        }
        return new CodeSnippet();
    }
}

