/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.codegenerator.RolenameCodeGenerator;
import java.util.HashSet;
import java.util.TreeSet;

public class VertexCodeGenerator
extends AttributedElementCodeGenerator<VertexClass, Vertex> {
    private RolenameCodeGenerator rolenameGenerator;

    public VertexCodeGenerator(VertexClass vertexClass, String string, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        super(vertexClass, string, codeGeneratorConfiguration);
        this.rootBlock.setVariable("graphElementClass", "Vertex");
        this.rootBlock.setVariable("schemaElementClass", "VertexClass");
        this.rolenameGenerator = new RolenameCodeGenerator((VertexClass)this.aec);
        for (VertexClass vertexClass2 : vertexClass.getDirectSuperClasses().plus(vertexClass.getGraphClass().getDefaultVertexClass())) {
            this.interfaces.add(vertexClass2.getQualifiedName());
        }
    }

    @Override
    protected String getSchemaTypeName() {
        return "VertexClass";
    }

    @Override
    protected CodeBlock createHeader() {
        return super.createHeader();
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = (CodeList)super.createBody();
        if (this.currentCycle.isStdImpl()) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplStdPackage#.#baseClassName#");
            }
            this.rootBlock.setVariable("baseClassName", "VertexImpl");
        }
        if (this.config.hasTypeSpecificMethodsSupport() && !this.currentCycle.isClassOnly()) {
            codeList.add(this.createNextVertexMethods());
            codeList.add(this.createFirstIncidenceMethods());
            codeList.add(this.rolenameGenerator.createRolenameMethods(this.currentCycle.isStdImpl()));
            codeList.add(this.createIncidenceIteratorMethods());
        }
        return codeList;
    }

    private CodeBlock createFirstIncidenceMethods() {
        CodeList codeList = new CodeList();
        VertexClass vertexClass = (VertexClass)this.aec;
        HashSet<EdgeClass> hashSet = new HashSet<EdgeClass>();
        if (this.currentCycle.isStdImpl()) {
            hashSet.addAll(vertexClass.getConnectedEdgeClasses());
        }
        if (this.currentCycle.isAbstract()) {
            hashSet.addAll(vertexClass.getOwnConnectedEdgeClasses());
            if (vertexClass.getAllSuperClasses().size() == 1) {
                for (EdgeClass edgeClass : vertexClass.getConnectedEdgeClasses()) {
                    VertexClass vertexClass2 = vertexClass.getGraphClass().getDefaultVertexClass();
                    if (edgeClass.getTo().getVertexClass() != vertexClass2 && edgeClass.getFrom().getVertexClass() != vertexClass2) continue;
                    hashSet.add(edgeClass);
                }
            }
        }
        for (EdgeClass edgeClass : hashSet) {
            this.addImports("#jgPackage#.EdgeDirection");
            if (!this.config.hasTypeSpecificMethodsSupport()) continue;
            codeList.addNoIndent(this.createFirstIncidenceMethod(edgeClass, false));
            codeList.addNoIndent(this.createFirstIncidenceMethod(edgeClass, true));
        }
        return codeList;
    }

    private CodeBlock createFirstIncidenceMethod(EdgeClass edgeClass, boolean bl) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("ecQualifiedName", this.absoluteName(edgeClass));
        codeSnippet.setVariable("ecCamelName", VertexCodeGenerator.camelCase(edgeClass.getUniqueName()));
        codeSnippet.setVariable("formalParams", bl ? "EdgeDirection orientation" : "");
        codeSnippet.setVariable("actualParams", bl ? ", orientation" : "");
        if (this.currentCycle.isAbstract()) {
            codeSnippet.add("/**", " * @return the first edge of class #ecCamelName# at this vertex");
            if (bl) {
                codeSnippet.add(" * @param orientation the orientation of the edge");
            }
            codeSnippet.add(" */", "public #ecQualifiedName# getFirst#ecCamelName#Incidence(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.add("@Override", "public #ecQualifiedName# getFirst#ecCamelName#Incidence(#formalParams#) {", "\treturn (#ecQualifiedName#)getFirstIncidence(#ecQualifiedName#.EC#actualParams#);", "}");
        }
        return codeSnippet;
    }

    private CodeBlock createNextVertexMethods() {
        CodeList codeList = new CodeList();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(((VertexClass)this.aec).getAllSuperClasses());
        treeSet.add(this.aec);
        if (this.config.hasTypeSpecificMethodsSupport()) {
            for (GraphElementClass graphElementClass : treeSet) {
                VertexClass vertexClass = (VertexClass)graphElementClass;
                codeList.addNoIndent(this.createNextVertexMethod(vertexClass));
            }
        }
        return codeList;
    }

    private CodeBlock createNextVertexMethod(VertexClass vertexClass) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("vcQualifiedName", this.absoluteName(vertexClass));
        codeSnippet.setVariable("vcCamelName", VertexCodeGenerator.camelCase(vertexClass.getUniqueName()));
        codeSnippet.setVariable("formalParams", "");
        codeSnippet.setVariable("actualParams", "");
        if (this.currentCycle.isAbstract()) {
            codeSnippet.add("/**", " * @return the next #vcQualifiedName# vertex in the global vertex sequence");
            codeSnippet.add(" */", "public #vcQualifiedName# getNext#vcCamelName#(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.add("@Override", "public #vcQualifiedName# getNext#vcCamelName#(#formalParams#) {", "\treturn (#vcQualifiedName#)getNextVertex(#vcQualifiedName#.VC#actualParams#);", "}");
        }
        return codeSnippet;
    }

    private CodeBlock createIncidenceIteratorMethods() {
        Object object;
        VertexClass vertexClass = (VertexClass)this.aec;
        CodeList codeList = new CodeList();
        HashSet<EdgeClass> hashSet = new HashSet<EdgeClass>();
        if (this.currentCycle.isStdImpl()) {
            hashSet.addAll(vertexClass.getConnectedEdgeClasses());
        }
        if (this.currentCycle.isAbstract()) {
            hashSet.addAll(vertexClass.getOwnConnectedEdgeClasses());
            if (vertexClass.getAllSuperClasses().size() == 1) {
                for (EdgeClass edgeClass : vertexClass.getConnectedEdgeClasses()) {
                    object = vertexClass.getGraphClass().getDefaultVertexClass();
                    if (edgeClass.getTo().getVertexClass() != object && edgeClass.getFrom().getVertexClass() != object) continue;
                    hashSet.add(edgeClass);
                }
            }
        }
        for (EdgeClass edgeClass : hashSet) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplPackage#.IncidenceIterable");
            }
            object = new CodeSnippet(true, new String[0]);
            codeList.addNoIndent((CodeBlock)object);
            String string = this.schemaRootPackageName + "." + edgeClass.getQualifiedName();
            ((CodeBlock)object).setVariable("edgeClassSimpleName", edgeClass.getSimpleName());
            ((CodeBlock)object).setVariable("edgeClassQualifiedName", string);
            ((CodeBlock)object).setVariable("edgeClassUniqueName", edgeClass.getUniqueName());
            if (this.currentCycle.isAbstract()) {
                ((CodeSnippet)object).add("/**");
                ((CodeSnippet)object).add(" * Returns an Iterable for all incidence edges of this vertex that are of type #edgeClassSimpleName# or subtypes.");
                ((CodeSnippet)object).add(" */");
                ((CodeSnippet)object).add("public Iterable<#edgeClassQualifiedName#> get#edgeClassUniqueName#Incidences();");
            }
            if (this.currentCycle.isStdImpl()) {
                ((CodeSnippet)object).add("@Override");
                ((CodeSnippet)object).add("public Iterable<#edgeClassQualifiedName#> get#edgeClassUniqueName#Incidences() {");
                ((CodeSnippet)object).add("\treturn new IncidenceIterable<#edgeClassQualifiedName#>(this, #edgeClassQualifiedName#.EC);");
                ((CodeSnippet)object).add("}");
            }
            ((CodeSnippet)object).add("");
            if (this.currentCycle.isAbstract()) {
                ((CodeSnippet)object).add("/**");
                ((CodeSnippet)object).add(" * Returns an Iterable for all incidence edges of this vertex that are of type #edgeClassSimpleName#.");
                ((CodeSnippet)object).add(" * @param direction EdgeDirection.IN or EdgeDirection.OUT, only edges of this direction will be included in the Iterable");
                ((CodeSnippet)object).add(" */");
                ((CodeSnippet)object).add("public Iterable<#edgeClassQualifiedName#> get#edgeClassUniqueName#Incidences(EdgeDirection direction);");
            }
            if (!this.currentCycle.isStdImpl()) continue;
            ((CodeSnippet)object).add("@Override");
            ((CodeSnippet)object).add("public Iterable<#edgeClassQualifiedName#> get#edgeClassUniqueName#Incidences(EdgeDirection direction) {");
            ((CodeSnippet)object).add("\treturn new IncidenceIterable<#edgeClassQualifiedName#>(this, #edgeClassQualifiedName#.EC, direction);");
            ((CodeSnippet)object).add("}");
        }
        return codeList;
    }

    @Override
    protected CodeBlock createAttributedElementClassConstant() {
        CodeSnippet codeSnippet = new CodeSnippet(true, "public static final #jgSchemaPackage#.#schemaElementClass# VC = #schemaPackageName#.#schemaName#.instance().getGraphClass().getVertexClass(\"#vcQualifiedName#\");");
        codeSnippet.setVariable("vcQualifiedName", ((VertexClass)this.aec).getQualifiedName());
        return codeSnippet;
    }

    @Override
    protected CodeBlock createGetAttributedElementClassMethod() {
        return new CodeSnippet(true, "@Override", "public final #jgSchemaPackage#.#schemaElementClass# getAttributedElementClass() {", "\treturn #javaClassName#.VC;", "}");
    }
}

