/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.AttributedElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.DomainImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.util.regex.Pattern;

public class AttributeImpl
implements Attribute,
Comparable<Attribute> {
    private static final Pattern ATTRIBUTE_NAME_PATTERN = Pattern.compile("\\p{Lower}\\w*");
    private String name;
    private final Domain domain;
    private final AttributedElementClass<?, ?> aec;
    private final String sortKey;
    private String defaultValueAsString;
    private Object defaultValue;
    private Object defaultTransactionValue;
    private boolean defaultTransactionValueComputed;
    private boolean defaultValueComputed;

    AttributeImpl(String string, Domain domain, AttributedElementClass<?, ?> attributedElementClass, String string2) {
        if (!ATTRIBUTE_NAME_PATTERN.matcher(string).matches()) {
            throw new SchemaException("Invalid attribute name '" + string + "'.");
        }
        this.name = string;
        this.domain = domain;
        this.aec = attributedElementClass;
        this.sortKey = string + ":" + domain.getQualifiedName();
        this.setDefaultValueAsString(string2);
        DomainImpl domainImpl = (DomainImpl)this.domain;
        domainImpl.registerAttribute(this);
    }

    @Override
    public String toString() {
        return "Attribute " + this.sortKey;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AttributedElementClass<?, ?> getAttributedElementClass() {
        return this.aec;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.sortKey.hashCode() + this.aec.hashCode();
    }

    @Override
    public int compareTo(Attribute attribute) {
        int n = this.sortKey.compareTo(attribute.getSortKey());
        if (n != 0) {
            return n;
        }
        return this.aec.compareTo(attribute.getAttributedElementClass());
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    @Override
    public void setDefaultValueAsString(String string) throws SchemaException {
        if (this.defaultValueAsString != null) {
            throw new SchemaException("Cannot assign a new default value to Attribute " + this.name + " of " + this.aec.getQualifiedName() + ".");
        }
        this.defaultValueAsString = string;
    }

    @Override
    public void setDefaultTransactionValue(AttributedElement<?, ?> attributedElement) throws GraphIOException {
        if (this.defaultValueAsString != null) {
            if (this.defaultTransactionValueComputed) {
                attributedElement.setAttribute(this.name, this.defaultTransactionValue);
            } else {
                if (this.defaultValueAsString != null) {
                    attributedElement.readAttributeValueFromString(this.name, this.defaultValueAsString);
                }
                this.defaultTransactionValue = attributedElement.getAttribute(this.name);
                this.defaultTransactionValueComputed = true;
            }
        }
    }

    @Override
    public void setDefaultValue(AttributedElement<?, ?> attributedElement) throws GraphIOException {
        if (this.defaultValueComputed) {
            attributedElement.setAttribute(this.name, this.defaultValue);
        } else {
            if (this.defaultValueAsString != null) {
                attributedElement.readAttributeValueFromString(this.name, this.defaultValueAsString);
            }
            this.defaultValue = attributedElement.getAttribute(this.name);
            this.defaultValueComputed = true;
        }
    }

    @Override
    public void delete() {
        ((SchemaImpl)this.aec.getSchema()).assertNotFinished();
        ((AttributedElementClassImpl)this.aec).deleteAttribute(this);
        DomainImpl domainImpl = (DomainImpl)this.domain;
        domainImpl.attributes = domainImpl.attributes.minus(this);
    }

    @Override
    public void setName(String string) {
        ((SchemaImpl)this.aec.getSchema()).assertNotFinished();
        if (!ATTRIBUTE_NAME_PATTERN.matcher(string).matches()) {
            throw new SchemaException("Invalid attribute name '" + string + "'.");
        }
        this.name = string;
    }
}

