/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.io.IOException;

public final class BooleanDomainImpl
extends BasicDomainImpl
implements BooleanDomain {
    BooleanDomainImpl(Schema schema) {
        super("Boolean", (PackageImpl)schema.getDefaultPackage());
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String string) {
        return "boolean";
    }

    @Override
    public String getJavaClassName(String string) {
        return "java.lang.Boolean";
    }

    @Override
    public CodeBlock getReadMethod(String string, String string2, String string3) {
        return new CodeSnippet(string2 + " = " + string3 + ".matchBoolean();");
    }

    @Override
    public String getTGTypeName(Package package_) {
        return "Boolean";
    }

    @Override
    public CodeBlock getWriteMethod(String string, String string2, String string3) {
        return new CodeSnippet(string3 + ".writeBoolean(" + string2 + ");");
    }

    @Override
    public CodeBlock getTransactionReadMethod(String string, String string2, String string3) {
        return new CodeSnippet(this.getJavaAttributeImplementationTypeName(string) + " " + string2 + " = " + string3 + ".matchBoolean();");
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String string, String string2, String string3) {
        return this.getWriteMethod(string, "is" + CodeGenerator.camelCase(string2) + "()", string3);
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String string) {
        return "java.lang.Boolean";
    }

    @Override
    public String getTransactionJavaClassName(String string) {
        return this.getJavaClassName(string);
    }

    @Override
    public String getVersionedClass(String string) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaClassName(string) + ">";
    }

    @Override
    public String getInitialValue() {
        return "false";
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Object parseGenericAttribute(GraphIO graphIO) throws GraphIOException {
        return graphIO.matchBoolean();
    }

    @Override
    public void serializeGenericAttribute(GraphIO graphIO, Object object) throws IOException {
        graphIO.writeBoolean((Boolean)object);
    }

    @Override
    public boolean isConformValue(Object object) {
        return Boolean.class.isInstance(object);
    }
}

