/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.CompositeDomain;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.SetDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.EdgeCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.EnumCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.GraphCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.GraphFactoryGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.RecordCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.ReversedEdgeCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.SchemaCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.VertexCodeGenerator;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.BooleanDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import de.uni_koblenz.jgralab.schema.impl.DoubleDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.EnumDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import de.uni_koblenz.jgralab.schema.impl.IntegerDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.ListDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.LongDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.MapDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.RecordDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.SetDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.StringDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.ClassFileManager;
import de.uni_koblenz.jgralab.schema.impl.compilation.InMemoryJavaSourceFile;
import de.uni_koblenz.jgralab.schema.impl.compilation.ManagableArtifact;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.pcollections.ArrayPSet;
import org.pcollections.PSet;

public class SchemaImpl
implements Schema,
ManagableArtifact {
    private SchemaClassManager schemaClassManager = null;
    static final Class<?>[] GRAPHCLASS_CREATE_SIGNATURE = new Class[]{ImplementationType.class, String.class, Integer.TYPE, Integer.TYPE};
    public static final String IMPL_PACKAGE_NAME = "impl";
    public static final String IMPLSTDPACKAGENAME = "impl.std";
    public static final String IMPLTRANSPACKAGENAME = "impl.trans";
    public static final String IMPLDATABASEPACKAGENAME = "impl.db";
    static final Class<?>[] VERTEX_CLASS_CREATE_SIGNATURE = new Class[]{Integer.TYPE};
    private boolean allowLowercaseEnumConstants = true;
    private PackageImpl defaultPackage;
    Map<String, Domain> domains = new HashMap<String, Domain>();
    private DirectedAcyclicGraph<Domain> domainsDag = new DirectedAcyclicGraph();
    private int version;
    private boolean finished = false;
    private GraphClassImpl graphClass;
    private String name;
    private String packagePrefix;
    Map<String, PackageImpl> packages = new TreeMap<String, PackageImpl>();
    private String qualifiedName;
    Map<String, NamedElement> namedElements = new TreeMap<String, NamedElement>();
    private BooleanDomain booleanDomain;
    private DoubleDomain doubleDomain;
    private IntegerDomain integerDomain;
    private LongDomain longDomain;
    private StringDomain stringDomain;
    private static final Pattern SCHEMA_NAME_PATTERN = Pattern.compile("^\\p{Upper}(\\p{Alnum}|[_])*\\p{Alnum}$");
    private static final Pattern PACKAGE_PREFIX_PATTERN = Pattern.compile("^\\p{Lower}\\w*(\\.\\p{Lower}\\w*)*$");
    private int graphElementClassCount = 0;
    private int incidenceClassCount = 0;

    public SchemaClassManager getSchemaClassManager() {
        return this.schemaClassManager;
    }

    public SchemaImpl(String string, String string2) {
        if (!SCHEMA_NAME_PATTERN.matcher(string).matches()) {
            throw new SchemaException("Invalid schema name '" + string + "'.\n" + "The name must not be empty.\n" + "The name must start with a capital letter.\n" + "Any following character must be alphanumeric and/or a '_' character.\n" + "The name must end with an alphanumeric character.");
        }
        if (!PACKAGE_PREFIX_PATTERN.matcher(string2).matches()) {
            throw new SchemaException("Invalid schema package prefix '" + string2 + "'.\n" + "The packagePrefix must not be empty.\n" + "The package prefix must start with a small letter.\n" + "The first character after each '.' must be a small letter.\n" + "Following characters may be alphanumeric and/or '_' characters.\n" + "The last character before a '.' and the end of the line must be an alphanumeric character.");
        }
        this.name = string;
        this.packagePrefix = string2;
        this.qualifiedName = string2 + "." + string;
        this.schemaClassManager = SchemaClassManager.instance(this.qualifiedName);
        this.defaultPackage = PackageImpl.createDefaultPackage(this);
        this.createBooleanDomain();
        this.createDoubleDomain();
        this.createIntegerDomain();
        this.createLongDomain();
        this.createStringDomain();
    }

    void addDomain(Domain domain) {
        if (this.domains.containsKey(domain.getQualifiedName())) {
            throw new SchemaException("Duplicate Domain '" + domain.getQualifiedName() + "'");
        }
        this.domains.put(domain.getQualifiedName(), domain);
        this.domainsDag.createNode(domain);
    }

    void addPackage(PackageImpl packageImpl) {
        if (this.packages.containsKey(packageImpl.getQualifiedName())) {
            throw new SchemaException("Duplicate Package '" + packageImpl.getQualifiedName() + "'");
        }
        this.packages.put(packageImpl.getQualifiedName(), packageImpl);
    }

    void addNamedElement(NamedElement namedElement) {
        if (this.namedElements.containsKey(namedElement.getQualifiedName())) {
            throw new SchemaException("Duplicate NamedElement '" + namedElement.getQualifiedName() + "'");
        }
        this.namedElements.put(namedElement.getQualifiedName(), namedElement);
        if (!(namedElement instanceof AttributedElementClass)) {
            return;
        }
    }

    @Override
    public NamedElement getNamedElement(String string) {
        return this.namedElements.get(string);
    }

    @Override
    public boolean allowsLowercaseEnumConstants() {
        return this.allowLowercaseEnumConstants;
    }

    private Vector<InMemoryJavaSourceFile> createClasses(CodeGeneratorConfiguration codeGeneratorConfiguration) {
        CodeGenerator codeGenerator;
        Vector<InMemoryJavaSourceFile> vector = new Vector<InMemoryJavaSourceFile>();
        GraphCodeGenerator graphCodeGenerator = new GraphCodeGenerator(this.graphClass, this.packagePrefix, this.name, codeGeneratorConfiguration);
        vector.addAll(graphCodeGenerator.createJavaSources());
        for (VertexClass namedElement : this.graphClass.getVertexClasses()) {
            codeGenerator = new VertexCodeGenerator(namedElement, this.packagePrefix, codeGeneratorConfiguration);
            vector.addAll(codeGenerator.createJavaSources());
        }
        for (EdgeClass edgeClass : this.graphClass.getEdgeClasses()) {
            codeGenerator = new EdgeCodeGenerator(edgeClass, this.packagePrefix, codeGeneratorConfiguration);
            vector.addAll(codeGenerator.createJavaSources());
            if (edgeClass.isAbstract()) continue;
            codeGenerator = new ReversedEdgeCodeGenerator(edgeClass, this.packagePrefix, codeGeneratorConfiguration);
            vector.addAll(codeGenerator.createJavaSources());
        }
        for (Domain domain : this.getRecordDomains()) {
            codeGenerator = new RecordCodeGenerator((RecordDomain)domain, this.packagePrefix, codeGeneratorConfiguration);
            vector.addAll(codeGenerator.createJavaSources());
        }
        for (Domain domain : this.getEnumDomains()) {
            codeGenerator = new EnumCodeGenerator((EnumDomain)domain, this.packagePrefix);
            vector.addAll(codeGenerator.createJavaSources());
        }
        return vector;
    }

    @Override
    public void createJAR(CodeGeneratorConfiguration codeGeneratorConfiguration, String string) throws IOException, GraphIOException {
        this.assertFinished();
        File file = File.createTempFile("jar-creation", "tmp");
        file.deleteOnExit();
        File file2 = new File(file.getParent());
        File file3 = new File(file2 + File.separator + this.getName());
        if (!file3.mkdir()) {
            System.err.println("Couldn't create " + file3);
            return;
        }
        System.out.println("Committing schema classes to " + file3);
        this.commit(file3.getAbsolutePath(), codeGeneratorConfiguration, new ConsoleProgressFunction("Committing"));
        this.compileClasses(file3);
        Process process = Runtime.getRuntime().exec("jar cf " + string + " -C " + file3.getAbsolutePath() + " .");
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.deleteRecursively(file3);
    }

    private void deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.deleteRecursively(file2);
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    private void compileClasses(File file) throws IOException {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(this.getJavaFiles(file));
        javaCompiler.getTask(null, standardJavaFileManager, null, null, null, iterable).call();
        standardJavaFileManager.close();
    }

    private List<File> getJavaFiles(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                linkedList.addAll(this.getJavaFiles(file2));
                continue;
            }
            if (!file2.getName().endsWith(".java")) continue;
            linkedList.add(file2);
        }
        return linkedList;
    }

    @Override
    public Vector<InMemoryJavaSourceFile> commit(CodeGeneratorConfiguration codeGeneratorConfiguration) {
        this.assertFinished();
        Vector<InMemoryJavaSourceFile> vector = new Vector<InMemoryJavaSourceFile>();
        SchemaCodeGenerator schemaCodeGenerator = new SchemaCodeGenerator(this, this.packagePrefix, codeGeneratorConfiguration);
        vector.addAll(schemaCodeGenerator.createJavaSources());
        GraphFactoryGenerator graphFactoryGenerator = new GraphFactoryGenerator(this, this.packagePrefix, codeGeneratorConfiguration);
        vector.addAll(graphFactoryGenerator.createJavaSources());
        vector.addAll(this.createClasses(codeGeneratorConfiguration));
        return vector;
    }

    private void createFiles(CodeGeneratorConfiguration codeGeneratorConfiguration, String string, ProgressFunction progressFunction, long l, long l2, long l3) throws GraphIOException {
        CodeGenerator codeGenerator;
        GraphCodeGenerator graphCodeGenerator = new GraphCodeGenerator(this.graphClass, this.packagePrefix, this.name, codeGeneratorConfiguration);
        graphCodeGenerator.createFiles(string);
        for (VertexClass namedElement : this.graphClass.getVertexClasses()) {
            codeGenerator = new VertexCodeGenerator(namedElement, this.packagePrefix, codeGeneratorConfiguration);
            codeGenerator.createFiles(string);
            if (progressFunction == null) continue;
            ++l;
            if (++l2 != l3) continue;
            progressFunction.progress(l);
            l2 = 0L;
        }
        for (EdgeClass edgeClass : this.graphClass.getEdgeClasses()) {
            codeGenerator = new EdgeCodeGenerator(edgeClass, this.packagePrefix, codeGeneratorConfiguration);
            codeGenerator.createFiles(string);
            if (!edgeClass.isAbstract()) {
                codeGenerator = new ReversedEdgeCodeGenerator(edgeClass, this.packagePrefix, codeGeneratorConfiguration);
                codeGenerator.createFiles(string);
            }
            if (progressFunction == null) continue;
            ++l;
            if (++l2 != l3) continue;
            progressFunction.progress(l);
            l2 = 0L;
        }
        for (Domain domain : this.getRecordDomains()) {
            codeGenerator = new RecordCodeGenerator((RecordDomain)domain, this.packagePrefix, codeGeneratorConfiguration);
            codeGenerator.createFiles(string);
            if (progressFunction == null) continue;
            ++l;
            if (++l2 != l3) continue;
            progressFunction.progress(l);
            l2 = 0L;
        }
        for (Domain domain : this.getEnumDomains()) {
            codeGenerator = new EnumCodeGenerator((EnumDomain)domain, this.packagePrefix);
            codeGenerator.createFiles(string);
        }
        if (progressFunction != null) {
            ++l;
            if (++l2 == l3) {
                progressFunction.progress(l);
                l2 = 0L;
            }
        }
    }

    @Override
    public void commit(String string, CodeGeneratorConfiguration codeGeneratorConfiguration) throws GraphIOException {
        this.assertFinished();
        this.commit(string, codeGeneratorConfiguration, null);
    }

    @Override
    public void commit(String string, CodeGeneratorConfiguration codeGeneratorConfiguration, ProgressFunction progressFunction) throws GraphIOException {
        this.assertFinished();
        long l = 0L;
        long l2 = 0L;
        long l3 = 1L;
        if (progressFunction != null) {
            int n = this.getNumberOfElements();
            progressFunction.init(n);
            l3 = progressFunction.getUpdateInterval();
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        SchemaCodeGenerator schemaCodeGenerator = new SchemaCodeGenerator(this, this.packagePrefix, codeGeneratorConfiguration);
        schemaCodeGenerator.createFiles(string);
        GraphFactoryGenerator graphFactoryGenerator = new GraphFactoryGenerator(this, this.packagePrefix, codeGeneratorConfiguration);
        graphFactoryGenerator.createFiles(string);
        if (this.graphClass.getQualifiedName().equals("Graph")) {
            throw new SchemaException("The defined GraphClass must not be named Graph!");
        }
        this.createFiles(codeGeneratorConfiguration, string, progressFunction, l, l2, l3);
        if (progressFunction != null) {
            progressFunction.finished();
        }
    }

    @Override
    public int compareTo(Schema schema) {
        return this.qualifiedName.compareTo(schema.getQualifiedName());
    }

    @Override
    public void compile(CodeGeneratorConfiguration codeGeneratorConfiguration) {
        this.assertFinished();
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            throw new SchemaException("Cannot compile schema " + this.qualifiedName + ". Most probably you use a JRE instead of a JDK. " + "The JRE does not provide a compiler.");
        }
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
        ClassFileManager classFileManager = new ClassFileManager(this, standardJavaFileManager);
        Vector<InMemoryJavaSourceFile> vector = this.commit(codeGeneratorConfiguration);
        javaCompiler.getTask(null, classFileManager, null, null, null, vector).call();
    }

    @Override
    public EnumDomain createEnumDomain(String string) {
        return this.createEnumDomain(string, new ArrayList<String>());
    }

    @Override
    public EnumDomain createEnumDomain(String string, List<String> list) {
        this.assertNotFinished();
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        PackageImpl packageImpl = this.createPackageWithParents(stringArray[0]);
        String string2 = stringArray[1];
        EnumDomainImpl enumDomainImpl = new EnumDomainImpl(string2, packageImpl, list);
        return enumDomainImpl;
    }

    @Override
    public EnumDomain createEnumDomain(String string, String ... stringArray) {
        return this.createEnumDomain(string, Arrays.asList(stringArray));
    }

    @Override
    public GraphClass createGraphClass(String string) {
        this.assertNotFinished();
        if (this.graphClass != null) {
            throw new SchemaException("Only one GraphClass (except DefaultGraphClass) is allowed in a Schema! '" + this.graphClass.getQualifiedName() + "' is already there.");
        }
        if (string.contains(".")) {
            throw new SchemaException("A GraphClass must always be in the default package!");
        }
        GraphClassImpl graphClassImpl = new GraphClassImpl(string, this);
        graphClassImpl.initializeDefaultVertexClass();
        graphClassImpl.initializeDefaultEdgeClass();
        graphClassImpl.initializeTemporaryVertexClass();
        graphClassImpl.initializeTemporaryEdgeClass();
        return graphClassImpl;
    }

    private BooleanDomain createBooleanDomain() {
        this.assertNotFinished();
        if (this.booleanDomain == null) {
            this.booleanDomain = new BooleanDomainImpl(this);
        }
        return this.booleanDomain;
    }

    private DoubleDomain createDoubleDomain() {
        this.assertNotFinished();
        if (this.doubleDomain == null) {
            this.doubleDomain = new DoubleDomainImpl(this);
        }
        return this.doubleDomain;
    }

    private IntegerDomain createIntegerDomain() {
        this.assertNotFinished();
        if (this.integerDomain == null) {
            this.integerDomain = new IntegerDomainImpl(this);
        }
        return this.integerDomain;
    }

    private LongDomain createLongDomain() {
        this.assertNotFinished();
        if (this.longDomain == null) {
            this.longDomain = new LongDomainImpl(this);
        }
        return this.longDomain;
    }

    private StringDomain createStringDomain() {
        this.assertNotFinished();
        if (this.stringDomain == null) {
            this.stringDomain = new StringDomainImpl(this);
        }
        return this.stringDomain;
    }

    @Override
    public ListDomain createListDomain(Domain domain) {
        this.assertNotFinished();
        String string = "List<" + domain.getQualifiedName() + ">";
        if (this.domains.containsKey(string)) {
            return (ListDomain)this.domains.get(string);
        }
        return new ListDomainImpl(this, domain);
    }

    @Override
    public MapDomain createMapDomain(Domain domain, Domain domain2) {
        this.assertNotFinished();
        String string = "Map<" + domain.getQualifiedName() + ", " + domain2.getQualifiedName() + ">";
        if (this.domains.containsKey(string)) {
            return (MapDomain)this.domains.get(string);
        }
        return new MapDomainImpl(this, domain, domain2);
    }

    PackageImpl createPackage(String string, PackageImpl packageImpl) {
        this.assertNotFinished();
        return new PackageImpl(string, packageImpl, this);
    }

    PackageImpl createPackageWithParents(String string) {
        this.assertNotFinished();
        if (this.packages.containsKey(string)) {
            return this.packages.get(string);
        }
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        assert (!string3.contains(".")) : "The package simple name '" + string3 + "' must not contain a dot!";
        PackageImpl packageImpl = this.defaultPackage;
        String string4 = "";
        if (!this.packages.containsKey(string2)) {
            for (String string5 : string2.split("\\.")) {
                string4 = packageImpl != this.defaultPackage ? packageImpl.getQualifiedName() + "." + string5 : string5;
                packageImpl = this.packages.containsKey(string4) ? this.packages.get(string4) : this.createPackage(string5, packageImpl);
            }
        } else {
            packageImpl = this.packages.get(string2);
        }
        assert (packageImpl.getQualifiedName().equals(string2)) : "Something went wrong when creating a package with parents: parent should be \"" + string2 + "\" but created was \"" + packageImpl.getQualifiedName() + "\".";
        assert (!packageImpl.getQualifiedName().isEmpty() || packageImpl == this.defaultPackage) : "The parent package of package '" + string3 + "' is empty, but not the default package.";
        return this.createPackage(string3, packageImpl);
    }

    public static String[] splitQualifiedName(String string) {
        int n = string.lastIndexOf(46);
        String[] stringArray = new String[2];
        if (n == -1) {
            stringArray[0] = "";
            stringArray[1] = string;
        } else {
            stringArray[0] = string.substring(0, n);
            if (stringArray[0].length() >= 1 && stringArray[0].charAt(0) == '.') {
                stringArray[0] = stringArray[0].substring(1);
            }
            stringArray[1] = string.substring(n + 1);
        }
        return stringArray;
    }

    @Override
    public RecordDomain createRecordDomain(String string) {
        return this.createRecordDomain(string, null);
    }

    @Override
    public RecordDomain createRecordDomain(String string, Collection<RecordDomain.RecordComponent> collection) {
        this.assertNotFinished();
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        PackageImpl packageImpl = this.createPackageWithParents(stringArray[0]);
        String string2 = stringArray[1];
        RecordDomainImpl recordDomainImpl = new RecordDomainImpl(string2, packageImpl, collection);
        return recordDomainImpl;
    }

    @Override
    public SetDomain createSetDomain(Domain domain) {
        this.assertNotFinished();
        String string = "Set<" + domain.getQualifiedName() + ">";
        if (this.domains.containsKey(string)) {
            return (SetDomain)this.domains.get(string);
        }
        return new SetDomainImpl(this, domain);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Schema)) {
            return false;
        }
        return this.qualifiedName.equals(((SchemaImpl)object).qualifiedName);
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    @Override
    public <T extends AttributedElementClass<?, ?>> T getAttributedElementClass(String string) {
        if (this.graphClass == null) {
            return null;
        }
        if (this.graphClass.getQualifiedName().equals(string)) {
            return (T)this.graphClass;
        }
        return (T)this.graphClass.getGraphElementClass(string);
    }

    @Override
    public List<CompositeDomain> getCompositeDomains() {
        ArrayList<CompositeDomain> arrayList = new ArrayList<CompositeDomain>();
        for (Domain domain : this.domainsDag.getNodesInTopologicalOrder()) {
            if (!(domain instanceof CompositeDomain)) continue;
            arrayList.add((CompositeDomain)domain);
        }
        return arrayList;
    }

    private Method getCreateMethod(String string, String string2, Class<?>[] classArray, ImplementationType implementationType) {
        Class<? extends Graph> clazz = null;
        GraphElementClass<VertexClass, Vertex> graphElementClass = null;
        try {
            clazz = this.getGraphClassImpl(implementationType);
            if (string.equals(string2)) {
                if (implementationType != ImplementationType.GENERIC) {
                    return this.getClass().getMethod("create" + string2, classArray);
                }
                return clazz.getMethod("createGraph", classArray);
            }
            graphElementClass = this.graphClass.getVertexClass(string);
            if (graphElementClass == null && (graphElementClass = this.graphClass.getEdgeClass(string)) == null) {
                throw new SchemaClassAccessException("class " + string + " does not exist in schema");
            }
            if (implementationType != ImplementationType.GENERIC) {
                return clazz.getMethod("create" + CodeGenerator.camelCase(graphElementClass.getUniqueName()), classArray);
            }
            if (classArray[0].equals(VertexClass.class)) {
                return clazz.getMethod("createVertex", classArray);
            }
            return clazz.getMethod("createEdge", classArray);
        }
        catch (SecurityException securityException) {
            throw new SchemaClassAccessException("can't find create method in '" + clazz.getName() + "' for '" + graphElementClass.getUniqueName() + "'", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SchemaClassAccessException("can't find create method in '" + clazz.getName() + "' for '" + graphElementClass.getUniqueName() + "'", noSuchMethodException);
        }
    }

    @Override
    public Package getDefaultPackage() {
        return this.defaultPackage;
    }

    @Override
    public Domain getDomain(String string) {
        return this.domains.get(string);
    }

    @Override
    public PSet<Domain> getDomains() {
        return ArrayPSet.empty().plusAll(this.domains.values());
    }

    void addDomainDependency(Domain domain, Domain domain2) {
        this.domainsDag.createEdge(domain2, domain);
    }

    @Override
    public Method getEdgeCreateMethod(String string, ImplementationType implementationType) {
        Object t = this.getAttributedElementClass(string);
        if (t == null || !(t instanceof EdgeClass)) {
            throw new SchemaException("There's no EdgeClass with qualified name " + string + "!");
        }
        EdgeClass edgeClass = (EdgeClass)t;
        String string2 = "create" + CodeGenerator.camelCase(edgeClass.getUniqueName());
        Class<? extends Graph> clazz = this.getGraphClassImpl(implementationType);
        if (implementationType != ImplementationType.GENERIC) {
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(string2) || method.getParameterTypes().length != 3) continue;
                return method;
            }
        } else {
            try {
                return clazz.getMethod("createEdge", EdgeClass.class, Integer.TYPE, Vertex.class, Vertex.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
        throw new SchemaClassAccessException("can't find create method '" + string2 + "' in '" + clazz.getName() + "' for '" + edgeClass.getUniqueName() + "'");
    }

    @Override
    public List<EnumDomain> getEnumDomains() {
        ArrayList<EnumDomain> arrayList = new ArrayList<EnumDomain>();
        for (Domain domain : this.domains.values()) {
            if (!(domain instanceof EnumDomain)) continue;
            arrayList.add((EnumDomain)domain);
        }
        return arrayList;
    }

    @Override
    public BooleanDomain getBooleanDomain() {
        return this.booleanDomain;
    }

    @Override
    public DoubleDomain getDoubleDomain() {
        return this.doubleDomain;
    }

    @Override
    public IntegerDomain getIntegerDomain() {
        return this.integerDomain;
    }

    @Override
    public LongDomain getLongDomain() {
        return this.longDomain;
    }

    @Override
    public StringDomain getStringDomain() {
        return this.stringDomain;
    }

    @Override
    public GraphClass getGraphClass() {
        return this.graphClass;
    }

    private Class<? extends Graph> getGraphClassImpl(ImplementationType implementationType) {
        String string = this.packagePrefix + ".";
        switch (implementationType) {
            case STANDARD: {
                string = string + IMPLSTDPACKAGENAME;
                break;
            }
            case GENERIC: {
                string = "de.uni_koblenz.jgralab.impl.generic";
                break;
            }
            default: {
                throw new SchemaException("Implementation type " + (Object)((Object)implementationType) + " not supported yet.");
            }
        }
        if (implementationType != ImplementationType.GENERIC) {
            Class<?> clazz;
            string = string + "." + this.graphClass.getSimpleName() + "Impl";
            try {
                clazz = Class.forName(string, true, SchemaClassManager.instance(this.qualifiedName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SchemaClassAccessException("can't load implementation class '" + string + "'", classNotFoundException);
            }
            return clazz;
        }
        string = string + ".GenericGraphImpl";
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SchemaClassAccessException("can't load implementation class '" + string + "'", classNotFoundException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private int getNumberOfElements() {
        return this.graphClass.getGraphElementClasses().size() + 1;
    }

    @Override
    public Package getPackage(String string) {
        return this.packages.get(string);
    }

    @Override
    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public List<RecordDomain> getRecordDomains() {
        ArrayList<RecordDomain> arrayList = new ArrayList<RecordDomain>();
        for (Domain domain : this.domains.values()) {
            if (!(domain instanceof RecordDomain)) continue;
            arrayList.add((RecordDomain)domain);
        }
        return arrayList;
    }

    @Override
    public Method getVertexCreateMethod(String string, ImplementationType implementationType) {
        if (implementationType != ImplementationType.GENERIC) {
            return this.getCreateMethod(string, this.graphClass.getSimpleName(), VERTEX_CLASS_CREATE_SIGNATURE, implementationType);
        }
        return this.getCreateMethod(string, this.graphClass.getSimpleName(), new Class[]{VertexClass.class, Integer.TYPE}, implementationType);
    }

    @Override
    public boolean isValidEnumConstant(String string) {
        if (string.isEmpty()) {
            return false;
        }
        if (string.equals(GraphIO.NULL_LITERAL)) {
            return false;
        }
        if (!this.allowLowercaseEnumConstants && !string.equals(string.toUpperCase())) {
            return false;
        }
        if (RESERVED_JAVA_WORDS.contains(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean knows(String string) {
        return this.namedElements.containsKey(string) || this.getQualifiedName().equals(string);
    }

    @Override
    public void setAllowLowercaseEnumConstants(boolean bl) {
        this.allowLowercaseEnumConstants = bl;
    }

    void setGraphClass(GraphClassImpl graphClassImpl) {
        if (this.graphClass != null) {
            throw new SchemaException("A GraphClass named '" + this.graphClass.getQualifiedName() + "' already exists in this Schema!");
        }
        this.graphClass = graphClassImpl;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public String toTGString() {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            GraphIO.saveSchemaToStream(this, dataOutputStream);
            byteArrayOutputStream.close();
            string = new String(byteArrayOutputStream.toByteArray());
        }
        catch (GraphIOException graphIOException) {
            throw new SchemaException(graphIOException);
        }
        catch (IOException iOException) {
            throw new SchemaException(iOException);
        }
        return string;
    }

    @Override
    public String getFileName() {
        return this.qualifiedName.replace('.', File.separatorChar);
    }

    @Override
    public String getPathName() {
        return this.packagePrefix.replace('.', File.separatorChar);
    }

    @Override
    public GraphFactory createDefaultGraphFactory(ImplementationType implementationType) {
        this.assertFinished();
        if (implementationType != ImplementationType.GENERIC) {
            throw new SchemaException("Base implementation can't create a GraphFactory for implementation type " + (Object)((Object)implementationType) + ". Only GENERIC is supported.");
        }
        return new GenericGraphFactoryImpl(this);
    }

    @Override
    public Graph createGraph(ImplementationType implementationType) {
        return this.createGraph(implementationType, null, 100, 100);
    }

    @Override
    public Graph createGraph(ImplementationType implementationType, String string, int n, int n2) {
        this.assertFinished();
        GraphFactory graphFactory = this.createDefaultGraphFactory(implementationType);
        return graphFactory.createGraph(this.getGraphClass(), string, n, n2);
    }

    protected void assertFinished() {
        if (!this.finished) {
            throw new SchemaException("Schema must be finished.");
        }
    }

    protected void assertNotFinished() {
        if (this.finished) {
            throw new SchemaException("No changes allowed in a finished Schema.");
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean finish() {
        if (this.finished) {
            return false;
        }
        if (this.graphClass == null) {
            throw new SchemaException("Can't finish a schema without a GraphClass. Create a GraphClass first!");
        }
        this.domainsDag.finish();
        this.graphClass.finish();
        this.finished = true;
        ++this.version;
        return true;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean reopen() {
        if (!this.finished) {
            return false;
        }
        this.domainsDag.reopen();
        this.graphClass.reopen();
        this.finished = false;
        return true;
    }

    @Override
    public void save(String string) throws GraphIOException {
        GraphIO.saveSchemaToFile(this, string);
    }

    @Override
    public void save(DataOutputStream dataOutputStream) throws GraphIOException {
        GraphIO.saveSchemaToStream(this, dataOutputStream);
    }

    protected int getNextGraphElementClassId() {
        return this.graphElementClassCount++;
    }

    @Override
    public int getGraphElementClassCount() {
        return this.graphElementClassCount;
    }

    public int getNextIncidenceClassId() {
        return this.incidenceClassCount++;
    }

    @Override
    public int getIncidenceClassCount() {
        return this.incidenceClassCount;
    }

    @Override
    public String getManagedName() {
        return this.qualifiedName;
    }
}

