/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlgui;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.utilities.greqlgui.GreqlGui;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotPanel;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizLayouter;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizProgram;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class GraphViewer
extends JDialog {
    private GreqlGui gui;
    private Graph graph;
    private String queryText;
    private InputStream xdotInputStream;
    private XDotPanel xdPanel;
    private JScrollPane graphScrollPane;

    public GraphViewer(GreqlGui greqlGui, Graph graph, String string) {
        super((Frame)greqlGui, greqlGui.getMessage("GraphViewer.Title"));
        this.gui = greqlGui;
        this.queryText = string;
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.graph = graph;
        Tg2Dot tg2Dot = new Tg2Dot();
        tg2Dot.setGraph(graph);
        tg2Dot.setReversedEdges(true);
        tg2Dot.setPrintIncidenceNumbers(true);
        try {
            this.xdotInputStream = tg2Dot.convertToGraphVizStream(new GraphVizProgram().layouter(GraphVizLayouter.DOT).outputFormat(GraphVizOutputFormat.XDOT));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.add(this.createContent(), "Center");
        this.pack();
    }

    protected Component createContent() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.setLayout(new BorderLayout());
        try {
            this.xdPanel = new XDotPanel(this.graph, this.xdotInputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        JSlider jSlider = new JSlider(this.xdPanel.getZoomLevelModel());
        jSlider.setMajorTickSpacing(16);
        jSlider.setPaintTicks(true);
        JButton jButton = new JButton(this.gui.getMessage("GraphViewer.ZoomToFit"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphViewer.this.xdPanel.zoomToFit(GraphViewer.this.graphScrollPane.getSize());
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jSlider);
        jPanel.add((Component)jPanel2, "North");
        this.xdPanel.setAutoscrolls(true);
        this.graphScrollPane = new JScrollPane(this.xdPanel);
        this.graphScrollPane.setPreferredSize(new Dimension(800, 600));
        this.graphScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.queryText);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        JSplitPane jSplitPane = new JSplitPane(0, this.graphScrollPane, jScrollPane);
        jSplitPane.setContinuousLayout(true);
        jPanel.add((Component)jSplitPane, "Center");
        return jPanel;
    }
}

