/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.undo;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphChangeListener;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.gui.undo.CompoundGraphEdit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class GraphUndoManager
extends UndoManager
implements GraphChangeListener {
    private static final long serialVersionUID = -1959515066823695788L;
    private Graph graph;
    private boolean working;
    private int version;
    private HashMap<Integer, Integer> versions = new HashMap();
    private GraphEdit first;
    private GraphEdit last;
    private Stack<CompoundGraphEdit> compoundEditStack = new Stack();
    private CompoundEdit deleteVertexCompound;
    private DeleteVertexEdit deleteVertexEdit;
    private boolean undoDeleteVertex;
    private ArrayList<Edge> correctIncidences = new ArrayList();
    private ArrayList<Integer> correctPositions = new ArrayList();

    public GraphUndoManager(Graph graph) {
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void undo() throws CannotUndoException {
        this.setWorking(true);
        try {
            super.undo();
        }
        finally {
            this.setWorking(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void redo() throws CannotRedoException {
        this.setWorking(true);
        try {
            super.redo();
        }
        finally {
            this.setWorking(false);
        }
    }

    public void beginEdit(String string) {
        CompoundGraphEdit compoundGraphEdit = new CompoundGraphEdit(string);
        this.addEdit(compoundGraphEdit);
        this.compoundEditStack.push(compoundGraphEdit);
    }

    public void endEdit() {
        CompoundGraphEdit compoundGraphEdit = this.compoundEditStack.pop();
        compoundGraphEdit.end();
    }

    @Override
    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.versions.clear();
    }

    @Override
    public void beforeCreateVertex(VertexClass vertexClass) {
    }

    @Override
    public void afterCreateVertex(Vertex vertex) {
        if (!this.isWorking()) {
            this.addEdit(new CreateVertexEdit(vertex));
        }
    }

    @Override
    public void beforeDeleteVertex(Vertex vertex) {
        if (!this.isWorking()) {
            assert (this.deleteVertexEdit == null);
            if (this.deleteVertexCompound == null) {
                this.deleteVertexCompound = new CompoundEdit(){
                    private static final long serialVersionUID = -2775885260931823100L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void undo() throws CannotUndoException {
                        GraphUndoManager.this.undoDeleteVertex = true;
                        try {
                            super.undo();
                            GraphUndoManager.this.restoreIncidencePositions();
                        }
                        finally {
                            GraphUndoManager.this.undoDeleteVertex = false;
                        }
                    }
                };
                this.addEdit(this.deleteVertexCompound);
            }
            this.deleteVertexEdit = new DeleteVertexEdit(vertex);
        }
    }

    @Override
    public void afterDeleteVertex(VertexClass vertexClass, boolean bl) {
        if (!this.isWorking()) {
            assert (this.deleteVertexCompound != null);
            assert (this.deleteVertexEdit != null);
            this.deleteVertexCompound.addEdit(this.deleteVertexEdit);
            this.deleteVertexEdit = null;
            if (bl) {
                this.deleteVertexCompound.end();
                this.deleteVertexCompound = null;
            }
        }
    }

    @Override
    public void beforeCreateEdge(EdgeClass edgeClass, Vertex vertex, Vertex vertex2) {
    }

    @Override
    public void afterCreateEdge(Edge edge) {
        if (!this.isWorking()) {
            this.addEdit(new CreateEdgeEdit(edge));
        }
    }

    @Override
    public void beforeDeleteEdge(Edge edge) {
        if (!this.isWorking()) {
            this.addEdit(new DeleteEdgeEdit(edge));
        }
    }

    @Override
    public void afterDeleteEdge(EdgeClass edgeClass, Vertex vertex, Vertex vertex2) {
    }

    @Override
    public void beforeChangeAlpha(Edge edge, Vertex vertex, Vertex vertex2) {
        if (!this.isWorking()) {
            this.addEdit(new ChangeIncidenceEdit(GraphEditEvent.CHANGE_ALPHA, edge, vertex, vertex2));
        }
    }

    @Override
    public void afterChangeAlpha(Edge edge, Vertex vertex, Vertex vertex2) {
    }

    @Override
    public void beforeChangeOmega(Edge edge, Vertex vertex, Vertex vertex2) {
        if (!this.isWorking()) {
            this.addEdit(new ChangeIncidenceEdit(GraphEditEvent.CHANGE_OMEGA, edge, vertex, vertex2));
        }
    }

    @Override
    public void afterChangeOmega(Edge edge, Vertex vertex, Vertex vertex2) {
    }

    @Override
    public <AEC extends AttributedElementClass<AEC, ?>> void beforeChangeAttribute(AttributedElement<AEC, ?> attributedElement, String string, Object object, Object object2) {
    }

    @Override
    public <AEC extends AttributedElementClass<AEC, ?>> void afterChangeAttribute(AttributedElement<AEC, ?> attributedElement, String string, Object object, Object object2) {
        if (!this.isWorking()) {
            this.addEdit(new ChangeAttributeEdit(attributedElement, string, object, object2));
        }
    }

    @Override
    public void beforePutIncidenceAfter(Edge edge, Edge edge2) {
        if (!this.isWorking()) {
            this.addEdit(new ChangeIncidenceOrderEdit(GraphEditEvent.PUT_INCIDENCE_AFTER, edge, edge2));
        }
    }

    @Override
    public void afterPutIncidenceAfter(Edge edge, Edge edge2) {
    }

    @Override
    public void beforePutIncidenceBefore(Edge edge, Edge edge2) {
        if (!this.isWorking()) {
            this.addEdit(new ChangeIncidenceOrderEdit(GraphEditEvent.PUT_INCIDENCE_BEFORE, edge, edge2));
        }
    }

    @Override
    public void afterPutIncidenceBefore(Edge edge, Edge edge2) {
    }

    private int incidencePosition(Edge edge) {
        assert (edge != null && edge.isValid());
        assert (this.graph.getTraversalContext() == null);
        Vertex vertex = edge.getThis();
        int n = 0;
        for (Edge edge2 : vertex.incidences()) {
            if (edge2.equals(edge)) {
                return n;
            }
            ++n;
        }
        throw new RuntimeException("Something is wrong, should never get here!");
    }

    protected void restoreIncidencePositions() {
        TraversalContext traversalContext = this.graph.setTraversalContext(null);
        int n = 0;
        for (Edge edge : this.correctIncidences) {
            assert (edge.isValid());
            this.putIncidenceAt(edge, this.correctPositions.get(n++));
            this.putIncidenceAt(edge.getReversedEdge(), this.correctPositions.get(n++));
        }
        this.correctIncidences.clear();
        this.correctPositions.clear();
        this.graph.setTraversalContext(traversalContext);
    }

    protected void putIncidenceAt(Edge edge, int n) {
        Edge edge2;
        assert (edge != null && edge.isValid());
        assert (this.graph.getTraversalContext() == null);
        assert (n >= 0 && n < edge.getThis().getDegree());
        Vertex vertex = edge.getThis();
        int n2 = 0;
        for (edge2 = vertex.getFirstIncidence(); edge2 != null && n2 != n; edge2 = edge2.getNextIncidence()) {
            if (edge2.equals(edge)) continue;
            ++n2;
        }
        if (edge2 != null) {
            if (!edge2.equals(edge)) {
                edge.putIncidenceBefore(edge2);
            }
        } else {
            edge.putIncidenceAfter(vertex.getLastIncidence());
        }
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    protected boolean isWorking() {
        return this.working;
    }

    protected void setWorking(boolean bl) {
        this.working = bl;
    }

    protected class ChangeAttributeEdit
    extends GraphEdit {
        private static final long serialVersionUID = 9147856388307821832L;
        private String attributeName;
        private Object newValue;
        private Object oldValue;

        ChangeAttributeEdit(AttributedElement<?, ?> attributedElement, String string, Object object, Object object2) {
            super(GraphEditEvent.CHANGE_ATTRIBUTE, attributedElement);
            this.attributeName = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.elementId > 0) {
                GraphUndoManager.this.graph.getVertex(this.elementId).setAttribute(this.attributeName, this.oldValue);
            } else if (this.elementId < 0) {
                GraphUndoManager.this.graph.getEdge(-this.elementId).setAttribute(this.attributeName, this.oldValue);
            } else {
                GraphUndoManager.this.graph.setAttribute(this.attributeName, this.oldValue);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (this.elementId > 0) {
                GraphUndoManager.this.graph.getVertex(this.elementId).setAttribute(this.attributeName, this.newValue);
            } else if (this.elementId < 0) {
                GraphUndoManager.this.graph.getEdge(-this.elementId).setAttribute(this.attributeName, this.newValue);
            } else {
                GraphUndoManager.this.graph.setAttribute(this.attributeName, this.newValue);
            }
        }

        @Override
        public String toString() {
            return super.toString() + " set " + this.attributeName + " from " + this.oldValue + " to " + this.newValue;
        }
    }

    protected class ChangeIncidenceEdit
    extends GraphEdit {
        private static final long serialVersionUID = 350404556440935178L;
        private int oldVertexId;
        private int newVertexId;
        private int oldVertexVersion;
        private int newVertexVersion;
        private int oldIncidencePosition;

        ChangeIncidenceEdit(GraphEditEvent graphEditEvent, Edge edge, Vertex vertex, Vertex vertex2) {
            super(graphEditEvent, edge);
            this.oldVertexId = vertex.getId();
            this.oldVertexVersion = this.elementVersion(this.oldVertexId);
            this.newVertexId = vertex2.getId();
            this.newVertexVersion = this.elementVersion(this.newVertexId);
            TraversalContext traversalContext = GraphUndoManager.this.graph.setTraversalContext(null);
            this.oldIncidencePosition = graphEditEvent == GraphEditEvent.CHANGE_ALPHA ? GraphUndoManager.this.incidencePosition(edge) : GraphUndoManager.this.incidencePosition(edge.getReversedEdge());
            GraphUndoManager.this.graph.setTraversalContext(traversalContext);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Vertex vertex = GraphUndoManager.this.graph.getVertex(this.oldVertexId);
            Edge edge = GraphUndoManager.this.graph.getEdge(-this.elementId);
            TraversalContext traversalContext = GraphUndoManager.this.graph.setTraversalContext(null);
            if (this.event == GraphEditEvent.CHANGE_ALPHA) {
                edge.setAlpha(vertex);
                GraphUndoManager.this.putIncidenceAt(edge, this.oldIncidencePosition);
            } else {
                edge.setOmega(vertex);
                GraphUndoManager.this.putIncidenceAt(edge.getReversedEdge(), this.oldIncidencePosition);
            }
            GraphUndoManager.this.graph.setTraversalContext(traversalContext);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            Vertex vertex = GraphUndoManager.this.graph.getVertex(this.newVertexId);
            Edge edge = GraphUndoManager.this.graph.getEdge(-this.elementId);
            if (this.event == GraphEditEvent.CHANGE_ALPHA) {
                edge.setAlpha(vertex);
            } else {
                edge.setOmega(vertex);
            }
        }

        @Override
        public void changeVertexId(int n, int n2, int n3, int n4) {
            if (this.oldVertexId == n && this.oldVertexVersion == n2) {
                this.oldVertexId = n3;
                this.oldVertexVersion = n4;
            }
            if (this.newVertexId == n && this.newVertexVersion == n2) {
                this.newVertexId = n3;
                this.newVertexVersion = n4;
            }
        }
    }

    protected class ChangeIncidenceOrderEdit
    extends GraphEdit {
        private static final long serialVersionUID = 1553029429775858722L;
        private int otherId;
        private int otherVersion;
        private int oldIncidencePos;
        private boolean thisOutgoing;
        private boolean otherOutgoing;

        public ChangeIncidenceOrderEdit(GraphEditEvent graphEditEvent, Edge edge, Edge edge2) {
            super(graphEditEvent, edge);
            this.otherId = -Math.abs(edge2.getId());
            this.otherVersion = this.elementVersion(this.otherId);
            this.thisOutgoing = edge.isNormal();
            this.otherOutgoing = edge2.isNormal();
            TraversalContext traversalContext = GraphUndoManager.this.graph.setTraversalContext(null);
            this.oldIncidencePos = GraphUndoManager.this.incidencePosition(edge);
            GraphUndoManager.this.graph.setTraversalContext(traversalContext);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Edge edge = GraphUndoManager.this.graph.getEdge(this.thisOutgoing ? -this.elementId : this.elementId);
            TraversalContext traversalContext = GraphUndoManager.this.graph.setTraversalContext(null);
            GraphUndoManager.this.putIncidenceAt(edge, this.oldIncidencePos);
            GraphUndoManager.this.graph.setTraversalContext(traversalContext);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            Edge edge = GraphUndoManager.this.graph.getEdge(this.thisOutgoing ? -this.elementId : this.elementId);
            Edge edge2 = GraphUndoManager.this.graph.getEdge(this.otherOutgoing ? -this.otherId : this.otherId);
            if (this.event == GraphEditEvent.PUT_INCIDENCE_AFTER) {
                edge.putIncidenceAfter(edge2);
            } else {
                edge.putIncidenceBefore(edge2);
            }
        }

        @Override
        void changeEdgeId(int n, int n2, int n3, int n4) {
            super.changeEdgeId(n, n2, n3, n4);
            if (this.otherId == n && this.otherVersion == n2) {
                this.otherId = n3;
                this.otherVersion = n4;
            }
        }

        @Override
        public String toString() {
            return super.toString() + ", old position=" + this.oldIncidencePos;
        }
    }

    protected class DeleteEdgeEdit
    extends DeleteElementEdit {
        private static final long serialVersionUID = 6430961207052596036L;
        private int alphaId;
        private int omegaId;
        private int alphaVersion;
        private int omegaVersion;
        private int alphaInc;
        private int omegaInc;

        public DeleteEdgeEdit(Edge edge) {
            super(GraphEditEvent.DELETE_EDGE, edge);
            assert (edge.isNormal());
            this.alphaId = edge.getAlpha().getId();
            this.alphaVersion = this.elementVersion(this.alphaId);
            this.omegaId = edge.getOmega().getId();
            this.omegaVersion = this.elementVersion(this.omegaId);
            TraversalContext traversalContext = GraphUndoManager.this.graph.setTraversalContext(null);
            this.alphaInc = GraphUndoManager.this.incidencePosition(edge);
            this.omegaInc = GraphUndoManager.this.incidencePosition(edge.getReversedEdge());
            GraphUndoManager.this.graph.setTraversalContext(traversalContext);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Vertex vertex = GraphUndoManager.this.graph.getVertex(this.alphaId);
            Vertex vertex2 = GraphUndoManager.this.graph.getVertex(this.omegaId);
            Edge edge = this.resurrectEdge((EdgeClass)this.aec, vertex, vertex2);
            this.restoreAttributes(edge);
            if (GraphUndoManager.this.undoDeleteVertex) {
                GraphUndoManager.this.correctIncidences.add(edge);
                GraphUndoManager.this.correctPositions.add(this.alphaInc);
                GraphUndoManager.this.correctPositions.add(this.omegaInc);
            } else {
                TraversalContext traversalContext = GraphUndoManager.this.graph.setTraversalContext(null);
                GraphUndoManager.this.putIncidenceAt(edge, this.alphaInc);
                GraphUndoManager.this.putIncidenceAt(edge.getReversedEdge(), this.omegaInc);
                GraphUndoManager.this.graph.setTraversalContext(traversalContext);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            GraphUndoManager.this.graph.deleteEdge(GraphUndoManager.this.graph.getEdge(-this.elementId));
        }

        @Override
        public void changeVertexId(int n, int n2, int n3, int n4) {
            if (this.alphaId == n && this.alphaVersion == n2) {
                this.alphaId = n3;
                this.alphaVersion = n4;
            }
            if (this.omegaId == n && this.omegaVersion == n2) {
                this.omegaId = n3;
                this.omegaVersion = n4;
            }
        }

        @Override
        public String toString() {
            return super.toString() + " from v" + this.alphaId + "-" + this.alphaVersion + " to v" + this.omegaId + "-" + this.omegaVersion;
        }
    }

    protected class DeleteVertexEdit
    extends DeleteElementEdit {
        private static final long serialVersionUID = -4787860787912669387L;

        public DeleteVertexEdit(Vertex vertex) {
            super(GraphEditEvent.DELETE_VERTEX, vertex);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Vertex vertex = this.resurrectVertex((VertexClass)this.aec);
            this.restoreAttributes(vertex);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            GraphUndoManager.this.graph.deleteVertex(GraphUndoManager.this.graph.getVertex(this.elementId));
        }
    }

    protected abstract class DeleteElementEdit
    extends GraphEdit {
        private static final long serialVersionUID = -6211867897158716199L;
        private Object[] attrValues;

        public DeleteElementEdit(GraphEditEvent graphEditEvent, GraphElement<?, ?> graphElement) {
            super(graphEditEvent, graphElement);
            this.attrValues = new Object[this.aec.getAttributeCount()];
            int n = 0;
            for (Attribute attribute : this.aec.getAttributeList()) {
                this.attrValues[n++] = graphElement.getAttribute(attribute.getName());
            }
        }

        protected void restoreAttributes(GraphElement<?, ?> graphElement) {
            assert (graphElement != null);
            assert (this.attrValues != null);
            int n = 0;
            for (Attribute attribute : this.aec.getAttributeList()) {
                graphElement.setAttribute(attribute.getName(), this.attrValues[n++]);
            }
        }
    }

    protected class CreateEdgeEdit
    extends GraphEdit {
        private static final long serialVersionUID = 8840782477572584494L;
        private int alphaId;
        private int omegaId;
        private int alphaVersion;
        private int omegaVersion;

        CreateEdgeEdit(Edge edge) {
            super(GraphEditEvent.CREATE_EDGE, edge);
            assert (edge.isNormal());
            this.alphaId = edge.getAlpha().getId();
            this.alphaVersion = this.elementVersion(this.alphaId);
            this.omegaId = edge.getOmega().getId();
            this.omegaVersion = this.elementVersion(this.omegaId);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            GraphUndoManager.this.graph.deleteEdge(GraphUndoManager.this.graph.getEdge(-this.elementId));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            Vertex vertex = GraphUndoManager.this.graph.getVertex(this.alphaId);
            Vertex vertex2 = GraphUndoManager.this.graph.getVertex(this.omegaId);
            this.resurrectEdge((EdgeClass)this.aec, vertex, vertex2);
        }

        @Override
        public void changeVertexId(int n, int n2, int n3, int n4) {
            if (this.alphaId == n && this.alphaVersion == n2) {
                this.alphaId = n3;
                this.alphaVersion = n4;
            }
            if (this.omegaId == n && this.omegaVersion == n4) {
                this.omegaId = n3;
                this.omegaVersion = n4;
            }
        }

        @Override
        public String toString() {
            return super.toString() + " from v" + this.alphaId + "-" + this.alphaVersion + " to v" + this.omegaId + "-" + this.omegaVersion;
        }
    }

    protected class CreateVertexEdit
    extends GraphEdit {
        private static final long serialVersionUID = 7455868109487075050L;

        CreateVertexEdit(Vertex vertex) {
            super(GraphEditEvent.CREATE_VERTEX, vertex);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            GraphUndoManager.this.graph.deleteVertex(GraphUndoManager.this.graph.getVertex(this.elementId));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.resurrectVertex((VertexClass)this.aec);
        }
    }

    protected abstract class GraphEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1100368833451887175L;
        GraphEdit prev;
        GraphEdit next;
        int elementId;
        int elementVersion;
        AttributedElementClass<?, ?> aec;
        GraphEditEvent event;

        GraphEdit(GraphEditEvent graphEditEvent, AttributedElement<?, ?> attributedElement) {
            this.event = graphEditEvent;
            this.aec = attributedElement.getAttributedElementClass();
            this.elementId = attributedElement instanceof Vertex ? ((Vertex)attributedElement).getId() : (attributedElement instanceof Edge ? -Math.abs(((Edge)attributedElement).getId()) : 0);
            this.elementVersion = this.elementVersion(this.elementId);
            if (GraphUndoManager.this.first == null) {
                GraphUndoManager.this.first = (GraphUndoManager.this.last = this);
            } else {
                this.prev = GraphUndoManager.this.last;
                ((GraphUndoManager)GraphUndoManager.this).last.next = this;
                GraphUndoManager.this.last = this;
            }
        }

        int elementVersion(Integer n) {
            Integer n2 = (Integer)GraphUndoManager.this.versions.get(n);
            if (n2 == null) {
                GraphUndoManager.this.versions.put(n, ++GraphUndoManager.this.version);
                return GraphUndoManager.this.version;
            }
            return n2;
        }

        Vertex resurrectVertex(VertexClass vertexClass) {
            Object t = GraphUndoManager.this.graph.createVertex(vertexClass);
            int n = this.elementId;
            int n2 = this.elementVersion;
            this.elementId = t.getId();
            this.elementVersion = ++GraphUndoManager.this.version;
            GraphUndoManager.this.versions.put(this.elementId, this.elementVersion);
            GraphEdit graphEdit = GraphUndoManager.this.first;
            while (graphEdit != null) {
                graphEdit.changeVertexId(n, n2, this.elementId, this.elementVersion);
                graphEdit = graphEdit.next;
            }
            return t;
        }

        Edge resurrectEdge(EdgeClass edgeClass, Vertex vertex, Vertex vertex2) {
            Object t = GraphUndoManager.this.graph.createEdge((EdgeClass)this.aec, vertex, vertex2);
            int n = this.elementId;
            int n2 = this.elementVersion;
            this.elementId = -t.getId();
            this.elementVersion = ++GraphUndoManager.this.version;
            GraphUndoManager.this.versions.put(this.elementId, this.elementVersion);
            GraphEdit graphEdit = GraphUndoManager.this.first;
            while (graphEdit != null) {
                graphEdit.changeEdgeId(n, n2, this.elementId, this.elementVersion);
                graphEdit = graphEdit.next;
            }
            return t;
        }

        @Override
        public String toString() {
            String string = super.toString() + ", ";
            string = string + (Object)((Object)this.event) + " " + this.aec.getSimpleName() + " ";
            string = string + (this.elementId > 0 ? "v" + this.elementId : (this.elementId < 0 ? "e" + -this.elementId : "graph")) + "-" + this.elementVersion;
            return string;
        }

        @Override
        public void die() {
            super.die();
            if (GraphUndoManager.this.first == this && GraphUndoManager.this.first == GraphUndoManager.this.last) {
                GraphUndoManager.this.first = (GraphUndoManager.this.last = null);
            } else {
                if (this.prev != null) {
                    this.prev.next = this.next;
                } else {
                    GraphUndoManager.this.first = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                } else {
                    GraphUndoManager.this.last = this.prev;
                }
            }
        }

        void changeVertexId(int n, int n2, int n3, int n4) {
            if (this.elementId > 0 && this.elementId == n && this.elementVersion == n2) {
                this.elementId = n3;
                this.elementVersion = n4;
            }
        }

        void changeEdgeId(int n, int n2, int n3, int n4) {
            if (this.elementId < 0 && this.elementId == n && this.elementVersion == n2) {
                this.elementId = n3;
                this.elementVersion = n2;
            }
        }
    }

    protected static enum GraphEditEvent {
        CREATE_VERTEX,
        CREATE_EDGE,
        DELETE_VERTEX,
        DELETE_EDGE,
        CHANGE_OMEGA,
        CHANGE_ALPHA,
        PUT_INCIDENCE_BEFORE,
        PUT_INCIDENCE_AFTER,
        CHANGE_ATTRIBUTE;

    }
}

