/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.xdot;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.utilities.gui.xdot.TextShape;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotLexer;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class XDotParser {
    private Color lineColor = Color.black;
    private Color fillColor = Color.black;
    private HashMap<String, Color> colorMap;
    private Font font = null;
    private Graph graph;
    private AttributedElement<?, ?> currentElement;
    private List<XDotShape> shapes;
    private GraphMarker<List<XDotShape>> elementShapes;
    private Rectangle2D bounds;
    private XDotLexer xdl;
    private XDotLexer.Token la;
    private int nestingDepth;

    public XDotParser(Graph graph, GraphMarker<List<XDotShape>> graphMarker) {
        this.graph = graph;
        this.elementShapes = graphMarker;
        this.colorMap = new HashMap();
        this.colorMap.put("black", Color.BLACK);
        this.colorMap.put("white", Color.WHITE);
        this.colorMap.put("red", Color.RED);
        this.colorMap.put("green", Color.GREEN);
        this.colorMap.put("blue", Color.BLUE);
        this.colorMap.put("yellow", Color.YELLOW);
        this.colorMap.put("cyan", Color.CYAN);
        this.colorMap.put("magenta", Color.MAGENTA);
        this.colorMap.put("gray", Color.GRAY);
    }

    private void parseDrawActions(String string) {
        DrawActionLexer drawActionLexer = new DrawActionLexer(string);
        char c = drawActionLexer.nextChar();
        while (c != '\u0000') {
            switch (c) {
                case 'C': 
                case 'c': {
                    int n;
                    int n2;
                    String string2 = drawActionLexer.nextString();
                    Object object = this.colorMap.get(string2);
                    if (object == null) {
                        if (string2.charAt(0) == '#') {
                            int n3 = Integer.parseInt(string2.substring(1, 3), 16);
                            n2 = Integer.parseInt(string2.substring(3, 5), 16);
                            n = Integer.parseInt(string2.substring(5, 7), 16);
                            if (string2.length() == 9) {
                                int n4 = Integer.parseInt(string2.substring(7, 9), 16);
                                object = new Color(n3, n2, n, n4);
                            } else {
                                object = new Color(n3, n2, n);
                            }
                        } else {
                            object = Color.black;
                        }
                        this.colorMap.put(string2, (Color)object);
                    }
                    if (c == 'c') {
                        this.lineColor = object;
                        break;
                    }
                    this.fillColor = object;
                    break;
                }
                case 'B': 
                case 'L': 
                case 'P': 
                case 'b': 
                case 'p': {
                    XDotShape xDotShape;
                    int n;
                    Path2D.Double double_;
                    int n2;
                    int n5 = drawActionLexer.nextInt();
                    Object object = new double[n5];
                    double[] dArray = new double[n5];
                    for (n2 = 0; n2 < n5; ++n2) {
                        object[n2] = drawActionLexer.nextDouble();
                        dArray[n2] = drawActionLexer.nextDouble();
                    }
                    if (c == 'p' || c == 'P' || c == 'L') {
                        double_ = new Path2D.Double();
                        for (n = 0; n < n5 - 1; ++n) {
                            double_.append(new Line2D.Double(object[n], dArray[n], object[n + 1], dArray[n + 1]), n != 0);
                        }
                        if (c != 'L') {
                            double_.closePath();
                        }
                        xDotShape = new XDotShape(double_, this.lineColor, c == 'P' ? this.fillColor : null, null, null);
                    } else {
                        double_ = new Path2D.Double();
                        for (n = 0; n < n5 - 1; n += 3) {
                            double_.append(new CubicCurve2D.Double(object[n], dArray[n], object[n + 1], dArray[n + 1], object[n + 2], dArray[n + 2], object[n + 3], dArray[n + 3]), n != 0);
                        }
                        xDotShape = new XDotShape(double_, this.lineColor, c == 'b' ? this.fillColor : null, null, null);
                    }
                    this.shapes.add(xDotShape);
                    this.addShapeToCurrentElement(xDotShape);
                    break;
                }
                case 'E': 
                case 'e': {
                    double d = drawActionLexer.nextDouble();
                    double d2 = drawActionLexer.nextDouble();
                    double d3 = drawActionLexer.nextDouble();
                    double d4 = drawActionLexer.nextDouble();
                    RectangularShape rectangularShape = new Ellipse2D.Double(d - d3, d2 - d4, d3 * 2.0, d4 * 2.0);
                    XDotShape xDotShape = new XDotShape(rectangularShape, this.lineColor, c == 'E' ? this.fillColor : null, null, null);
                    this.shapes.add(xDotShape);
                    this.addShapeToCurrentElement(xDotShape);
                    break;
                }
                case 'F': {
                    double d = drawActionLexer.nextDouble();
                    String string3 = drawActionLexer.nextString();
                    this.font = new Font(string3, 0, (int)d);
                    break;
                }
                case 'T': {
                    double d = drawActionLexer.nextDouble();
                    double d5 = drawActionLexer.nextDouble();
                    int n = drawActionLexer.nextInt();
                    double d6 = drawActionLexer.nextDouble();
                    String string4 = drawActionLexer.nextString();
                    RectangularShape rectangularShape = new TextShape(d, d5, n, d6, string4, this.font);
                    XDotShape xDotShape = new XDotShape(rectangularShape, null, null, this.lineColor, null);
                    this.shapes.add(xDotShape);
                    this.addShapeToCurrentElement(xDotShape);
                    break;
                }
                case 'S': {
                    String string2 = drawActionLexer.nextString();
                    break;
                }
                default: {
                    throw new RuntimeException(this.xdl.getLine() + ": FIXME Unknown action '" + c + "'");
                }
            }
            c = drawActionLexer.nextChar();
        }
    }

    public void addShapeToCurrentElement(XDotShape xDotShape) {
        if (this.currentElement == null) {
            return;
        }
        xDotShape.setElement(this.currentElement);
        ArrayList<XDotShape> arrayList = (ArrayList<XDotShape>)this.elementShapes.get(this.currentElement);
        if (arrayList == null) {
            arrayList = new ArrayList<XDotShape>();
            this.elementShapes.mark(this.currentElement, arrayList);
        }
        arrayList.add(xDotShape);
    }

    private String match() throws IOException {
        if (this.la.type == XDotLexer.Type.EOF) {
            throw new IOException(this.xdl.getLine() + ": Unexpected EOF");
        }
        String string = this.la.text;
        this.la = this.xdl.nextToken();
        return string;
    }

    private String matchID() throws IOException {
        if (this.la.type == XDotLexer.Type.EOF) {
            throw new IOException("Unexpected EOF");
        }
        if (this.la.type == XDotLexer.Type.SEPARATOR) {
            throw new IOException(this.xdl.getLine() + ": Expected ID, found " + this.la.text);
        }
        String string = this.la.text;
        this.la = this.xdl.nextToken();
        return string;
    }

    private String match(String string) throws IOException {
        if (this.la.type == XDotLexer.Type.EOF) {
            throw new IOException(this.xdl.getLine() + ": Expected " + string + " found EOF");
        }
        if (!string.equals(this.la.text)) {
            throw new IOException(this.xdl.getLine() + ": Expected " + string + " found " + this.la.text);
        }
        this.la = this.xdl.nextToken();
        return string;
    }

    private String matchOpt(String string) throws IOException {
        if (string.equals(this.la.text)) {
            return this.match();
        }
        return null;
    }

    private String matchOr(String ... stringArray) throws IOException {
        for (String string : stringArray) {
            if (!this.la.text.equals(string)) continue;
            return this.match();
        }
        throw new IOException(this.xdl.getLine() + ": Expected " + stringArray + " found " + this.la.text);
    }

    private void parseDot() throws IOException {
        this.matchOpt("strict");
        this.matchOr("digraph", "graph");
        if (!this.la.text.equals("{")) {
            this.matchID();
        }
        this.match("{");
        while (!this.la.text.equals("}")) {
            this.parseStatement();
        }
        this.match("}");
    }

    private void parseSubgraph() throws IOException {
        String string;
        this.matchOpt("subgraph");
        if (!this.la.text.equals("{") && (string = this.matchID()).startsWith("cluster_")) {
            this.setCurrentElement(string.substring(8));
        }
        ++this.nestingDepth;
        this.match("{");
        while (!this.la.text.equals("}")) {
            this.parseStatement();
        }
        this.match("}");
        --this.nestingDepth;
    }

    private void parseStatement() throws IOException {
        if (this.la.text.equals("{") || this.la.text.equals("subgraph")) {
            this.parseSubgraph();
        } else {
            String string = this.matchID();
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            if (this.la.text.equals("=")) {
                this.match();
                this.matchID();
            } else {
                Object object3;
                Object object2;
                while (this.la.text.equals("--") || this.la.text.equals("->")) {
                    this.match();
                    if (this.la.text.equals("{") || this.la.text.equals("subgraph")) {
                        this.parseSubgraph();
                        continue;
                    }
                    this.matchID();
                }
                while (this.la.text.equals("[")) {
                    this.match();
                    while (!this.la.text.equals("]")) {
                        object2 = this.matchID();
                        this.match("=");
                        object3 = this.matchID();
                        treeMap.put(object2, object3);
                        this.matchOpt(",");
                    }
                    this.match("]");
                }
                if (this.nestingDepth == 0 && string.equals("graph") && (object2 = (String)treeMap.get("bb")) != null) {
                    object3 = ((String)object2).split(",");
                    double d = Double.parseDouble(object3[0]);
                    double d2 = Double.parseDouble((String)object3[1]);
                    double d3 = Double.parseDouble((String)object3[2]);
                    double d4 = Double.parseDouble((String)object3[3]);
                    this.bounds = new Rectangle2D.Double(d, d2, d3, d4);
                }
                this.setCurrentElement((String)treeMap.get("id"));
                for (Object object3 : treeMap.keySet()) {
                    if (!((String)object3).matches("_(l|h|t|hl|tl)?draw_")) continue;
                    this.parseDrawActions((String)treeMap.get(object3));
                }
            }
        }
        this.matchOpt(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XDotShape> parseXDotFile(InputStream inputStream) throws IOException {
        this.shapes = new ArrayList<XDotShape>();
        this.elementShapes.clear();
        this.bounds = null;
        try {
            this.xdl = new XDotLexer(inputStream);
            this.la = this.xdl.nextToken();
            this.parseDot();
        }
        finally {
            inputStream.close();
        }
        return this.shapes;
    }

    private void setCurrentElement(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (string.charAt(0) == 'v') {
            this.currentElement = this.graph.getVertex(Integer.parseInt(string.substring(1)));
        } else if (string.charAt(0) == 'e') {
            this.currentElement = this.graph.getEdge(Integer.parseInt(string.substring(1)));
        } else {
            throw new IOException(this.xdl.getLine() + ": Unexpected element id " + string);
        }
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    final class DrawActionLexer {
        final String s;
        final char[] c;
        int p;

        DrawActionLexer(String string) {
            this.s = string;
            this.c = string.toCharArray();
            this.p = 0;
            this.consumeWhitespace();
        }

        final void consumeWhitespace() {
            while (this.p < this.c.length && Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
        }

        final char nextChar() {
            if (this.p >= this.c.length) {
                return '\u0000';
            }
            char c = this.c[this.p++];
            this.consumeWhitespace();
            return c;
        }

        final int nextInt() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int n = this.p;
            while (this.p < this.c.length && !Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
            int n2 = Integer.parseInt(this.s.substring(n, this.p));
            this.consumeWhitespace();
            return n2;
        }

        final double nextDouble() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int n = this.p;
            while (this.p < this.c.length && !Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
            double d = Double.parseDouble(this.s.substring(n, this.p));
            this.consumeWhitespace();
            return d;
        }

        final String nextString() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int n = this.nextInt();
            this.consumeWhitespace();
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            if (this.c[this.p] != '-') {
                throw new IllegalArgumentException();
            }
            ++this.p;
            String string = this.s.substring(this.p, this.p + n);
            this.p += n;
            this.consumeWhitespace();
            return string;
        }
    }
}

