/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.dot;

import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphElementType;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DotWriter {
    private static final String QUOTATIONMARKS = "\"";
    private static final String TABULATOR = "  ";
    public static final Set<String> allowedDotEdgeAttributes;
    public static final Set<String> allowedDotNodeAttributes;
    private PrintStream out;
    private int nestedDepth;
    public static final Map<String, String> reversableEdgeAttributePairs;

    public DotWriter(String string) throws FileNotFoundException {
        this.out = new PrintStream(string);
    }

    public DotWriter(File file) throws FileNotFoundException {
        this.out = new PrintStream(file);
    }

    public DotWriter(PrintStream printStream) {
        this.out = printStream;
    }

    public void startGraph(GraphType graphType, String string, String string2) {
        this.out.println("# Graph ID / Version: " + string2);
        this.startElement();
        this.out.print(graphType.name + " " + string + " ");
        this.startAbstractGroup();
    }

    public void startGroup() {
        this.startElement();
        this.startAbstractGroup();
    }

    private void startAbstractGroup() {
        ++this.nestedDepth;
        this.out.println('{');
    }

    public void endGroup() {
        --this.nestedDepth;
        this.startElement();
        this.out.println('}');
    }

    public void endGraph() {
        int n = this.nestedDepth;
        for (int i = 0; i < n; ++i) {
            this.endGroup();
        }
    }

    public void writeGeneralAttributeList(GraphElementType graphElementType, Map<String, String> map) {
        this.startElement();
        this.out.print(graphElementType.name);
        this.writeAttributeList(map);
        this.endElement();
    }

    private void writeAttributeList(Map<String, String> map) {
        if (map.isEmpty()) {
            return;
        }
        this.startAttributeList();
        String string = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.out.print(string);
            string = ", ";
            this.writeAttribute(entry.getKey(), entry.getValue());
        }
        this.endAttributeList();
    }

    private void startAttributeList() {
        this.out.print('[');
    }

    private void writeAttribute(String string, String string2) {
        this.out.print(string + " = ");
        boolean bl = string2.startsWith("<<") && string2.endsWith(">>");
        String string3 = bl ? "" : QUOTATIONMARKS;
        this.out.print(string3 + string2 + string3);
    }

    private void endAttributeList() {
        this.out.print(']');
    }

    private void startElement() {
        this.writeIndent();
    }

    private void writeIndent() {
        for (int i = 0; i < this.nestedDepth; ++i) {
            this.out.print(TABULATOR);
        }
    }

    private void endElement() {
        this.out.println(';');
    }

    public void writeEdge(String string, String string2, Map<String, String> map) {
        String[] stringArray = new String[]{string2};
        this.writeEdge(string, stringArray, map);
    }

    public void writeEdge(String string, String[] stringArray, Map<String, String> map) {
        this.startElement();
        this.out.print(this.processName(string) + " -> ");
        this.writeNodeList(stringArray);
        if (map != null) {
            this.writeAttributeList(map);
        }
        this.endElement();
    }

    public void writeNode(String string) {
        this.writeNode(string, null);
    }

    public void writeNode(String string, Map<String, String> map) {
        this.startElement();
        string = this.processName(string);
        this.out.print(string);
        if (map != null) {
            this.writeAttributeList(map);
        }
        this.endElement();
    }

    private String processName(String string) {
        if (string.contains(" ")) {
            string = QUOTATIONMARKS + string + QUOTATIONMARKS;
        }
        return string;
    }

    private void writeNodeList(String[] stringArray) {
        String string = "";
        for (String string2 : stringArray) {
            this.out.print(string);
            string = ", ";
            this.out.print(this.processName(string2));
        }
    }

    public void startSubgraph() {
        this.startElement();
        this.out.print("subgraph");
        this.startAbstractGroup();
    }

    public void startCluster(String string) {
        this.startElement();
        this.out.print("subgraph " + string);
        this.startAbstractGroup();
    }

    public void close() {
        this.endGraph();
        this.out.flush();
    }

    private static Map<String, String> createReversableEdgeAttributePairMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("headURL", "tailURL");
        hashMap.put("headclip", "tailclip");
        hashMap.put("headhref", "tailhref");
        hashMap.put("headlabel", "taillabel");
        hashMap.put("headport", "tailport");
        hashMap.put("headtarget", "tailtarget");
        hashMap.put("headtooltip", "tailtooltip");
        hashMap.put("arrowhead", "arrowtail");
        hashMap.put("lhead", "ltail");
        hashMap.put("samehead", "sametail");
        return Collections.unmodifiableMap(hashMap);
    }

    private static Set<String> createAllowedDotEdgeAttributes() {
        String[] stringArray = new String[]{"URL", "arrowhead", "arrowsize", "arrowtail", "color", "colorscheme", "comment", "constraint", "decorate", "dir", "edgeURL", "edgehref", "edgetarget", "edgetooltip", "fontcolor", "fontname", "fontsize", "headURL", "headclip", "headhref", "headlabel", "headport", "headtarget", "headtooltip", "href", "id", "label", "labelURL", "labelangle", "labeldistance", "labelfloat", "labelfontcolor", "labelfontname", "labelfontsize", "labelhref", "labeltarget", "labeltooltip", "layer", "len", "lhead", "lp", "ltail", "minlen", "nojustify", "penwidth", "pos", "samehead", "sametail", "showboxes", "style", "tailURL", "tailclip", "tailhref", "taillabel", "tailport", "tailtarget", "tailtooltip", "target", "tooltip", "weight"};
        List<String> list = Arrays.asList(stringArray);
        return Collections.unmodifiableSet(new HashSet<String>(list));
    }

    public static Set<String> createAllowedDotNodeAttributes() {
        String[] stringArray = new String[]{"URL", "color", "colorscheme", "comment", "distortion", "fillcolor", "fixedsize", "fontcolor", "fontname", "fontsize", "group", "height", "id", "image", "imagescale", "label", "labelloc", "layer", "margin", "nojustify", "orientation", "penwidth", "peripheries", "pin", "pos", "rects", "regular", "root", "samplepoints", "shape", "shapefile", "showboxes", "sides", "skew", "sortv", "style", "target", "tooltip", "vertices", "width"};
        List<String> list = Arrays.asList(stringArray);
        return Collections.unmodifiableSet(new HashSet<String>(list));
    }

    static {
        reversableEdgeAttributePairs = DotWriter.createReversableEdgeAttributePairMap();
        allowedDotEdgeAttributes = DotWriter.createAllowedDotEdgeAttributes();
        allowedDotNodeAttributes = DotWriter.createAllowedDotNodeAttributes();
    }
}

