/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.greql;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.GreqlQueryCache;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEvaluatorImpl;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.AbbreviateString;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.AlphaIncidenceNumber;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.AlphaRolename;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.AttributeType;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.FormatString;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.JoinWithCollection;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.OmegaIncidenceNumber;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.OmegaRolename;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.ShortenString;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.funlib.ToDotString;
import java.util.Map;

public class GreqlEvaluatorFacade {
    public static final String COMPOSITE_THAT = "compositeThat";
    public static final String SHARED_THAT = "sharedThat";
    public static final String COMPOSITE_THIS = "compositeThis";
    public static final String SHARED_THIS = "sharedThis";
    public static final String ELEMENT_SEQUENCE_INDEX = "elementSequenceIndex";
    public static final String TYPE = "type";
    public static final String ELEMENT = "el";
    public static final String PRINT_DOMAIN_NAMES = "printDomainNames";
    public static final String SHORTEN_STRINGS = "shortenStrings";
    public static final String ABBREVIATE_EDGE_ATTRIBUTE_NAMES = "abbreviateEdgeAttributeNames";
    public static final String PRINT_EDGE_ATTRIBUTES = "printEdgeAttributes";
    public static final String PRINT_ELEMENT_SEQUENCE_INDICES = "printElementSequenceIndices";
    public static final String PRINT_INCIDENCE_INDICES = "printIncidenceIndices";
    public static final String PRINT_ROLENAMES = "printRolenames";
    private final Graph dataGraph;
    private static Schema schema;
    private final GreqlEnvironment greqlEnvironment;
    private static GreqlQueryCache greqlQueryCache;

    public GreqlEvaluatorFacade(Graph graph) {
        this.dataGraph = graph;
        if (!graph.getSchema().equals(schema)) {
            greqlQueryCache.clear();
        }
        this.greqlEnvironment = new GreqlEnvironmentAdapter();
    }

    public void setStaticVariablesOfGreqlEvaluator(AttributedElementClass<?, ?> attributedElementClass) {
        if (attributedElementClass instanceof EdgeClass) {
            this.setStaticVariablesOfGreqlEvaluator((EdgeClass)attributedElementClass);
        } else if (attributedElementClass instanceof VertexClass) {
            this.setStaticVariablesOfGreqlEvaluator((VertexClass)attributedElementClass);
        } else {
            throw new RuntimeException("The class " + attributedElementClass.getClass().getSimpleName() + " hasn' been expected");
        }
    }

    private void setStaticVariablesOfGreqlEvaluator(VertexClass vertexClass) {
    }

    private void setStaticVariablesOfGreqlEvaluator(EdgeClass edgeClass) {
        AggregationKind aggregationKind = edgeClass.getFrom().getAggregationKind();
        this.setVariable(SHARED_THIS, aggregationKind == AggregationKind.SHARED);
        this.setVariable(COMPOSITE_THIS, aggregationKind == AggregationKind.COMPOSITE);
        aggregationKind = edgeClass.getTo().getAggregationKind();
        this.setVariable(SHARED_THAT, aggregationKind == AggregationKind.SHARED);
        this.setVariable(COMPOSITE_THAT, aggregationKind == AggregationKind.COMPOSITE);
    }

    protected void setTypeSpecificVariablesOfGreqlEvaluator(AttributedElement<?, ?> attributedElement, int n) {
        this.setVariablesOfGreqlEvaluator(attributedElement, n);
        if (attributedElement instanceof Vertex) {
            this.setVariablesOfGreqlEvaluator((Vertex)attributedElement);
        } else if (attributedElement instanceof Edge) {
            this.setVariablesOfGreqlEvaluator((Edge)attributedElement);
        } else {
            throw new RuntimeException("The class " + attributedElement.getClass().getSimpleName() + " hasn' been expected");
        }
    }

    public void setVariablesOfGreqlEvaluator(AttributedElement<?, ?> attributedElement, int n) {
        this.setVariable(ELEMENT, attributedElement);
        this.setVariable(TYPE, attributedElement.getAttributedElementClass());
        this.setVariable(ELEMENT_SEQUENCE_INDEX, n);
    }

    private void setVariablesOfGreqlEvaluator(Vertex vertex) {
    }

    private void setVariablesOfGreqlEvaluator(Edge edge) {
    }

    public String getUsingString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "using ";
        for (String string2 : this.greqlEnvironment.getVariableNames()) {
            stringBuilder.append(string);
            string = ", ";
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    public Object evaluate(String string) {
        string = this.getUsingString() + string;
        Object object = null;
        try {
            object = this.getQuery(string).evaluate(this.dataGraph, this.greqlEnvironment);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS = false;
        GreqlQueryImpl.DEBUG_OPTIMIZATION = false;
        return object;
    }

    private GreqlQuery getQuery(String string) {
        return greqlQueryCache.getQuery(string);
    }

    public void setVariable(String string, Object object) {
        this.greqlEnvironment.setVariable(string, object);
    }

    public void setVariablesWithGreqlValues(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Object object = this.evaluate(entry.getValue());
            this.greqlEnvironment.setVariable(entry.getKey(), object);
        }
    }

    public Schema getSchema() {
        return this.dataGraph.getSchema();
    }

    static {
        FunLib.register(ToDotString.class);
        FunLib.register(ShortenString.class);
        FunLib.register(AlphaRolename.class);
        FunLib.register(AlphaIncidenceNumber.class);
        FunLib.register(OmegaRolename.class);
        FunLib.register(OmegaIncidenceNumber.class);
        FunLib.register(AbbreviateString.class);
        FunLib.register(JoinWithCollection.class);
        FunLib.register(FormatString.class);
        FunLib.register(AttributeType.class);
        greqlQueryCache = new GreqlQueryCache();
    }
}

