/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2whatever;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public abstract class Tg2Whatever {
    protected Graph graph = null;
    protected String graphFileName = null;
    protected String schemaFileName = null;
    protected Schema schema = null;
    protected String outputName = null;
    protected boolean domainNames = false;
    protected boolean edgeAttributes = false;
    private boolean reversedEdges = false;
    private int currentElementSequenceIndex = -1;
    protected boolean roleNames = false;
    protected boolean shortenStrings = false;
    protected AbstractBooleanGraphMarker marker = null;

    public boolean isReversedEdges() {
        return this.reversedEdges;
    }

    public void setReversedEdges(boolean bl) {
        this.reversedEdges = bl;
    }

    public void setGraphMarker(AbstractBooleanGraphMarker abstractBooleanGraphMarker) {
        this.marker = abstractBooleanGraphMarker;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setSchema(String string) {
        this.schemaFileName = string;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setGraph(String string) throws GraphIOException {
        this.graphFileName = string;
        this.graph = GraphIO.loadGraphFromFile(this.graphFileName, new ConsoleProgressFunction("Loading"));
    }

    public void setOutputFile(String string) {
        this.outputName = string;
    }

    public void setPrintRoleNames(boolean bl) {
        this.roleNames = bl;
    }

    public void setShortenStrings(boolean bl) {
        this.shortenStrings = bl;
    }

    public void setPrintEdgeAttributes(boolean bl) {
        this.edgeAttributes = bl;
    }

    public void setPrintReversedEdges(boolean bl) {
        this.reversedEdges = bl;
    }

    public void setPrintDomainNames(boolean bl) {
        this.domainNames = bl;
    }

    public void convert() throws IOException {
        if (this.outputName == null || this.outputName.equals("")) {
            this.convert(System.out);
        } else {
            PrintStream printStream = new PrintStream(new FileOutputStream(this.outputName));
            this.convert(printStream);
            printStream.close();
        }
    }

    public void convert(PrintStream printStream) {
        this.initializeGraphAndSchema();
        this.graphStart(printStream);
        this.printVertices(printStream);
        this.printEdges(printStream);
        this.graphEnd(printStream);
    }

    private void printEdges(PrintStream printStream) {
        this.currentElementSequenceIndex = 0;
        for (Edge edge : this.graph.edges()) {
            ++this.currentElementSequenceIndex;
            if (this.marker != null && !this.marker.isMarked(edge)) continue;
            this.printEdge(printStream, edge);
        }
    }

    private void printVertices(PrintStream printStream) {
        this.currentElementSequenceIndex = 0;
        for (Vertex vertex : this.graph.vertices()) {
            ++this.currentElementSequenceIndex;
            if (this.marker != null && !this.marker.isMarked(vertex)) continue;
            this.printVertex(printStream, vertex);
        }
    }

    public int getCurrentElementSequenceIndex() {
        return this.currentElementSequenceIndex;
    }

    private void loadGraph() {
        try {
            System.out.println("Loading graph from file " + this.graphFileName);
            this.graph = GraphIO.loadGraphFromFile(this.graphFileName, this.schema, ImplementationType.STANDARD, new ConsoleProgressFunction("Loading"));
            System.out.println("Graph loaded");
        }
        catch (GraphIOException graphIOException) {
            System.err.println("Graph in file '" + this.graphFileName + "' could not be read.");
            graphIOException.printStackTrace();
            System.exit(1);
        }
    }

    private void loadSchemaFromGraph() {
        try {
            System.out.println("Loading Schema from Graph");
            this.schema = GraphIO.loadSchemaFromFile(this.graphFileName);
            this.schema.compile(CodeGeneratorConfiguration.MINIMAL);
            System.out.println("Schema loaded");
        }
        catch (GraphIOException graphIOException) {
            System.err.println("Graph in file '" + this.graphFileName + "' could not be read.");
            graphIOException.printStackTrace();
            System.exit(1);
        }
    }

    private void loadSchema() {
        try {
            System.out.println("Loaded schema");
            this.schema = GraphIO.loadSchemaFromFile(this.schemaFileName);
            System.out.println("Schema loaded");
        }
        catch (GraphIOException graphIOException) {
            System.err.println("Schema in file '" + this.schemaFileName + "' could not be read.");
            System.exit(1);
        }
    }

    protected abstract void graphStart(PrintStream var1);

    protected abstract void graphEnd(PrintStream var1);

    protected abstract void printVertex(PrintStream var1, Vertex var2);

    protected abstract void printEdge(PrintStream var1, Edge var2);

    protected abstract String stringQuote(String var1);

    protected void getOptions(String[] stringArray) {
        CommandLine commandLine = this.processCommandLineOptions(stringArray);
        assert (commandLine != null);
        String string = null;
        String string2 = null;
        if (commandLine.hasOption("g")) {
            try {
                string = commandLine.getOptionValue("g");
                this.setGraph(string);
            }
            catch (GraphIOException graphIOException) {
                System.err.println("Coundn't load graph in file '" + string + "': " + graphIOException.getMessage());
                if (graphIOException.getCause() != null) {
                    graphIOException.getCause().printStackTrace();
                }
                System.exit(1);
            }
        }
        if (commandLine.hasOption("o")) {
            this.outputName = commandLine.getOptionValue("o").trim();
        }
        if (commandLine.hasOption("a")) {
            string2 = commandLine.getOptionValue("a");
            this.setSchema(string2);
        }
        this.reversedEdges = commandLine.hasOption("r");
        this.domainNames = commandLine.hasOption("d");
        this.edgeAttributes = commandLine.hasOption("e");
        this.roleNames = commandLine.hasOption("n");
        this.shortenStrings = commandLine.hasOption("s");
        this.getAdditionalOptions(commandLine);
    }

    protected void getAdditionalOptions(CommandLine commandLine) {
    }

    protected void initializeGraphAndSchema() {
        if (this.graph == null) {
            if (this.schema == null) {
                if (this.schemaFileName != null) {
                    this.loadSchema();
                } else {
                    this.loadSchemaFromGraph();
                }
            }
            this.loadGraph();
        }
    }

    protected final CommandLine processCommandLineOptions(String[] stringArray) {
        OptionHandler optionHandler = this.createOptionHandler();
        this.addAdditionalOptions(optionHandler);
        return optionHandler.parse(stringArray);
    }

    protected void addAdditionalOptions(OptionHandler optionHandler) {
    }

    protected final OptionHandler createOptionHandler() {
        String string = "java " + this.getClass().getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("g", "graph", true, "(required): the graph to be converted");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("a", "alternative-schema", true, "(optional): the schema that should be used instead of the one included in the graph file");
        option2.setRequired(false);
        option.setArgName("file");
        optionHandler.addOption(option2);
        Option option3 = new Option("d", "domains", false, "(optional): if set, domain names of attributes will be printed");
        option3.setRequired(false);
        optionHandler.addOption(option3);
        Option option4 = new Option("e", "edgeattr", false, "(optional): if set, edge attributes will be printed");
        option4.setRequired(false);
        optionHandler.addOption(option4);
        Option option5 = new Option("n", "rolenames", false, "(optional): if set, role names will be printed");
        option5.setRequired(false);
        optionHandler.addOption(option5);
        Option option6 = new Option("o", "output", true, "(required): the output file name, or empty for stdout");
        option6.setRequired(true);
        option6.setArgName("file");
        optionHandler.addOption(option6);
        Option option7 = new Option("r", "reversed", false, "(optional): useful if edges run from child nodes to their parents results in a tree with root node at top");
        option7.setRequired(false);
        optionHandler.addOption(option7);
        Option option8 = new Option("s", "shorten-strings", false, "(optional): if set, strings are shortened");
        option8.setRequired(false);
        optionHandler.addOption(option8);
        return optionHandler;
    }
}

