/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.DepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;

public class RecursiveDepthFirstSearch
extends DepthFirstSearch {
    public RecursiveDepthFirstSearch(Graph graph, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
    }

    public RecursiveDepthFirstSearch(Graph graph) {
        this(graph, null);
    }

    @Override
    public RecursiveDepthFirstSearch execute(Vertex vertex) throws AlgorithmTerminatedException {
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && !traversalContext.containsVertex(vertex) || this.visitedVertices.get(vertex)) {
            return this;
        }
        this.startRunning();
        if (this.level != null) {
            this.level.set(vertex, 0);
        }
        this.number.set(vertex, this.num);
        this.visitors.visitRoot(vertex);
        this.dfs(vertex);
        this.done();
        return this;
    }

    private void dfs(Vertex vertex) throws AlgorithmTerminatedException {
        this.vertexOrder[this.num] = vertex;
        this.number.set(vertex, this.num);
        this.visitors.visitVertex(vertex);
        this.visitedVertices.set(vertex, true);
        ++this.num;
        for (Edge edge : vertex.incidences(this.traversalDirection)) {
            if (this.visitedEdges.get(edge) || this.navigable != null && !this.navigable.get(edge)) continue;
            Vertex vertex2 = edge.getThat();
            this.edgeOrder[this.eNum] = edge;
            if (this.enumber != null) {
                this.enumber.set(edge, this.eNum);
            }
            this.visitors.visitEdge(edge);
            this.visitedEdges.set(edge, true);
            ++this.eNum;
            if (!this.visitedVertices.get(vertex2)) {
                if (this.level != null) {
                    this.level.set(vertex2, this.level.get(vertex) + 1);
                }
                if (this.parent != null) {
                    this.parent.set(edge.getThat(), edge);
                }
                this.visitors.visitTreeEdge(edge);
                this.cancelIfInterrupted();
                this.dfs(vertex2);
                this.visitors.leaveTreeEdge(edge);
                continue;
            }
            this.visitors.visitFrond(edge);
            if (!this.rnumber.isDefined(vertex2)) {
                this.visitors.visitBackwardArc(edge);
                continue;
            }
            if (this.number.get(vertex) < this.number.get(vertex2)) {
                this.visitors.visitForwardArc(edge);
                continue;
            }
            this.visitors.visitCrosslink(edge);
        }
        this.rnumber.set(vertex, this.rNum);
        if (this.rorder != null) {
            this.rorder[this.rNum] = vertex;
        }
        this.visitors.leaveVertex(vertex);
        ++this.rNum;
    }

    @Override
    public RecursiveDepthFirstSearch execute() throws AlgorithmTerminatedException {
        super.execute();
        return this;
    }
}

