/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.EvaluatorUtilities;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.FiniteAutomaton;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.EvaluationInterruptedException;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.impl.std.GraphImpl;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import java.util.HashMap;
import java.util.Map;

public class GreqlEvaluatorImpl
implements InternalGreqlEvaluator {
    public static boolean DEBUG_DECLARATION_ITERATIONS = false;
    public static final int VERTEX_INDEX_SIZE = 50;
    private Graph graph = null;
    private Schema schema = null;
    private Object result = null;
    private Object[] localEvaluationResults;
    private Map<GreqlVertex, FiniteAutomaton> localAutomatons;
    private ProgressFunction progressFunction = null;
    private long progressStepsPassed;
    private long estimatedInterpretationSteps;
    private GreqlQueryImpl query;
    private GreqlEnvironment environment;
    private int cnt = 0;

    @Override
    public final void progress(long l) {
        if (++this.cnt == 4096) {
            if (Thread.interrupted()) {
                throw new EvaluationInterruptedException();
            }
            this.cnt = 0;
        }
        this.progressStepsPassed += l;
        if (this.progressFunction != null) {
            while (this.progressStepsPassed > this.progressFunction.getUpdateInterval()) {
                this.progressFunction.progress(1L);
                this.progressStepsPassed -= this.progressFunction.getUpdateInterval();
            }
        }
    }

    @Override
    public Object setLocalEvaluationResult(GreqlVertex greqlVertex, Object object) {
        Object object2 = this.localEvaluationResults[greqlVertex.getId()];
        this.localEvaluationResults[greqlVertex.getId()] = object;
        return object2;
    }

    @Override
    public Object getLocalEvaluationResult(GreqlVertex greqlVertex) {
        return this.localEvaluationResults[greqlVertex.getId()];
    }

    @Override
    public FiniteAutomaton setLocalAutomaton(GreqlVertex greqlVertex, FiniteAutomaton finiteAutomaton) {
        return this.localAutomatons.put(greqlVertex, finiteAutomaton);
    }

    @Override
    public FiniteAutomaton getLocalAutomaton(GreqlVertex greqlVertex) {
        return this.localAutomatons.get(greqlVertex);
    }

    @Override
    public Object removeLocalEvaluationResult(GreqlVertex greqlVertex) {
        return this.setLocalEvaluationResult(greqlVertex, null);
    }

    public Object getResult() {
        return this.evaluate();
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public GraphElementClass<?, ?> getGraphElementClass(String string) {
        return EvaluatorUtilities.getGraphElementClass(this.query.getRootExpression(), this.schema, string);
    }

    public GreqlEvaluatorImpl(GreqlQuery greqlQuery, Graph graph, GreqlEnvironment greqlEnvironment, ProgressFunction progressFunction) {
        this.initialize(greqlQuery, graph, greqlEnvironment, progressFunction);
    }

    public GreqlEvaluatorImpl(GreqlQuery greqlQuery, Graph graph, GreqlEnvironment greqlEnvironment) {
        this.initialize(greqlQuery, graph, greqlEnvironment, null);
    }

    private void initialize(GreqlQuery greqlQuery, Graph graph, GreqlEnvironment greqlEnvironment, ProgressFunction progressFunction) {
        this.query = (GreqlQueryImpl)greqlQuery;
        this.graph = graph;
        if (graph != null) {
            this.schema = graph.getSchema();
        }
        this.environment = greqlEnvironment;
        this.localEvaluationResults = new Object[((GraphImpl)((Object)greqlQuery.getQueryGraph())).getMaxVCount() + 1];
        this.localAutomatons = new HashMap<GreqlVertex, FiniteAutomaton>();
        this.progressFunction = progressFunction;
    }

    public Object evaluate(GreqlQuery greqlQuery, Graph graph, GreqlEnvironment greqlEnvironment, ProgressFunction progressFunction) {
        this.initialize(greqlQuery, graph, greqlEnvironment, progressFunction);
        return this.evaluate();
    }

    public Object evaluate() {
        this.query.resetVertexEvaluators(this);
        if (this.query.getQueryGraph().getVCount() <= 1) {
            this.result = Undefined.UNDEFINED;
            return this.result;
        }
        VertexEvaluator<GreqlExpression> vertexEvaluator = this.query.getVertexEvaluator(this.query.getRootExpression());
        if (this.progressFunction != null) {
            this.estimatedInterpretationSteps = vertexEvaluator.getInitialSubtreeEvaluationCosts();
            this.progressFunction.init(this.estimatedInterpretationSteps);
        }
        this.result = vertexEvaluator.getResult(this);
        if (this.progressFunction != null) {
            this.progressFunction.finished();
        }
        return this.result;
    }

    @Override
    public Object setVariable(String string, Object object) {
        return this.environment.setVariable(string, object);
    }

    @Override
    public Object getVariable(String string) {
        return this.environment.getVariable(string);
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

