/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.EvaluatorUtilities;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UndefinedVariableException;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsIdOfStoreClause;
import de.uni_koblenz.jgralab.greql.schema.Variable;

public class GreqlExpressionEvaluator
extends VertexEvaluator<GreqlExpression> {
    protected static final int greql2ExpressionCostsFactor = 3;

    private void initializeBoundVariables(InternalGreqlEvaluator internalGreqlEvaluator) {
        for (IsBoundVarOf isBoundVarOf = ((GreqlExpression)this.vertex).getFirstIsBoundVarOfIncidence(EdgeDirection.IN); isBoundVarOf != null; isBoundVarOf = isBoundVarOf.getNextIsBoundVarOfIncidence(EdgeDirection.IN)) {
            Variable variable = isBoundVarOf.getAlpha();
            Object object = internalGreqlEvaluator.getVariable(variable.get_name());
            if (object == null) {
                throw new UndefinedVariableException(variable, this.createSourcePositions(isBoundVarOf));
            }
            VariableEvaluator variableEvaluator = (VariableEvaluator)this.query.getVertexEvaluator(variable);
            variableEvaluator.setValue(object, internalGreqlEvaluator);
        }
    }

    public GreqlExpressionEvaluator(GreqlExpression greqlExpression, GreqlQueryImpl greqlQueryImpl) {
        super(greqlExpression, greqlQueryImpl);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        EvaluatorUtilities.checkImports((GreqlExpression)this.vertex, internalGreqlEvaluator.getSchema());
        this.initializeBoundVariables(internalGreqlEvaluator);
        Expression expression = ((GreqlExpression)this.vertex).getFirstIsQueryExprOfIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> vertexEvaluator = this.query.getVertexEvaluator(expression);
        Object object = vertexEvaluator.getResult(internalGreqlEvaluator);
        IsIdOfStoreClause isIdOfStoreClause = ((GreqlExpression)this.vertex).getFirstIsIdOfStoreClauseIncidence(EdgeDirection.IN);
        if (isIdOfStoreClause != null) {
            VertexEvaluator<Identifier> vertexEvaluator2 = this.query.getVertexEvaluator(isIdOfStoreClause.getAlpha());
            String string = vertexEvaluator2.getResult(internalGreqlEvaluator).toString();
            internalGreqlEvaluator.setVariable(string, object);
        }
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        return object;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        long l;
        GreqlExpression greqlExpression = (GreqlExpression)this.getVertex();
        VertexEvaluator<Expression> vertexEvaluator = this.query.getVertexEvaluator(greqlExpression.getFirstIsQueryExprOfIncidence().getAlpha());
        long l2 = vertexEvaluator.getCurrentSubtreeEvaluationCosts();
        int n = 0;
        for (IsBoundVarOf isBoundVarOf = greqlExpression.getFirstIsBoundVarOfIncidence(); isBoundVarOf != null; isBoundVarOf = isBoundVarOf.getNextIsBoundVarOfIncidence()) {
            ++n;
        }
        long l3 = l = (long)(n * 3);
        long l4 = l + l2;
        return new VertexCosts(l, l3, l4);
    }
}

