/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsGoalRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsStartRestrOf;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public abstract class PathDescriptionEvaluator<V extends PathDescription>
extends VertexEvaluator<V> {
    public PathDescriptionEvaluator(V v, GreqlQueryImpl greqlQueryImpl) {
        super(v, greqlQueryImpl);
    }

    public NFA getNFA(InternalGreqlEvaluator internalGreqlEvaluator) {
        NFA nFA = (NFA)internalGreqlEvaluator.getLocalAutomaton(this.vertex);
        if (nFA == null) {
            nFA = (NFA)this.getResult(internalGreqlEvaluator);
            internalGreqlEvaluator.setLocalAutomaton(this.vertex, nFA);
        }
        return nFA;
    }

    @Override
    public Object getResult(InternalGreqlEvaluator internalGreqlEvaluator) {
        NFA nFA = (NFA)internalGreqlEvaluator.getLocalAutomaton(this.vertex);
        if (nFA == null) {
            Object object = this.evaluate(internalGreqlEvaluator);
            nFA = (NFA)object;
            internalGreqlEvaluator.setLocalAutomaton(this.vertex, nFA);
            this.addGoalRestrictions(internalGreqlEvaluator);
            this.addStartRestrictions(internalGreqlEvaluator);
        }
        if (internalGreqlEvaluator.getLocalEvaluationResult(this.vertex) == null) {
            internalGreqlEvaluator.setLocalEvaluationResult(this.vertex, nFA);
        }
        return internalGreqlEvaluator.getLocalEvaluationResult(this.vertex);
    }

    protected void addGoalRestrictions(InternalGreqlEvaluator internalGreqlEvaluator) {
        PathDescription pathDescription = (PathDescription)this.getVertex();
        VertexEvaluator<Expression> vertexEvaluator = null;
        IsGoalRestrOf isGoalRestrOf = pathDescription.getFirstIsGoalRestrOfIncidence(EdgeDirection.IN);
        if (isGoalRestrOf == null) {
            return;
        }
        TypeCollection typeCollection = TypeCollection.empty();
        while (isGoalRestrOf != null) {
            VertexEvaluator<Expression> vertexEvaluator2 = this.query.getVertexEvaluator(isGoalRestrOf.getAlpha());
            if (vertexEvaluator2 instanceof TypeIdEvaluator) {
                TypeIdEvaluator typeIdEvaluator = (TypeIdEvaluator)vertexEvaluator2;
                typeCollection = typeCollection.combine((TypeCollection)typeIdEvaluator.getResult(internalGreqlEvaluator));
            } else {
                vertexEvaluator = vertexEvaluator2;
            }
            isGoalRestrOf = isGoalRestrOf.getNextIsGoalRestrOfIncidence(EdgeDirection.IN);
        }
        try {
            typeCollection = typeCollection.bindToSchema(internalGreqlEvaluator);
        }
        catch (UnknownTypeException unknownTypeException) {
            throw new UnknownTypeException(unknownTypeException.getTypeName(), this.createPossibleSourcePositions());
        }
        NFA.addGoalTypeRestriction(this.getNFA(internalGreqlEvaluator), typeCollection);
        if (vertexEvaluator != null) {
            NFA.addGoalBooleanRestriction(this.getNFA(internalGreqlEvaluator), vertexEvaluator, this.query);
        }
    }

    protected void addStartRestrictions(InternalGreqlEvaluator internalGreqlEvaluator) {
        PathDescription pathDescription = (PathDescription)this.getVertex();
        VertexEvaluator<Expression> vertexEvaluator = null;
        IsStartRestrOf isStartRestrOf = pathDescription.getFirstIsStartRestrOfIncidence(EdgeDirection.IN);
        if (isStartRestrOf == null) {
            return;
        }
        TypeCollection typeCollection = TypeCollection.empty();
        while (isStartRestrOf != null) {
            VertexEvaluator<Expression> vertexEvaluator2 = this.query.getVertexEvaluator(isStartRestrOf.getAlpha());
            if (vertexEvaluator2 instanceof TypeIdEvaluator) {
                TypeIdEvaluator typeIdEvaluator = (TypeIdEvaluator)vertexEvaluator2;
                typeCollection = typeCollection.combine((TypeCollection)typeIdEvaluator.getResult(internalGreqlEvaluator));
            } else {
                vertexEvaluator = vertexEvaluator2;
            }
            isStartRestrOf = isStartRestrOf.getNextIsStartRestrOfIncidence(EdgeDirection.IN);
        }
        try {
            typeCollection = typeCollection.bindToSchema(internalGreqlEvaluator);
        }
        catch (UnknownTypeException unknownTypeException) {
            throw new UnknownTypeException(unknownTypeException.getTypeName(), this.createPossibleSourcePositions());
        }
        NFA.addStartTypeRestriction(this.getNFA(internalGreqlEvaluator), typeCollection);
        if (vertexEvaluator != null) {
            NFA.addStartBooleanRestriction(this.getNFA(internalGreqlEvaluator), vertexEvaluator, this.query);
        }
    }
}

