/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ElementSetExpressionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.schema.IsTypeRestrOfExpression;
import de.uni_koblenz.jgralab.greql.schema.VertexSetExpression;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import org.pcollections.PSet;

public class VertexSetExpressionEvaluator
extends ElementSetExpressionEvaluator<VertexSetExpression> {
    public VertexSetExpressionEvaluator(VertexSetExpression vertexSetExpression, GreqlQueryImpl greqlQueryImpl) {
        super(vertexSetExpression, greqlQueryImpl);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        TypeCollection typeCollection = this.getTypeCollection(internalGreqlEvaluator);
        PSet<Object> pSet = null;
        if (pSet == null) {
            pSet = JGraLab.set();
            for (Vertex vertex = internalGreqlEvaluator.getGraph().getFirstVertex(); vertex != null; vertex = vertex.getNextVertex()) {
                if (!typeCollection.acceptsType(vertex.getAttributedElementClass())) continue;
                pSet = pSet.plus(vertex);
            }
        }
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        return pSet;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        VertexSetExpression vertexSetExpression = (VertexSetExpression)this.getVertex();
        long l = 0L;
        for (IsTypeRestrOfExpression isTypeRestrOfExpression = vertexSetExpression.getFirstIsTypeRestrOfExpressionIncidence(); isTypeRestrOfExpression != null; isTypeRestrOfExpression = isTypeRestrOfExpression.getNextIsTypeRestrOfExpressionIncidence()) {
            TypeIdEvaluator typeIdEvaluator = (TypeIdEvaluator)this.query.getVertexEvaluator(isTypeRestrOfExpression.getAlpha());
            l += typeIdEvaluator.getCurrentSubtreeEvaluationCosts();
        }
        long l2 = this.query.getOptimizer().getOptimizerInfo().getAverageVertexCount();
        return new VertexCosts(l2, l2, l + l2);
    }

    @Override
    public long calculateEstimatedCardinality() {
        long l;
        if (this.typeCollection != null) {
            l = this.typeCollection.getEstimatedGraphElementCount(this.query.getOptimizer().getOptimizerInfo());
        } else {
            VertexSetExpression vertexSetExpression = (VertexSetExpression)this.getVertex();
            IsTypeRestrOfExpression isTypeRestrOfExpression = vertexSetExpression.getFirstIsTypeRestrOfExpressionIncidence();
            double d = 1.0;
            if (isTypeRestrOfExpression != null) {
                TypeIdEvaluator typeIdEvaluator = (TypeIdEvaluator)this.query.getVertexEvaluator(isTypeRestrOfExpression.getAlpha());
                d = typeIdEvaluator.getEstimatedSelectivity();
            }
            l = Math.round((double)this.query.getOptimizer().getOptimizerInfo().getAverageVertexCount() * d);
        }
        logger.fine("VertexSet estimated cardinality " + this.typeCollection + ": " + l);
        return l;
    }
}

