/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import org.pcollections.PMap;
import org.pcollections.POrderedMap;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;

public class Difference
extends Function {
    @Description(params={"a", "b"}, description="Returns the set-difference a-b.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PSet<T> evaluate(PSet<T> pSet, PSet<T> pSet2) {
        if (pSet2.isEmpty()) {
            if (pSet instanceof POrderedSet) {
                return pSet;
            }
            return JGraLab.set().plusAll(pSet);
        }
        if (pSet instanceof POrderedSet) {
            return pSet.minusAll(pSet2);
        }
        return JGraLab.set().plusAll(pSet).minusAll(pSet2);
    }

    @Description(params={"a", "b"}, description="Returns the map-difference a-b, w.r.t. the keyset of the maps.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <K, V> PMap<K, V> evaluate(PMap<K, V> pMap, PMap<K, V> pMap2) {
        if (pMap2.isEmpty()) {
            if (pMap instanceof POrderedMap) {
                return pMap;
            }
            PMap<K, V> pMap3 = JGraLab.map();
            return pMap3.plusAll(pMap);
        }
        if (pMap instanceof POrderedMap) {
            return pMap.minusAll(pMap2.keySet());
        }
        PMap<K, V> pMap4 = JGraLab.map();
        return pMap4.plusAll(pMap).minusAll(pMap2.keySet());
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        return arrayList.get(0) + arrayList.get(1);
    }

    @Override
    public long getEstimatedCardinality(int n) {
        return n;
    }
}

