/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

@NeedsGraphArgument
public class FirstVertex
extends Function {
    public FirstVertex() {
        super(4L, 1L, 1.0);
    }

    @Description(params={"g"}, description="Returns the first vertex of the graph g.", categories={Function.Category.GRAPH})
    public Vertex evaluate(Graph graph) {
        return graph.getFirstVertex();
    }

    @Description(params={"g", "c"}, description="Returns the first vertex of the graph g.\nThe scope is limited by a type collection.", categories={Function.Category.GRAPH})
    public Vertex evaluate(Graph graph, TypeCollection typeCollection) {
        Vertex vertex;
        for (vertex = graph.getFirstVertex(); vertex != null && !typeCollection.acceptsType(vertex.getAttributedElementClass()); vertex = vertex.getNextVertex()) {
        }
        return vertex;
    }
}

