/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.types.pathsearch.VertexStateQueue;
import java.util.HashSet;
import org.pcollections.PSet;

@NeedsEvaluatorArgument
public class ReachableVertices
extends Function {
    @Description(params={"internal", "v", "dfa"}, description="Returns all vertices that are reachable from the given vertex by a path matching the the given path description.", categories={Function.Category.GRAPH, Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public ReachableVertices() {
        super(100L, 10L, 1.0);
    }

    public PSet<Vertex> evaluate(InternalGreqlEvaluator internalGreqlEvaluator, Vertex vertex, DFA dFA) {
        return ReachableVertices.search(internalGreqlEvaluator, vertex, dFA);
    }

    public static PSet<Vertex> search(InternalGreqlEvaluator internalGreqlEvaluator, Vertex vertex, DFA dFA) {
        PSet<Vertex> pSet = JGraLab.set();
        HashSet[] hashSetArray = new HashSet[dFA.stateList.size()];
        for (Object object : dFA.stateList) {
            hashSetArray[((State)object).number] = new HashSet(100);
        }
        VertexStateQueue vertexStateQueue = new VertexStateQueue();
        hashSetArray[dFA.initialState.number].add(vertex);
        vertexStateQueue.put(vertex, dFA.initialState);
        while (vertexStateQueue.hasNext()) {
            Object object;
            object = vertexStateQueue.currentVertex;
            State state = vertexStateQueue.currentState;
            if (state.isFinal) {
                pSet = pSet.plus((Vertex)object);
            }
            for (Edge edge = object.getFirstIncidence(); edge != null; edge = edge.getNextIncidence()) {
                int n = state.outTransitions.size();
                for (int i = 0; i < n; ++i) {
                    Transition transition = state.outTransitions.get(i);
                    Vertex vertex2 = transition.getNextVertex((Vertex)object, edge);
                    if (hashSetArray[transition.endState.number].contains(vertex2) || !transition.accepts((Vertex)object, edge, internalGreqlEvaluator)) continue;
                    hashSetArray[transition.endState.number].add(vertex2);
                    vertexStateQueue.put(vertex2, transition.endState);
                }
            }
        }
        return pSet;
    }
}

